# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class RemediationDeploymentSummary(Model):
    """The deployment status summary for all deployments created by the
    remediation.

    :param total_deployments: The number of deployments required by the
     remediation.
    :type total_deployments: int
    :param successful_deployments: The number of deployments required by the
     remediation that have succeeded.
    :type successful_deployments: int
    :param failed_deployments: The number of deployments required by the
     remediation that have failed.
    :type failed_deployments: int
    """

    _attribute_map = {
        'total_deployments': {'key': 'totalDeployments', 'type': 'int'},
        'successful_deployments': {'key': 'successfulDeployments', 'type': 'int'},
        'failed_deployments': {'key': 'failedDeployments', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(RemediationDeploymentSummary, self).__init__(**kwargs)
        self.total_deployments = kwargs.get('total_deployments', None)
        self.successful_deployments = kwargs.get('successful_deployments', None)
        self.failed_deployments = kwargs.get('failed_deployments', None)
