# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .tracked_resource_py3 import TrackedResource


class RestorableDroppedManagedDatabase(TrackedResource):
    """A restorable dropped managed database resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :ivar database_name: The name of the database.
    :vartype database_name: str
    :ivar creation_date: The creation date of the database (ISO8601 format).
    :vartype creation_date: datetime
    :ivar deletion_date: The deletion date of the database (ISO8601 format).
    :vartype deletion_date: datetime
    :ivar earliest_restore_date: The earliest restore date of the database
     (ISO8601 format).
    :vartype earliest_restore_date: datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'database_name': {'readonly': True},
        'creation_date': {'readonly': True},
        'deletion_date': {'readonly': True},
        'earliest_restore_date': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'database_name': {'key': 'properties.databaseName', 'type': 'str'},
        'creation_date': {'key': 'properties.creationDate', 'type': 'iso-8601'},
        'deletion_date': {'key': 'properties.deletionDate', 'type': 'iso-8601'},
        'earliest_restore_date': {'key': 'properties.earliestRestoreDate', 'type': 'iso-8601'},
    }

    def __init__(self, *, location: str, tags=None, **kwargs) -> None:
        super(RestorableDroppedManagedDatabase, self).__init__(location=location, tags=tags, **kwargs)
        self.database_name = None
        self.creation_date = None
        self.deletion_date = None
        self.earliest_restore_date = None
