# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class PostRestoreRequest(Model):
    """Post Restore Request.

    :param partition: Post Restore partition.
    :type partition: str
    :param replica_group: Post Restore replica group.
    :type replica_group: str
    :param request_id: Post Restore request id.
    :type request_id: str
    :param azure_file_share_uri: Post Restore Azure file share uri.
    :type azure_file_share_uri: str
    :param status: Post Restore Azure status.
    :type status: str
    :param source_azure_file_share_uri: Post Restore Azure source azure file
     share uri.
    :type source_azure_file_share_uri: str
    :param failed_file_list: Post Restore Azure failed file list.
    :type failed_file_list: str
    :param restore_file_spec: Post Restore restore file spec array.
    :type restore_file_spec:
     list[~azure.mgmt.storagesync.models.RestoreFileSpec]
    """

    _attribute_map = {
        'partition': {'key': 'partition', 'type': 'str'},
        'replica_group': {'key': 'replicaGroup', 'type': 'str'},
        'request_id': {'key': 'requestId', 'type': 'str'},
        'azure_file_share_uri': {'key': 'azureFileShareUri', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'source_azure_file_share_uri': {'key': 'sourceAzureFileShareUri', 'type': 'str'},
        'failed_file_list': {'key': 'failedFileList', 'type': 'str'},
        'restore_file_spec': {'key': 'restoreFileSpec', 'type': '[RestoreFileSpec]'},
    }

    def __init__(self, **kwargs):
        super(PostRestoreRequest, self).__init__(**kwargs)
        self.partition = kwargs.get('partition', None)
        self.replica_group = kwargs.get('replica_group', None)
        self.request_id = kwargs.get('request_id', None)
        self.azure_file_share_uri = kwargs.get('azure_file_share_uri', None)
        self.status = kwargs.get('status', None)
        self.source_azure_file_share_uri = kwargs.get('source_azure_file_share_uri', None)
        self.failed_file_list = kwargs.get('failed_file_list', None)
        self.restore_file_spec = kwargs.get('restore_file_spec', None)
