# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .proxy_resource import ProxyResource


class ServerEndpointCreateParameters(ProxyResource):
    """The parameters used when creating a server endpoint.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param server_local_path: Server Local path.
    :type server_local_path: str
    :param cloud_tiering: Cloud Tiering. Possible values include: 'on', 'off'
    :type cloud_tiering: str or ~azure.mgmt.storagesync.models.enum
    :param volume_free_space_percent: Level of free space to be maintained by
     Cloud Tiering if it is enabled.
    :type volume_free_space_percent: int
    :param tier_files_older_than_days: Tier files older than days.
    :type tier_files_older_than_days: int
    :param friendly_name: Friendly Name
    :type friendly_name: str
    :param server_resource_id: Server Resource Id.
    :type server_resource_id: str
    :param offline_data_transfer: Offline data transfer. Possible values
     include: 'on', 'off'
    :type offline_data_transfer: str or ~azure.mgmt.storagesync.models.enum
    :param offline_data_transfer_share_name: Offline data transfer share name
    :type offline_data_transfer_share_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'volume_free_space_percent': {'maximum': 100, 'minimum': 0},
        'tier_files_older_than_days': {'maximum': 2147483647, 'minimum': 0},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'server_local_path': {'key': 'properties.serverLocalPath', 'type': 'str'},
        'cloud_tiering': {'key': 'properties.cloudTiering', 'type': 'str'},
        'volume_free_space_percent': {'key': 'properties.volumeFreeSpacePercent', 'type': 'int'},
        'tier_files_older_than_days': {'key': 'properties.tierFilesOlderThanDays', 'type': 'int'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'server_resource_id': {'key': 'properties.serverResourceId', 'type': 'str'},
        'offline_data_transfer': {'key': 'properties.offlineDataTransfer', 'type': 'str'},
        'offline_data_transfer_share_name': {'key': 'properties.offlineDataTransferShareName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ServerEndpointCreateParameters, self).__init__(**kwargs)
        self.server_local_path = kwargs.get('server_local_path', None)
        self.cloud_tiering = kwargs.get('cloud_tiering', None)
        self.volume_free_space_percent = kwargs.get('volume_free_space_percent', None)
        self.tier_files_older_than_days = kwargs.get('tier_files_older_than_days', None)
        self.friendly_name = kwargs.get('friendly_name', None)
        self.server_resource_id = kwargs.get('server_resource_id', None)
        self.offline_data_transfer = kwargs.get('offline_data_transfer', None)
        self.offline_data_transfer_share_name = kwargs.get('offline_data_transfer_share_name', None)
