# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ServerEndpointUpdateParameters(Model):
    """Parameters for updating an Server Endpoint.

    :param cloud_tiering: Cloud Tiering. Possible values include: 'on', 'off'
    :type cloud_tiering: str or ~azure.mgmt.storagesync.models.enum
    :param volume_free_space_percent: Level of free space to be maintained by
     Cloud Tiering if it is enabled.
    :type volume_free_space_percent: int
    :param tier_files_older_than_days: Tier files older than days.
    :type tier_files_older_than_days: int
    :param offline_data_transfer: Offline data transfer. Possible values
     include: 'on', 'off'
    :type offline_data_transfer: str or ~azure.mgmt.storagesync.models.enum
    :param offline_data_transfer_share_name: Offline data transfer share name
    :type offline_data_transfer_share_name: str
    """

    _validation = {
        'volume_free_space_percent': {'maximum': 100, 'minimum': 0},
        'tier_files_older_than_days': {'maximum': 2147483647, 'minimum': 0},
    }

    _attribute_map = {
        'cloud_tiering': {'key': 'properties.cloudTiering', 'type': 'str'},
        'volume_free_space_percent': {'key': 'properties.volumeFreeSpacePercent', 'type': 'int'},
        'tier_files_older_than_days': {'key': 'properties.tierFilesOlderThanDays', 'type': 'int'},
        'offline_data_transfer': {'key': 'properties.offlineDataTransfer', 'type': 'str'},
        'offline_data_transfer_share_name': {'key': 'properties.offlineDataTransferShareName', 'type': 'str'},
    }

    def __init__(self, *, cloud_tiering=None, volume_free_space_percent: int=None, tier_files_older_than_days: int=None, offline_data_transfer=None, offline_data_transfer_share_name: str=None, **kwargs) -> None:
        super(ServerEndpointUpdateParameters, self).__init__(**kwargs)
        self.cloud_tiering = cloud_tiering
        self.volume_free_space_percent = volume_free_space_percent
        self.tier_files_older_than_days = tier_files_older_than_days
        self.offline_data_transfer = offline_data_transfer
        self.offline_data_transfer_share_name = offline_data_transfer_share_name
