# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class AutoScalingPolicy(Model):
    """Describes the auto scaling policy.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the auto scaling policy.
    :type name: str
    :param trigger: Required. Determines when auto scaling operation will be
     invoked.
    :type trigger: ~azure.servicefabric.models.AutoScalingTrigger
    :param mechanism: Required. The mechanism that is used to scale when auto
     scaling operation is invoked.
    :type mechanism: ~azure.servicefabric.models.AutoScalingMechanism
    """

    _validation = {
        'name': {'required': True},
        'trigger': {'required': True},
        'mechanism': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'trigger': {'key': 'trigger', 'type': 'AutoScalingTrigger'},
        'mechanism': {'key': 'mechanism', 'type': 'AutoScalingMechanism'},
    }

    def __init__(self, *, name: str, trigger, mechanism, **kwargs) -> None:
        super(AutoScalingPolicy, self).__init__(**kwargs)
        self.name = name
        self.trigger = trigger
        self.mechanism = mechanism
