'\" t
.\" Manual page created with latex2man on Fri Jan 13 08:33:21 PST 2017
.\" NOTE: This file is generated, DO NOT EDIT.
.de Vb
.ft CW
.nf
..
.de Ve
.ft R

.fi
..
.TH "UNW\\_SET\\_CACHE\\_SIZE" "3" "13 January 2017" "Programming Library " "Programming Library "
.SH NAME
unw_set_cache_size
\-\- set unwind cache size 
.PP
.SH SYNOPSIS

.PP
#include <libunwind.h>
.br
.PP
int
unw_set_cache_size(unw_addr_space_t
as,
size_t
size,
int
flag);
.br
.PP
.SH DESCRIPTION

.PP
The unw_set_cache_size()
routine sets the cache size of 
address space as
to hold at least as many items as given by 
argument size\&.
It may hold more items as determined by the 
implementation. To disable caching, call 
unw_set_caching_policy)
with a policy of 
UNW_CACHE_NONE\&.
Flag is currently unused and must be 0. 
.PP
.SH RETURN VALUE

.PP
On successful completion, unw_set_cache_size()
returns 0. 
Otherwise the negative value of one of the error\-codes below is 
returned. 
.PP
.SH THREAD AND SIGNAL SAFETY

.PP
unw_set_cache_size()
is thread\-safe but \fInot\fP
safe 
to use from a signal handler. 
.PP
.SH ERRORS

.PP
.TP
UNW_ENOMEM
 The desired cache size could not be 
established because the application is out of memory. 
.PP
.SH SEE ALSO

.PP
libunwind(3),
unw_create_addr_space(3),
unw_set_caching_policy(3),
unw_flush_cache(3)
.PP
.SH AUTHOR

.PP
Dave Watson
.br
Email: \fBdade.watson@gmail.com\fP
.br
WWW: \fBhttp://www.nongnu.org/libunwind/\fP\&.
.\" NOTE: This file is generated, DO NOT EDIT.
