F# コンパイラサービス
=====================

F# コンパイラサービスパッケージはF# コンパイラのソースコードから派生したコンポーネントです。
このソースコードにはF# 言語バインディングを実装するための機能や、
コンパイラやリファクタリングツールを元にしたツールを作成するための機能が追加されています。
また、パッケージには自身のアプリケーションにF# スクリプトを埋め込む際に利用できるような
F# インタラクティブサービスも含まれています。

<div class="row">
  <div class="span1"></div>
  <div class="span6">
    <div class="well well-small" id="nuget">
      F# コンパイラサービスパッケージは <a href="https://nuget.org/packages/FSharp.Compiler.Service">NuGet経由でインストールできます</a>:
      <pre>PM> Install-Package FSharp.Compiler.Service</pre>
    </div>
  </div>
  <div class="span1"></div>
</div>

利用可能なサービス
------------------

プロジェクトには現在以下のサービスがあり、いずれもテストされ、
このページから参照可能なドキュメントがあります。
ライブラリには他にも使用可能な公開APIがありますが、
ここではドキュメント化されていません。

 * [** F# 言語トークナイザ **](tokenizer.html) - F#ソースコードをトークンのストリームへと変換します。
   この機能はソースコードを色つき表示したり、基本的なツールを作成するような場合に有効です。
   ネストされたコメントや文字列なども適切に処理できます。

 * [** 型無しASTの処理 **](untypedtree.html) - この機能を使うことで型無し抽象構文木(AST: abstract syntax tree)にアクセスできます。
   型無しASTとは型情報を含まない解析済みのF#の文法を表すもので、
   コードフォーマットやその他様々な単純処理に利用できます。

 * [** エディタ (IDE) サービスの使用 **](editor.html) - 自動補完やツールチップ、
   引数の情報などを表示するための機能があります。
   この機能を使うと、F#サポート機能をエディタに追加したり、F#コードから
   何らかの型情報を取得したりすることができるようになります。

 * [** シグネチャや型、解決済みのシンボルの処理 **](symbols.html) - 
   解決済みのシンボルや推測された型の表現、アセンブリ全体のシグネチャなどを
   型のチェック時に返すような多数のサービスがあります。

 * [** 複数プロジェクトやプロジェクト全体の処理 **](project.html) - 
   すべてのプロジェクトに対するチェックを実行することにより、
   プロジェクト全体の解析結果を使って\[すべての参照の検索\] のような
   機能を実現できます。

 * [** F# Interactive のホスティング **](interactive.html) - 自身の.NETコードから
   F# Interactiveを.NETライブラリとして呼び出すことができるようになります。
   このAPIを使用すると、自身のプロジェクト内でF#をスクリプト言語として
   埋め込むことができるようになります。

 * [** F#コンパイラのホスティング **](compiler.html) - F# コンパイラを
   呼び出すコードを組み込むことができます。

 * [** ファイルシステムAPI **](filesystem.html) - `FSharp.Compiler.Service` コンポーネントには
   ファイルシステムを表すグローバル変数が定義されています。
   この変数を設定することによって、ファイルシステムが使用できない状況であっても
   コンパイラをホストすることができるようになります。

> **注釈:** FSharp.Compiler.Service.dll には既存のものと重複する機能が多数あるため、
  将来的にはもっときちんとした形に変更されます。
  そのため、これらのサービスを使用するAPIには破壊的変更が加えられる可能性があります。

貢献および著作権について
------------------------

このプロジェクトは [fsharp/fsharp](https://github.com/fsharp/fsharp) からフォークしたもので、
そこへさらにエディタやF#用ツール、F# Interactiveの組み込みに必要となる機能を
追加したものです。

F# ソースコードの著作権はMicrosoft Corporationおよび貢献者に、
拡張機能の著作権は Dave Thomas, Anh-Dung Phan, Tomas Petricek および
その他の貢献者にあります。
ソースコードは [MIT ライセンス](https://github.com/fsharp/FSharp.Compiler.Service/blob/master/LICENSE) の元に公開されています。
