## Release 5.0

### New Rules

Rule ID | Category | Severity | Notes
--------|----------|----------|-------
CA1000 | Design | Hidden | DoNotDeclareStaticMembersOnGenericTypesAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1000)
CA1001 | Design | Hidden | TypesThatOwnDisposableFieldsShouldBeDisposableAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1001)
CA1002 | Design | Disabled | DoNotExposeGenericLists, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1002)
CA1003 | Design | Disabled | UseGenericEventHandlerInstancesAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1003)
CA1005 | Design | Disabled | AvoidExcessiveParametersOnGenericTypes, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1005)
CA1008 | Design | Disabled | EnumsShouldHaveZeroValueAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1008)
CA1010 | Design | Hidden | CollectionsShouldImplementGenericInterfaceAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1010)
CA1012 | Design | Disabled | AbstractTypesShouldNotHaveConstructorsAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1012)
CA1014 | Design | Disabled | MarkAssembliesWithAttributesDiagnosticAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1014)
CA1016 | Design | Info | MarkAssembliesWithAttributesDiagnosticAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1016)
CA1017 | Design | Disabled | MarkAssembliesWithComVisibleAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1017)
CA1018 | Design | Info | MarkAttributesWithAttributeUsageAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1018)
CA1019 | Design | Disabled | DefineAccessorsForAttributeArgumentsAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1019)
CA1021 | Design | Disabled | AvoidOutParameters, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1021)
CA1024 | Design | Disabled | UsePropertiesWhereAppropriateAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1024)
CA1027 | Design | Disabled | EnumWithFlagsAttributeAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1027)
CA1028 | Design | Disabled | EnumStorageShouldBeInt32Analyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1028)
CA1030 | Design | Disabled | UseEventsWhereAppropriateAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1030)
CA1031 | Design | Disabled | DoNotCatchGeneralExceptionTypesAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1031)
CA1032 | Design | Disabled | ImplementStandardExceptionConstructorsAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1032)
CA1033 | Design | Disabled | InterfaceMethodsShouldBeCallableByChildTypesAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1033)
CA1034 | Design | Disabled | NestedTypesShouldNotBeVisibleAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1034)
CA1036 | Design | Hidden | OverrideMethodsOnComparableTypesAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1036)
CA1040 | Design | Disabled | AvoidEmptyInterfacesAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1040)
CA1041 | Design | Info | ProvideObsoleteAttributeMessageAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1041)
CA1043 | Design | Disabled | UseIntegralOrStringArgumentForIndexersAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1043)
CA1044 | Design | Disabled | PropertiesShouldNotBeWriteOnlyAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1044)
CA1045 | Design | Disabled | DoNotPassTypesByReference, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1045)
CA1046 | Design | Disabled | DoNotOverloadOperatorEqualsOnReferenceTypes, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1046)
CA1047 | Design | Info | DoNotDeclareProtectedMembersInSealedTypes, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1047)
CA1050 | Design | Info | DeclareTypesInNamespacesAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1050)
CA1051 | Design | Hidden | DoNotDeclareVisibleInstanceFieldsAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1051)
CA1052 | Design | Disabled | StaticHolderTypesAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1052)
CA1054 | Design | Disabled | UriParametersShouldNotBeStringsAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1054)
CA1055 | Design | Disabled | UriReturnValuesShouldNotBeStringsAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1055)
CA1056 | Design | Disabled | UriPropertiesShouldNotBeStringsAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1056)
CA1058 | Design | Disabled | TypesShouldNotExtendCertainBaseTypesAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1058)
CA1060 | Design | Disabled | MovePInvokesToNativeMethodsClassAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1060)
CA1061 | Design | Info | DoNotHideBaseClassMethodsAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1061)
CA1062 | Design | Disabled | ValidateArgumentsOfPublicMethods, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1062)
CA1063 | Design | Disabled | ImplementIDisposableCorrectlyAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1063)
CA1064 | Design | Disabled | ExceptionsShouldBePublicAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1064)
CA1065 | Design | Disabled | DoNotRaiseExceptionsInUnexpectedLocationsAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1065)
CA1066 | Design | Disabled | EquatableAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1066)
CA1067 | Design | Info | EquatableAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1067)
CA1068 | Design | Info | CancellationTokenParametersMustComeLastAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1068)
CA1069 | Design | Info | EnumShouldNotHaveDuplicatedValues, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1069)
CA1070 | Design | Info | DoNotDeclareEventFieldsAsVirtual, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1070)
CA1200 | Documentation | Hidden | AvoidUsingCrefTagsWithAPrefixAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1200)
CA1303 | Globalization | Disabled | DoNotPassLiteralsAsLocalizedParameters, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1303)
CA1304 | Globalization | Hidden | SpecifyCultureInfoAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1304)
CA1305 | Globalization | Hidden | SpecifyIFormatProviderAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1305)
CA1307 | Globalization | Disabled | SpecifyStringComparisonAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1307)
CA1308 | Globalization | Disabled | NormalizeStringsToUppercaseAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1308)
CA1309 | Globalization | Hidden | UseOrdinalStringComparisonAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1309)
CA1310 | Globalization | Hidden | SpecifyStringComparisonAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1310)
CA1401 | Interoperability | Info | PInvokeDiagnosticAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1401)
CA1416 | Interoperability | Warning | PlatformCompatibilityAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1416)
CA1417 | Interoperability | Warning | DoNotUseOutAttributeStringPInvokeParametersAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1417)
CA1501 | Maintainability | Disabled | CodeMetricsAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1501)
CA1502 | Maintainability | Disabled | CodeMetricsAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1502)
CA1505 | Maintainability | Disabled | CodeMetricsAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1505)
CA1506 | Maintainability | Disabled | CodeMetricsAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1506)
CA1507 | Maintainability | Info | UseNameofInPlaceOfStringAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1507)
CA1508 | Maintainability | Disabled | AvoidDeadConditionalCode, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1508)
CA1509 | Maintainability | Disabled | CodeMetricsAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1509)
CA1700 | Naming | Disabled | DoNotNameEnumValuesReserved, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1700)
CA1707 | Naming | Hidden | IdentifiersShouldNotContainUnderscoresAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1707)
CA1708 | Naming | Hidden | IdentifiersShouldDifferByMoreThanCaseAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1708)
CA1710 | Naming | Hidden | IdentifiersShouldHaveCorrectSuffixAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1710)
CA1711 | Naming | Hidden | IdentifiersShouldNotHaveIncorrectSuffixAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1711)
CA1712 | Naming | Hidden | DoNotPrefixEnumValuesWithTypeNameAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1712)
CA1713 | Naming | Disabled | EventsShouldNotHaveBeforeOrAfterPrefix, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1713)
CA1715 | Naming | Hidden | IdentifiersShouldHaveCorrectPrefixAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1715)
CA1716 | Naming | Hidden | IdentifiersShouldNotMatchKeywordsAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1716)
CA1720 | Naming | Hidden | IdentifiersShouldNotContainTypeNames, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1720)
CA1721 | Naming | Disabled | PropertyNamesShouldNotMatchGetMethodsAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1721)
CA1724 | Naming | Disabled | TypeNamesShouldNotMatchNamespacesAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1724)
CA1725 | Naming | Hidden | ParameterNamesShouldMatchBaseDeclarationAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1725)
CA1801 | Usage | Disabled | ReviewUnusedParametersAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1801)
CA1802 | Performance | Disabled | UseLiteralsWhereAppropriateAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1802)
CA1805 | Performance | Hidden | DoNotInitializeUnnecessarilyAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1805)
CA1806 | Performance | Info | DoNotIgnoreMethodResultsAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1806)
CA1810 | Performance | Disabled | InitializeStaticFieldsInlineAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1810)
CA1812 | Performance | Disabled | AvoidUninstantiatedInternalClassesAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1812)
CA1813 | Performance | Disabled | AvoidUnsealedAttributesAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1813)
CA1814 | Performance | Disabled | PreferJaggedArraysOverMultidimensionalAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1814)
CA1815 | Performance | Disabled | OverrideEqualsAndOperatorEqualsOnValueTypesAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1815)
CA1816 | Usage | Info | CallGCSuppressFinalizeCorrectlyAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1816)
CA1819 | Performance | Disabled | PropertiesShouldNotReturnArraysAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1819)
CA1820 | Performance | Disabled | TestForEmptyStringsUsingStringLengthAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1820)
CA1821 | Performance | Info | RemoveEmptyFinalizersAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1821)
CA1822 | Performance | Info | MarkMembersAsStaticAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1822)
CA1823 | Performance | Disabled | AvoidUnusedPrivateFieldsAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1823)
CA1824 | Performance | Info | MarkAssembliesWithNeutralResourcesLanguageAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1824)
CA1825 | Performance | Info | AvoidZeroLengthArrayAllocationsAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1825)
CA1826 | Performance | Info | DoNotUseEnumerableMethodsOnIndexableCollectionsInsteadUseTheCollectionDirectlyAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1826)
CA1827 | Performance | Info | UseCountProperlyAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1827)
CA1828 | Performance | Info | UseCountProperlyAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1828)
CA1829 | Performance | Info | UseCountProperlyAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1829)
CA1830 | Performance | Info | PreferTypedStringBuilderAppendOverloads, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1830)
CA1831 | Performance | Warning | UseAsSpanInsteadOfRangeIndexerAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1831)
CA1832 | Performance | Info | UseAsSpanInsteadOfRangeIndexerAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1832)
CA1833 | Performance | Info | UseAsSpanInsteadOfRangeIndexerAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1833)
CA1834 | Performance | Info | PreferConstCharOverConstUnitStringAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1834)
CA1835 | Performance | Info | PreferStreamAsyncMemoryOverloads, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1835)
CA1836 | Performance | Info | UseCountProperlyAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1836)
CA1837 | Performance | Info | UseEnvironmentProcessId, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1837)
CA1838 | Performance | Hidden | AvoidStringBuilderPInvokeParametersAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1838)
CA2000 | Reliability | Disabled | DisposeObjectsBeforeLosingScope, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca2000)
CA2002 | Reliability | Disabled | DoNotLockOnObjectsWithWeakIdentityAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca2002)
CA2007 | Reliability | Disabled | DoNotDirectlyAwaitATaskAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca2007)
CA2008 | Reliability | Disabled | DoNotCreateTasksWithoutPassingATaskSchedulerAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca2008)
CA2009 | Reliability | Info | DoNotCallToImmutableCollectionOnAnImmutableCollectionValueAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca2009)
CA2011 | Reliability | Info | AvoidInfiniteRecursion, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca2011)
CA2012 | Reliability | Info | UseValueTasksCorrectlyAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca2012)
CA2013 | Reliability | Warning | DoNotUseReferenceEqualsWithValueTypesAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca2013)
CA2014 | Reliability | Warning | DoNotUseStackallocInLoopsAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca2014)
CA2015 | Reliability | Warning | DoNotDefineFinalizersForTypesDerivedFromMemoryManager, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca2015)
CA2016 | Reliability | Info | ForwardCancellationTokenToInvocationsAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca2016)
CA2100 | Security | Disabled | ReviewSqlQueriesForSecurityVulnerabilities, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca2100)
CA2101 | Globalization | Info | PInvokeDiagnosticAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca2101)
CA2109 | Security | Disabled | ReviewVisibleEventHandlersAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca2109)
CA2119 | Security | Disabled | SealMethodsThatSatisfyPrivateInterfacesAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca2119)
CA2153 | Security | Disabled | DoNotCatchCorruptedStateExceptionsAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca2153)
CA2200 | Usage | Warning | RethrowToPreserveStackDetailsAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca2200)
CA2201 | Usage | Hidden | DoNotRaiseReservedExceptionTypesAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca2201)
CA2207 | Usage | Disabled | InitializeStaticFieldsInlineAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca2207)
CA2208 | Usage | Info | InstantiateArgumentExceptionsCorrectlyAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca2208)
CA2211 | Usage | Info | NonConstantFieldsShouldNotBeVisibleAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca2211)
CA2213 | Usage | Disabled | DisposableFieldsShouldBeDisposed, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca2213)
CA2214 | Usage | Disabled | DoNotCallOverridableMethodsInConstructorsAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca2214)
CA2215 | Usage | Hidden | DisposeMethodsShouldCallBaseClassDispose, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca2215)
CA2216 | Usage | Disabled | DisposableTypesShouldDeclareFinalizerAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca2216)
CA2217 | Usage | Disabled | EnumWithFlagsAttributeAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca2217)
CA2219 | Usage | Info | DoNotRaiseExceptionsInExceptionClausesAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca2219)
CA2225 | Usage | Disabled | OperatorOverloadsHaveNamedAlternatesAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca2225)
CA2226 | Usage | Disabled | OperatorsShouldHaveSymmetricalOverloadsAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca2226)
CA2227 | Usage | Disabled | CollectionPropertiesShouldBeReadOnlyAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca2227)
CA2229 | Usage | Hidden | SerializationRulesDiagnosticAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca2229)
CA2231 | Usage | Info | OverloadOperatorEqualsOnOverridingValueTypeEqualsAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca2231)
CA2234 | Usage | Disabled | PassSystemUriObjectsInsteadOfStringsAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca2234)
CA2235 | Usage | Disabled | SerializationRulesDiagnosticAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca2235)
CA2237 | Usage | Disabled | SerializationRulesDiagnosticAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca2237)
CA2241 | Usage | Info | ProvideCorrectArgumentsToFormattingMethodsAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca2241)
CA2242 | Usage | Info | TestForNaNCorrectlyAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca2242)
CA2243 | Usage | Disabled | AttributeStringLiteralsShouldParseCorrectlyAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca2243)
CA2244 | Usage | Info | AvoidDuplicateElementInitialization, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca2244)
CA2245 | Usage | Info | AvoidPropertySelfAssignment, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca2245)
CA2246 | Usage | Info | AssigningSymbolAndItsMemberInSameStatement, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca2246)
CA2247 | Usage | Warning | DoNotCreateTaskCompletionSourceWithWrongArguments, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca2247)
CA2248 | Usage | Info | ProvideCorrectArgumentToEnumHasFlag, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca2248)
CA2249 | Usage | Info | PreferStringContainsOverIndexOfAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca2249)
CA2300 | Security | Disabled | DoNotUseInsecureDeserializerBinaryFormatterMethods, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca2300)
CA2301 | Security | Disabled | DoNotUseInsecureDeserializerBinaryFormatterWithoutBinder, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca2301)
CA2302 | Security | Disabled | DoNotUseInsecureDeserializerBinaryFormatterWithoutBinder, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca2302)
CA2305 | Security | Disabled | DoNotUseInsecureDeserializerLosFormatter, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca2305)
CA2310 | Security | Disabled | DoNotUseInsecureDeserializerNetDataContractSerializerMethods, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca2310)
CA2311 | Security | Disabled | DoNotUseInsecureDeserializerNetDataContractSerializerWithoutBinder, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca2311)
CA2312 | Security | Disabled | DoNotUseInsecureDeserializerNetDataContractSerializerWithoutBinder, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca2312)
CA2315 | Security | Disabled | DoNotUseInsecureDeserializerObjectStateFormatter, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca2315)
CA2321 | Security | Disabled | DoNotUseInsecureDeserializerJavaScriptSerializerWithSimpleTypeResolver, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca2321)
CA2322 | Security | Disabled | DoNotUseInsecureDeserializerJavaScriptSerializerWithSimpleTypeResolver, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca2322)
CA2326 | Security | Disabled | JsonNetTypeNameHandling, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca2326)
CA2327 | Security | Disabled | DoNotUseInsecureSettingsForJsonNet, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca2327)
CA2328 | Security | Disabled | DoNotUseInsecureSettingsForJsonNet, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca2328)
CA2329 | Security | Disabled | DoNotUseInsecureDeserializerJsonNetWithoutBinder, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca2329)
CA2330 | Security | Disabled | DoNotUseInsecureDeserializerJsonNetWithoutBinder, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca2330)
CA2350 | Security | Disabled | DoNotUseDataTableReadXml, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca2350)
CA2351 | Security | Disabled | DoNotUseDataSetReadXml, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca2351)
CA2352 | Security | Disabled | DataSetDataTableInSerializableTypeAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca2352)
CA2353 | Security | Disabled | DataSetDataTableInSerializableTypeAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca2353)
CA2354 | Security | Disabled | DataSetDataTableInIFormatterSerializableObjectGraphAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca2354)
CA2355 | Security | Disabled | DataSetDataTableInSerializableObjectGraphAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca2355)
CA2356 | Security | Disabled | DataSetDataTableInWebSerializableObjectGraphAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca2356)
CA2361 | Security | Disabled | DoNotUseDataSetReadXml, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca2361)
CA2362 | Security | Disabled | DataSetDataTableInSerializableTypeAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca2362)
CA3001 | Security | Disabled | ReviewCodeForSqlInjectionVulnerabilities, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca3001)
CA3002 | Security | Disabled | ReviewCodeForXssVulnerabilities, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca3002)
CA3003 | Security | Disabled | ReviewCodeForFilePathInjectionVulnerabilities, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca3003)
CA3004 | Security | Disabled | ReviewCodeForInformationDisclosureVulnerabilities, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca3004)
CA3005 | Security | Disabled | ReviewCodeForLdapInjectionVulnerabilities, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca3005)
CA3006 | Security | Disabled | ReviewCodeForCommandExecutionVulnerabilities, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca3006)
CA3007 | Security | Disabled | ReviewCodeForOpenRedirectVulnerabilities, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca3007)
CA3008 | Security | Disabled | ReviewCodeForXPathInjectionVulnerabilities, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca3008)
CA3009 | Security | Disabled | ReviewCodeForXmlInjectionVulnerabilities, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca3009)
CA3010 | Security | Disabled | ReviewCodeForXamlInjectionVulnerabilities, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca3010)
CA3011 | Security | Disabled | ReviewCodeForDllInjectionVulnerabilities, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca3011)
CA3012 | Security | Disabled | ReviewCodeForRegexInjectionVulnerabilities, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca3012)
CA3061 | Security | Hidden | DoNotAddSchemaByURL, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca3061)
CA3075 | Security | Hidden | DoNotUseInsecureDtdProcessingAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca3075)
CA3076 | Security | Hidden | DoNotUseInsecureXSLTScriptExecutionAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca3076)
CA3077 | Security | Hidden | DoNotUseInsecureDtdProcessingInApiDesignAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca3077)
CA3147 | Security | Hidden | MarkVerbHandlersWithValidateAntiforgeryTokenAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca3147)
CA5350 | Security | Hidden | DoNotUseInsecureCryptographicAlgorithmsAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca5350)
CA5351 | Security | Hidden | DoNotUseInsecureCryptographicAlgorithmsAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca5351)
CA5358 | Security | Disabled | ApprovedCipherModeAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca5358)
CA5359 | Security | Hidden | DoNotDisableCertificateValidation, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca5359)
CA5360 | Security | Hidden | DoNotCallDangerousMethodsInDeserialization, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca5360)
CA5361 | Security | Disabled | DoNotSetSwitch, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca5361)
CA5362 | Security | Disabled | PotentialReferenceCycleInDeserializedObjectGraph, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca5362)
CA5363 | Security | Hidden | DoNotDisableRequestValidation, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca5363)
CA5364 | Security | Hidden | DoNotUseDeprecatedSecurityProtocols, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca5364)
CA5365 | Security | Hidden | DoNotDisableHTTPHeaderChecking, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca5365)
CA5366 | Security | Hidden | UseXmlReaderForDataSetReadXml, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca5366)
CA5367 | Security | Disabled | DoNotSerializeTypeWithPointerFields, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca5367)
CA5368 | Security | Hidden | SetViewStateUserKey, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca5368)
CA5369 | Security | Hidden | UseXmlReaderForDeserialize, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca5369)
CA5370 | Security | Hidden | UseXmlReaderForValidatingReader, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca5370)
CA5371 | Security | Hidden | UseXmlReaderForSchemaRead, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca5371)
CA5372 | Security | Hidden | UseXmlReaderForXPathDocument, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca5372)
CA5373 | Security | Hidden | DoNotUseObsoleteKDFAlgorithm, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca5373)
CA5374 | Security | Hidden | DoNotUseXslTransform, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca5374)
CA5375 | Security | Disabled | DoNotUseAccountSAS, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca5375)
CA5376 | Security | Disabled | UseSharedAccessProtocolHttpsOnly, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca5376)
CA5377 | Security | Disabled | UseContainerLevelAccessPolicy, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca5377)
CA5378 | Security | Disabled | DoNotSetSwitch, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca5378)
CA5379 | Security | Hidden | DoNotUseWeakKDFAlgorithm, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca5379)
CA5380 | Security | Disabled | DoNotInstallRootCert, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca5380)
CA5381 | Security | Disabled | DoNotInstallRootCert, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca5381)
CA5382 | Security | Disabled | UseSecureCookiesASPNetCore, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca5382)
CA5383 | Security | Disabled | UseSecureCookiesASPNetCore, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca5383)
CA5384 | Security | Hidden | DoNotUseDSA, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca5384)
CA5385 | Security | Hidden | UseRSAWithSufficientKeySize, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca5385)
CA5386 | Security | Disabled | DoNotUseDeprecatedSecurityProtocols, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca5386)
CA5387 | Security | Disabled | DoNotUseWeakKDFInsufficientIterationCount, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca5387)
CA5388 | Security | Disabled | DoNotUseWeakKDFInsufficientIterationCount, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca5388)
CA5389 | Security | Disabled | DoNotAddArchiveItemPathToTheTargetFileSystemPath, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca5389)
CA5390 | Security | Disabled | DoNotHardCodeEncryptionKey, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca5390)
CA5391 | Security | Disabled | UseAutoValidateAntiforgeryToken, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca5391)
CA5392 | Security | Disabled | UseDefaultDllImportSearchPathsAttribute, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca5392)
CA5393 | Security | Disabled | UseDefaultDllImportSearchPathsAttribute, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca5393)
CA5394 | Security | Disabled | DoNotUseInsecureRandomness, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca5394)
CA5395 | Security | Disabled | UseAutoValidateAntiforgeryToken, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca5395)
CA5396 | Security | Disabled | SetHttpOnlyForHttpCookie, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca5396)
CA5397 | Security | Hidden | SslProtocolsAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca5397)
CA5398 | Security | Disabled | SslProtocolsAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca5398)
CA5399 | Security | Disabled | DoNotDisableHttpClientCRLCheck, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca5399)
CA5400 | Security | Disabled | DoNotDisableHttpClientCRLCheck, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca5400)
CA5401 | Security | Disabled | DoNotUseCreateEncryptorWithNonDefaultIV, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca5401)
CA5402 | Security | Disabled | DoNotUseCreateEncryptorWithNonDefaultIV, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca5402)
CA5403 | Security | Disabled | DoNotHardCodeCertificate, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca5403)
IL3000 | Publish | Warning | AvoidAssemblyLocationInSingleFile, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/il3000)
IL3001 | Publish | Warning | AvoidAssemblyLocationInSingleFile, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/il3001)
