#!/bin/bash
set -euo pipefail
IFS=$'\n\t'

APPINSIGHTS_VERSION=2.0.0

REPO_ROOT=$(cd "$(dirname "$0")/../"; pwd -P)
SOURCE_ROOT=$REPO_ROOT/sources
APPINSIGHTS_ROOT=$SOURCE_ROOT/ApplicationInsights-dotnet
DOTNET_CMD=$REPO_ROOT/toolsets/dotnet/1.0.0-preview2-003121/dotnet
ROSLYN_TOOLSET_ROOT=$REPO_ROOT/toolsets/roslyn/roslyn.linux.8
BUILDTOOLS_TOOLSET_ROOT=$REPO_ROOT/toolsets/buildtools/1.0.25-prerelease-00511-02
XPLAT_NUGET_CMD=$REPO_ROOT/toolsets/nuget/3.5.0-beta2-1484/NuGet.CommandLine.XPlat.dll

ReferenceAssemblyRoot=$ROSLYN_TOOLSET_ROOT/reference-assemblies/Framework $BUILDTOOLS_TOOLSET_ROOT/corerun \
    $BUILDTOOLS_TOOLSET_ROOT/MSBuild.exe \
    $APPINSIGHTS_ROOT/src/Core/Managed/PCL/Core.PCL.csproj \
    /p:Configuration=Release \
    /p:ToolsDir=$BUILDTOOLS_TOOLSET_ROOT \

if [ ! -d $APPINSIGHTS_ROOT/bin/Release/NuGet ]; then
    mkdir $APPINSIGHTS_ROOT/bin/Release/NuGet
fi

$DOTNET_CMD $XPLAT_NUGET_CMD pack --symbols --output-directory $APPINSIGHTS_ROOT/bin/Release/NuGet --base-path $APPINSIGHTS_ROOT/bin --properties "version=$APPINSIGHTS_VERSION;author=Microsoft;image=http://appanacdn.blob.core.windows.net/cdn/icons/aic.png;copyright=Copyright © Microsoft. All Rights Reserved;configuration=Release" $APPINSIGHTS_ROOT/src/Core/NuGet/Core/Package.nuspec

cp $APPINSIGHTS_ROOT/bin/Release/NuGet/*.nupkg $REPO_ROOT/packages/source-built
