#!/bin/bash
set -euo pipefail
IFS=$'\n\t'

REPO_ROOT=$(cd "$(dirname "$0")/../"; pwd -P)
SOURCE_ROOT=$REPO_ROOT/sources
RID=rhel.7.5-x64

export GIT_COMMIT_HASH=da5cda44bfef04197b9b47babde2665ae6dfb6ee
export GIT_COMMIT_COUNT=1093

pushd $SOURCE_ROOT/core-setup

./build.sh --configuration Release --targets Init,Compile,Package

cp artifacts/$RID/corehost/*.nupkg $REPO_ROOT/packages/source-built
cp artifacts/$RID/packages/*.tar.gz $REPO_ROOT/packages/source-built

popd
