#!/bin/bash
set -euo pipefail
IFS=$'\n\t'

REPO_ROOT=$(cd "$(dirname "$0")/../"; pwd -P)
SOURCE_ROOT=$REPO_ROOT/sources
GIT_COMMIT=8933e431b08e43626158c33948ee14cc027f1e6d
VERSION_SEED_DATE=2017-04-20
OFFICIAL_BUILD_ID=20180906-01

pushd $SOURCE_ROOT/corefx

./build.sh managed /t:GenerateVersionHeader /p:GenerateNativeVersionInfo=true /p:OfficialBuildId=$OFFICIAL_BUILD_ID /p:LatestCommit=$GIT_COMMIT /p:VersionSeedDate=$VERSION_SEED_DATE
./build.sh managed /p:Platform=AnyCPU /p:ConfigurationGroup=Release /p:BuildTests=false /p:BuildPackages=false /p:BuildTests=false /p:OfficialBuildId=$OFFICIAL_BUILD_ID /p:LatestCommit=$GIT_COMMIT /p:VersionSeedDate=$VERSION_SEED_DATE
./build.sh native x64 Release
./build-packages.sh /p:ConfigurationGroup=Release /p:OfficialBuildId=$OFFICIAL_BUILD_ID /p:LatestCommit=$GIT_COMMIT /p:VersionSeedDate=$VERSION_SEED_DATE

cp bin/packages/Release/*.nupkg ../../packages/source-built

popd
