#!/bin/bash
set -euo pipefail
IFS=$'\n\t'

REPO_ROOT=$(cd "$(dirname "$0")/../"; pwd -P)
SOURCE_ROOT=$REPO_ROOT/sources
RID=rhel.7.6-x64

export GIT_COMMIT_HASH=0d8dcb421de7b76b2d1ffbddc248fb148a5cc2b7
export GIT_COMMIT_COUNT=1107

pushd $SOURCE_ROOT/core-setup

./build.sh --configuration Release --targets Init,Compile,Package

cp artifacts/$RID/corehost/*.nupkg $REPO_ROOT/packages/source-built
cp artifacts/$RID/packages/*.tar.gz $REPO_ROOT/packages/source-built

popd
