#!/bin/bash
set -euo pipefail
IFS=$'\n\t'

ROSLYN_VERSION=1.3.0

REPO_ROOT=$(cd "$(dirname "$0")/../"; pwd -P)
SOURCE_ROOT=$REPO_ROOT/sources
DOTNET_CMD=$REPO_ROOT/toolsets/dotnet/1.0.0-preview2-003121/dotnet
ROSLYN_TOOLSET_ROOT=$REPO_ROOT/toolsets/roslyn/roslyn.linux.8
XPLAT_NUGET_CMD=$REPO_ROOT/toolsets/nuget/3.5.0-beta2-1484/NuGet.CommandLine.XPlat.dll

pushd $SOURCE_ROOT/symreader

export DOTNET_SKIP_FIRST_TIME_EXPERIENCE=1
export DOTNET_CLI_TELEMETRY_OPTOUT=1
export NUGET_PACKAGES=$SOURCE_ROOT/symreader/packages

$DOTNET_CMD restore

$ROSLYN_TOOLSET_ROOT/corerun $ROSLYN_TOOLSET_ROOT/MSBuild.exe /p:CscToolExe=csc /p:NuGetRuntimeIdentifier=win7 /p:Configuration=Release ./SymReader.sln
$ROSLYN_TOOLSET_ROOT/corerun $ROSLYN_TOOLSET_ROOT/MSBuild.exe /p:Configuration=Release /p:UseXPlatNuGet=true /p:DotNetToolPath=$DOTNET_CMD /p:NuGetToolPath=$XPLAT_NUGET_CMD ./src/Microsoft.DiaSymReader/Microsoft.DiaSymReader.nuget.proj

cp Binaries/Release/NuGet/* $REPO_ROOT/packages/source-built

popd


