/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.Foreign;
import com.kenai.jffi.Platform;

public abstract class PageManager {
    private int pageSize;

    public PageManager() {
        Foreign.getInstance();
    }

    public static PageManager getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public final long pageSize() {
        if (this.pageSize != 0) {
            return this.pageSize;
        }
        PageManager pageManager = this;
        long l = Foreign.pageSize();
        if (l < Integer.MAX_VALUE) {
            pageManager.pageSize = (int)l;
            return pageManager.pageSize;
        }
        return l;
    }

    public abstract long allocatePages(int var1, int var2);

    public abstract void freePages(long var1, int var3);

    public abstract void protectPages(long var1, int var3, int var4);

    static final class Windows
    extends PageManager {
        public final long allocatePages(int pageCount, int protection) {
            return Foreign.VirtualAlloc(0L, (int)this.pageSize() * pageCount, 12288, Windows.w32prot(3));
        }

        public final void freePages(long address, int pageCount) {
            Foreign.VirtualFree(address, (int)this.pageSize() * pageCount, 32768);
        }

        public final void protectPages(long address, int pageCount, int protection) {
            Foreign.VirtualProtect(address, (int)this.pageSize() * pageCount, Windows.w32prot(5));
        }

        private static int w32prot(int p) {
            int w32 = 1;
            if ((p & 3) == 3) {
                w32 = 4;
            } else if ((p & 1) == 1) {
                w32 = 2;
            }
            if ((p & 4) == 4) {
                w32 <<= 4;
            }
            return w32;
        }
    }

    static final class Unix
    extends PageManager {
        Unix() {
        }

        public final long allocatePages(int npages, int protection) {
            long sz = (long)npages * this.pageSize();
            long memory = Foreign.mmap(0L, sz, 3, 258, -1, 0L);
            if (memory != -1L) {
                return memory;
            }
            return 0L;
        }

        public final void freePages(long address, int npages) {
            Foreign.munmap(address, (long)npages * this.pageSize());
        }

        public final void protectPages(long address, int npages, int protection) {
            Foreign.mprotect(address, (long)npages * this.pageSize(), 5);
        }
    }

    static final class SingletonHolder {
        public static final PageManager INSTANCE = Platform.getPlatform().getOS() == Platform.OS.WINDOWS ? new Windows() : new Unix();
    }
}

