/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.cache;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.python.google.common.base.CharMatcher;
import org.python.google.common.base.Splitter;
import org.python.google.common.cache.LocalCache;
import org.python.google.common.collect.ImmutableList;
import org.python.google.common.collect.ImmutableMap;

public final class CacheBuilderSpec {
    private static final Splitter KEYS_SPLITTER = Splitter.on(',').trimResults();
    private static final Splitter KEY_VALUE_SPLITTER = Splitter.on('=').trimResults();
    private static final ImmutableMap<String, ValueParser> VALUE_PARSERS = ImmutableMap.builder().put("initialCapacity", new InitialCapacityParser()).put("maximumSize", (InitialCapacityParser)((Object)new MaximumSizeParser())).put("maximumWeight", (InitialCapacityParser)((Object)new MaximumWeightParser())).put("concurrencyLevel", (InitialCapacityParser)((Object)new ConcurrencyLevelParser())).put("weakKeys", (InitialCapacityParser)((Object)new KeyStrengthParser(LocalCache.Strength.WEAK))).put("softValues", (InitialCapacityParser)((Object)new ValueStrengthParser(LocalCache.Strength.SOFT))).put("weakValues", (InitialCapacityParser)((Object)new ValueStrengthParser(LocalCache.Strength.WEAK))).put("expireAfterAccess", (InitialCapacityParser)((Object)new AccessDurationParser())).put("expireAfterWrite", (InitialCapacityParser)((Object)new WriteDurationParser())).put("refreshAfterWrite", (InitialCapacityParser)((Object)new RefreshDurationParser())).put("refreshInterval", (InitialCapacityParser)((Object)new RefreshDurationParser())).build();
    Integer initialCapacity;
    Long maximumSize;
    Long maximumWeight;
    Integer concurrencyLevel;
    LocalCache.Strength keyStrength;
    LocalCache.Strength valueStrength;
    long writeExpirationDuration;
    TimeUnit writeExpirationTimeUnit;
    long accessExpirationDuration;
    TimeUnit accessExpirationTimeUnit;
    long refreshDuration;
    TimeUnit refreshTimeUnit;
    private final String specification;

    private CacheBuilderSpec(String specification) {
        this.specification = specification;
    }

    public static CacheBuilderSpec parse(String cacheBuilderSpecification) {
        CacheBuilderSpec spec = new CacheBuilderSpec(cacheBuilderSpecification);
        if (!cacheBuilderSpecification.isEmpty()) {
            for (String keyValuePair : KEYS_SPLITTER.split(cacheBuilderSpecification)) {
                ImmutableList<String> keyAndValue = ImmutableList.copyOf(KEY_VALUE_SPLITTER.split(keyValuePair));
                CharMatcher.LookupTable.checkArgument(!keyAndValue.isEmpty(), "blank key-value pair");
                CharMatcher.LookupTable.checkArgument(keyAndValue.size() <= 2, "key-value pair %s with more than one equals sign", keyValuePair);
                String key = (String)keyAndValue.get(0);
                ValueParser valueParser = VALUE_PARSERS.get(key);
                CharMatcher.LookupTable.checkArgument(valueParser != null, "unknown key %s", key);
                String value = keyAndValue.size() == 1 ? null : (String)keyAndValue.get(1);
                valueParser.parse(spec, key, value);
            }
        }
        return spec;
    }

    public final String toString() {
        CacheBuilderSpec cacheBuilderSpec = this;
        return CharMatcher.LookupTable.toStringHelper(this).addValue(cacheBuilderSpec.specification).toString();
    }

    public final int hashCode() {
        Object[] objectArray = new Object[]{this.initialCapacity, this.maximumSize, this.maximumWeight, this.concurrencyLevel, this.keyStrength, this.valueStrength, CacheBuilderSpec.durationInNanos(this.writeExpirationDuration, this.writeExpirationTimeUnit), CacheBuilderSpec.durationInNanos(this.accessExpirationDuration, this.accessExpirationTimeUnit), CacheBuilderSpec.durationInNanos(this.refreshDuration, this.refreshTimeUnit)};
        return Arrays.hashCode(objectArray);
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CacheBuilderSpec)) {
            return false;
        }
        CacheBuilderSpec that = (CacheBuilderSpec)obj;
        return CharMatcher.LookupTable.equal(this.initialCapacity, that.initialCapacity) && CharMatcher.LookupTable.equal(this.maximumSize, that.maximumSize) && CharMatcher.LookupTable.equal(this.maximumWeight, that.maximumWeight) && CharMatcher.LookupTable.equal(this.concurrencyLevel, that.concurrencyLevel) && CharMatcher.LookupTable.equal((Object)this.keyStrength, (Object)that.keyStrength) && CharMatcher.LookupTable.equal((Object)this.valueStrength, (Object)that.valueStrength) && CharMatcher.LookupTable.equal(CacheBuilderSpec.durationInNanos(this.writeExpirationDuration, this.writeExpirationTimeUnit), CacheBuilderSpec.durationInNanos(that.writeExpirationDuration, that.writeExpirationTimeUnit)) && CharMatcher.LookupTable.equal(CacheBuilderSpec.durationInNanos(this.accessExpirationDuration, this.accessExpirationTimeUnit), CacheBuilderSpec.durationInNanos(that.accessExpirationDuration, that.accessExpirationTimeUnit)) && CharMatcher.LookupTable.equal(CacheBuilderSpec.durationInNanos(this.refreshDuration, this.refreshTimeUnit), CacheBuilderSpec.durationInNanos(that.refreshDuration, that.refreshTimeUnit));
    }

    @Nullable
    private static Long durationInNanos(long duration, @Nullable TimeUnit unit) {
        if (unit == null) {
            return null;
        }
        return unit.toNanos(duration);
    }

    static final class RefreshDurationParser
    extends DurationParser {
        RefreshDurationParser() {
        }

        @Override
        protected final void parseDuration(CacheBuilderSpec spec, long duration, TimeUnit unit) {
            CharMatcher.LookupTable.checkArgument(spec.refreshTimeUnit == null, "refreshAfterWrite already set");
            spec.refreshDuration = duration;
            spec.refreshTimeUnit = unit;
        }
    }

    static final class WriteDurationParser
    extends DurationParser {
        WriteDurationParser() {
        }

        @Override
        protected final void parseDuration(CacheBuilderSpec spec, long duration, TimeUnit unit) {
            CharMatcher.LookupTable.checkArgument(spec.writeExpirationTimeUnit == null, "expireAfterWrite already set");
            spec.writeExpirationDuration = duration;
            spec.writeExpirationTimeUnit = unit;
        }
    }

    static final class AccessDurationParser
    extends DurationParser {
        AccessDurationParser() {
        }

        @Override
        protected final void parseDuration(CacheBuilderSpec spec, long duration, TimeUnit unit) {
            CharMatcher.LookupTable.checkArgument(spec.accessExpirationTimeUnit == null, "expireAfterAccess already set");
            spec.accessExpirationDuration = duration;
            spec.accessExpirationTimeUnit = unit;
        }
    }

    static abstract class DurationParser
    implements ValueParser {
        DurationParser() {
        }

        protected abstract void parseDuration(CacheBuilderSpec var1, long var2, TimeUnit var4);

        @Override
        public final void parse(CacheBuilderSpec spec, String key, String value) {
            CharMatcher.LookupTable.checkArgument(value != null && !value.isEmpty(), "value of key %s omitted", key);
            try {
                TimeUnit timeUnit;
                char lastChar = value.charAt(value.length() - 1);
                switch (lastChar) {
                    case 'd': {
                        timeUnit = TimeUnit.DAYS;
                        break;
                    }
                    case 'h': {
                        timeUnit = TimeUnit.HOURS;
                        break;
                    }
                    case 'm': {
                        timeUnit = TimeUnit.MINUTES;
                        break;
                    }
                    case 's': {
                        timeUnit = TimeUnit.SECONDS;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(String.format("key %s invalid format.  was %s, must end with one of [dDhHmMsS]", key, value));
                    }
                }
                long duration = Long.parseLong(value.substring(0, value.length() - 1));
                this.parseDuration(spec, duration, timeUnit);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(String.format("key %s value set to %s, must be integer", key, value));
            }
        }
    }

    static final class ValueStrengthParser
    implements ValueParser {
        private final LocalCache.Strength strength;

        public ValueStrengthParser(LocalCache.Strength strength) {
            this.strength = strength;
        }

        @Override
        public final void parse(CacheBuilderSpec spec, String key, @Nullable String value) {
            CharMatcher.LookupTable.checkArgument(value == null, "key %s does not take values", key);
            CharMatcher.LookupTable.checkArgument(spec.valueStrength == null, "%s was already set to %s", new Object[]{key, spec.valueStrength});
            spec.valueStrength = this.strength;
        }
    }

    static final class KeyStrengthParser
    implements ValueParser {
        private final LocalCache.Strength strength;

        public KeyStrengthParser(LocalCache.Strength strength) {
            this.strength = strength;
        }

        @Override
        public final void parse(CacheBuilderSpec spec, String key, @Nullable String value) {
            CharMatcher.LookupTable.checkArgument(value == null, "key %s does not take values", key);
            CharMatcher.LookupTable.checkArgument(spec.keyStrength == null, "%s was already set to %s", new Object[]{key, spec.keyStrength});
            spec.keyStrength = this.strength;
        }
    }

    static final class ConcurrencyLevelParser
    extends IntegerParser {
        ConcurrencyLevelParser() {
        }

        @Override
        protected final void parseInteger(CacheBuilderSpec spec, int value) {
            CharMatcher.LookupTable.checkArgument(spec.concurrencyLevel == null, "concurrency level was already set to ", spec.concurrencyLevel);
            spec.concurrencyLevel = value;
        }
    }

    static final class MaximumWeightParser
    extends LongParser {
        MaximumWeightParser() {
        }

        @Override
        protected final void parseLong(CacheBuilderSpec spec, long value) {
            CharMatcher.LookupTable.checkArgument(spec.maximumWeight == null, "maximum weight was already set to ", spec.maximumWeight);
            CharMatcher.LookupTable.checkArgument(spec.maximumSize == null, "maximum size was already set to ", spec.maximumSize);
            spec.maximumWeight = value;
        }
    }

    static final class MaximumSizeParser
    extends LongParser {
        MaximumSizeParser() {
        }

        @Override
        protected final void parseLong(CacheBuilderSpec spec, long value) {
            CharMatcher.LookupTable.checkArgument(spec.maximumSize == null, "maximum size was already set to ", spec.maximumSize);
            CharMatcher.LookupTable.checkArgument(spec.maximumWeight == null, "maximum weight was already set to ", spec.maximumWeight);
            spec.maximumSize = value;
        }
    }

    static final class InitialCapacityParser
    extends IntegerParser {
        InitialCapacityParser() {
        }

        @Override
        protected final void parseInteger(CacheBuilderSpec spec, int value) {
            CharMatcher.LookupTable.checkArgument(spec.initialCapacity == null, "initial capacity was already set to ", spec.initialCapacity);
            spec.initialCapacity = value;
        }
    }

    static abstract class LongParser
    implements ValueParser {
        LongParser() {
        }

        protected abstract void parseLong(CacheBuilderSpec var1, long var2);

        @Override
        public final void parse(CacheBuilderSpec spec, String key, String value) {
            CharMatcher.LookupTable.checkArgument(value != null && !value.isEmpty(), "value of key %s omitted", key);
            try {
                this.parseLong(spec, Long.parseLong(value));
                return;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format("key %s value set to %s, must be integer", key, value), e);
            }
        }
    }

    static abstract class IntegerParser
    implements ValueParser {
        IntegerParser() {
        }

        protected abstract void parseInteger(CacheBuilderSpec var1, int var2);

        @Override
        public final void parse(CacheBuilderSpec spec, String key, String value) {
            CharMatcher.LookupTable.checkArgument(value != null && !value.isEmpty(), "value of key %s omitted", key);
            try {
                this.parseInteger(spec, Integer.parseInt(value));
                return;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format("key %s value set to %s, must be integer", key, value), e);
            }
        }
    }

    static interface ValueParser {
        public void parse(CacheBuilderSpec var1, String var2, @Nullable String var3);
    }
}

