/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.console.editor;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import net.grinder.common.GrinderException;
import net.grinder.console.distribution.AgentCacheState;
import net.grinder.console.editor.Buffer;
import net.grinder.console.editor.EditorModel;

class ExternalEditor {
    private static final ThreadGroup s_threadGroup = new ThreadGroup("ExternalEditor");
    private final AgentCacheState m_agentCacheState;
    private final EditorModel m_editorModel;
    private final File m_command;
    private final String m_arguments;

    static final ThreadGroup getThreadGroup() {
        return s_threadGroup;
    }

    public ExternalEditor(AgentCacheState agentCacheState, EditorModel editorModel, File command, String arguments) {
        this.m_agentCacheState = agentCacheState;
        this.m_editorModel = editorModel;
        this.m_command = command;
        this.m_arguments = arguments;
    }

    String[] fileToCommandLine(File file) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.m_command.getAbsolutePath());
        boolean fileTemplateFound = false;
        if (this.m_arguments != null) {
            StringTokenizer tokenizer = new StringTokenizer(this.m_arguments);
            while (tokenizer.hasMoreElements()) {
                String token = tokenizer.nextToken();
                String argument = token.replaceAll("%f", file.getAbsolutePath());
                result.add(argument);
                fileTemplateFound |= !argument.equals(token);
            }
        }
        if (!fileTemplateFound) {
            result.add(file.getAbsolutePath());
        }
        return result.toArray(new String[result.size()]);
    }

    public void open(final File file) throws IOException {
        final long originalModificationTime = file.lastModified();
        final Process exec = Runtime.getRuntime().exec(this.fileToCommandLine(file), null, file.getParentFile());
        Runnable handleCompletion = new Runnable(){

            public void run() {
                try {
                    exec.waitFor();
                }
                catch (InterruptedException e) {
                    return;
                }
                long lastModified = file.lastModified();
                if (lastModified > originalModificationTime) {
                    ExternalEditor.this.m_agentCacheState.setNewFileTime(lastModified);
                    Buffer buffer = ExternalEditor.this.m_editorModel.getBufferForFile(file);
                    if (buffer != null && !buffer.isDirty()) {
                        try {
                            buffer.load();
                        }
                        catch (GrinderException e) {
                            // empty catch block
                        }
                    }
                }
            }
        };
        Thread thread = new Thread(ExternalEditor.getThreadGroup(), handleCompletion, "External edit of " + file);
        thread.setDaemon(true);
        thread.start();
    }
}

