/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.console.model;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import net.grinder.console.model.ConsoleProperties;
import net.grinder.console.model.SampleModel;
import net.grinder.console.model.SampleModelViews;
import net.grinder.statistics.ExpressionView;
import net.grinder.statistics.StatisticExpressionFactory;
import net.grinder.statistics.StatisticsServices;
import net.grinder.statistics.StatisticsView;
import net.grinder.statistics.TestStatisticsQueries;
import net.grinder.util.ListenerSupport;
import net.grinder.util.SignificantFigureFormat;

public class SampleModelViewsImplementation
implements SampleModelViews {
    private final ListenerSupport m_listeners = new ListenerSupport();
    private final StatisticsServices m_statisticsServices;
    private final ExpressionView m_peakTPSExpressionView;
    private NumberFormat m_numberFormat;
    private StatisticsView m_intervalStatisticsView;
    private StatisticsView m_cumulativeStatisticsView;

    public SampleModelViewsImplementation(ConsoleProperties properties, StatisticsServices statisticsServices, SampleModel model) {
        this.m_statisticsServices = statisticsServices;
        this.m_numberFormat = new SignificantFigureFormat(properties.getSignificantFigures());
        StatisticExpressionFactory statisticExpressionFactory = this.m_statisticsServices.getStatisticExpressionFactory();
        this.m_peakTPSExpressionView = statisticExpressionFactory.createExpressionView("Peak TPS", model.getPeakTPSExpression());
        this.resetStatisticsViews();
        properties.addPropertyChangeListener("grinder.console.significantFigures", new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void propertyChange(PropertyChangeEvent event) {
                SampleModelViewsImplementation sampleModelViewsImplementation = SampleModelViewsImplementation.this;
                synchronized (sampleModelViewsImplementation) {
                    SampleModelViewsImplementation.this.m_numberFormat = new SignificantFigureFormat((Integer)event.getNewValue());
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetStatisticsViews() {
        StatisticsView summaryStatisticsView = this.m_statisticsServices.getSummaryStatisticsView();
        SampleModelViewsImplementation sampleModelViewsImplementation = this;
        synchronized (sampleModelViewsImplementation) {
            this.m_intervalStatisticsView = new StatisticsView();
            this.m_cumulativeStatisticsView = new StatisticsView();
        }
        this.m_intervalStatisticsView.add(summaryStatisticsView);
        this.m_cumulativeStatisticsView.add(summaryStatisticsView);
        this.m_cumulativeStatisticsView.add(this.m_peakTPSExpressionView);
        this.m_listeners.apply(new ListenerSupport.Informer(){

            public void inform(Object listener) {
                ((SampleModelViews.Listener)listener).resetStatisticsViews();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NumberFormat getNumberFormat() {
        SampleModelViewsImplementation sampleModelViewsImplementation = this;
        synchronized (sampleModelViewsImplementation) {
            return this.m_numberFormat;
        }
    }

    public void registerStatisticExpression(final ExpressionView statisticExpression) {
        this.m_intervalStatisticsView.add(statisticExpression);
        this.m_cumulativeStatisticsView.add(statisticExpression);
        this.m_listeners.apply(new ListenerSupport.Informer(){

            public void inform(Object listener) {
                SampleModelViews.Listener modelListener = (SampleModelViews.Listener)listener;
                modelListener.newStatisticExpression(statisticExpression);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatisticsView getCumulativeStatisticsView() {
        SampleModelViewsImplementation sampleModelViewsImplementation = this;
        synchronized (sampleModelViewsImplementation) {
            return this.m_cumulativeStatisticsView;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatisticsView getIntervalStatisticsView() {
        SampleModelViewsImplementation sampleModelViewsImplementation = this;
        synchronized (sampleModelViewsImplementation) {
            return this.m_intervalStatisticsView;
        }
    }

    public TestStatisticsQueries getTestStatisticsQueries() {
        return this.m_statisticsServices.getTestStatisticsQueries();
    }

    public void addListener(SampleModelViews.Listener listener) {
        this.m_listeners.add(listener);
    }
}

