/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.console.swingui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import net.grinder.common.Closer;
import net.grinder.common.GrinderException;
import net.grinder.common.GrinderProperties;
import net.grinder.common.Logger;
import net.grinder.common.UncheckedInterruptedException;
import net.grinder.console.ConsoleFoundation;
import net.grinder.console.common.ConsoleException;
import net.grinder.console.common.ErrorHandler;
import net.grinder.console.common.Resources;
import net.grinder.console.communication.ProcessControl;
import net.grinder.console.distribution.AgentCacheState;
import net.grinder.console.distribution.FileDistribution;
import net.grinder.console.distribution.FileDistributionHandler;
import net.grinder.console.editor.Buffer;
import net.grinder.console.editor.EditorModel;
import net.grinder.console.model.ConsoleProperties;
import net.grinder.console.model.SampleListener;
import net.grinder.console.model.SampleModel;
import net.grinder.console.model.SampleModelViews;
import net.grinder.console.swingui.BufferTreeModel;
import net.grinder.console.swingui.Colours;
import net.grinder.console.swingui.ConsoleUI;
import net.grinder.console.swingui.CumulativeStatisticsTableModel;
import net.grinder.console.swingui.CustomAction;
import net.grinder.console.swingui.CustomJButton;
import net.grinder.console.swingui.Editor;
import net.grinder.console.swingui.EditorControls;
import net.grinder.console.swingui.ErrorDialogHandler;
import net.grinder.console.swingui.FileTree;
import net.grinder.console.swingui.FileTreeModel;
import net.grinder.console.swingui.FrameBounds;
import net.grinder.console.swingui.LabelledGraph;
import net.grinder.console.swingui.LookAndFeel;
import net.grinder.console.swingui.MnemonicHeuristics;
import net.grinder.console.swingui.OptionalConfirmDialog;
import net.grinder.console.swingui.OptionsDialogHandler;
import net.grinder.console.swingui.ProcessStatusTableModel;
import net.grinder.console.swingui.SampleStatisticsTableModel;
import net.grinder.console.swingui.SamplingControlPanel;
import net.grinder.console.swingui.SwingDispatcherFactoryImplementation;
import net.grinder.console.swingui.Table;
import net.grinder.console.swingui.TestGraphPanel;
import net.grinder.statistics.StatisticsSet;
import net.grinder.util.Directory;
import net.grinder.util.FileContents;
import net.grinder.util.thread.Condition;

public final class ConsoleUI
implements ConsoleFoundation.UI {
    private final LookAndFeel m_lookAndFeel;
    private final ActionTable m_actionTable = new ActionTable();
    private final CloseFileAction m_closeFileAction;
    private final StartAction m_startAction;
    private final ExitAction m_exitAction;
    private final StopAction m_stopAction;
    private final SaveFileAction m_saveFileAction;
    private final SaveFileAsAction m_saveFileAsAction;
    private final DistributeFilesAction m_distributeFilesAction;
    private final Resources m_resources;
    private final ConsoleProperties m_properties;
    private final SampleModel m_model;
    private final SampleModelViews m_sampleModelViews;
    private final ProcessControl m_processControl;
    private final FileDistribution m_fileDistribution;
    private final EditorModel m_editorModel;
    private final JFrame m_frame;
    private final FrameBounds m_frameBounds;
    private final JLabel m_stateLabel;
    private final SamplingControlPanel m_samplingControlPanel;
    private final ErrorHandler m_errorHandler;
    private final OptionalConfirmDialog m_optionalConfirmDialog;
    private final Font m_titleLabelFont;
    private final CumulativeStatisticsTableModel m_cumulativeTableModel;

    public ConsoleUI(Resources resources, ConsoleProperties consoleProperties, SampleModel model, SampleModelViews sampleModelViews, ProcessControl processControl, FileDistribution fileDistribution, Logger logger) throws ConsoleException {
        Image logoImage;
        this.m_resources = resources;
        this.m_properties = consoleProperties;
        this.m_model = model;
        this.m_sampleModelViews = sampleModelViews;
        this.m_processControl = processControl;
        this.m_fileDistribution = fileDistribution;
        this.m_frame = new JFrame(this.m_resources.getString("title"));
        ErrorDialogHandler errorDialogHandler = new ErrorDialogHandler(this.m_frame, this.m_resources, logger);
        this.m_errorHandler = (ErrorHandler)new SwingDispatcherFactoryImplementation(null).create(errorDialogHandler);
        SwingDispatcherFactoryImplementation swingDispatcherFactory = new SwingDispatcherFactoryImplementation(this.m_errorHandler);
        this.m_lookAndFeel = new LookAndFeel(this.m_properties, swingDispatcherFactory);
        errorDialogHandler.registerWithLookAndFeel(this.m_lookAndFeel);
        this.m_editorModel = new EditorModel(this.m_resources, new Editor.TextSourceFactory(), this.m_fileDistribution.getAgentCacheState(), this.m_fileDistribution);
        this.m_editorModel.setExternalEditor(this.m_properties.getExternalEditorCommand(), this.m_properties.getExternalEditorArguments());
        this.m_editorModel.setSelectedPropertiesFile(this.m_properties.getPropertiesFile());
        this.m_properties.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("grinder.console.externalEditorCommand") || e.getPropertyName().equals("grinder.console.externalEditorArguments")) {
                    ConsoleUI.this.m_editorModel.setExternalEditor(ConsoleUI.this.m_properties.getExternalEditorCommand(), ConsoleUI.this.m_properties.getExternalEditorArguments());
                } else if (e.getPropertyName().equals("grinder.console.propertiesFile")) {
                    ConsoleUI.this.m_editorModel.setSelectedPropertiesFile(ConsoleUI.this.m_properties.getPropertiesFile());
                }
            }
        });
        this.m_optionalConfirmDialog = new OptionalConfirmDialog(this.m_frame, this.m_resources, this.m_properties);
        this.m_closeFileAction = new CloseFileAction();
        this.m_exitAction = new ExitAction();
        this.m_startAction = new StartAction();
        this.m_stopAction = new StopAction();
        this.m_saveFileAction = new SaveFileAction();
        this.m_saveFileAsAction = new SaveFileAsAction();
        this.m_distributeFilesAction = new DistributeFilesAction();
        this.m_actionTable.add(this.m_closeFileAction);
        this.m_actionTable.add(this.m_exitAction);
        this.m_actionTable.add(this.m_startAction);
        this.m_actionTable.add(this.m_stopAction);
        this.m_actionTable.add(this.m_saveFileAsAction);
        this.m_actionTable.add(this.m_distributeFilesAction);
        this.m_actionTable.add(new AboutAction(this.m_resources.getImageIcon("logo.image")));
        this.m_actionTable.add(new ChooseDirectoryAction());
        this.m_actionTable.add(new StartProcessesAction());
        this.m_actionTable.add(new NewFileAction());
        this.m_actionTable.add(new OptionsAction());
        this.m_actionTable.add(new ResetProcessesAction());
        this.m_actionTable.add(new SaveFileAction());
        this.m_actionTable.add(new SaveResultsAction());
        this.m_actionTable.add(new StopProcessesAction());
        this.m_stateLabel = new JLabel();
        this.stateChanged();
        this.m_samplingControlPanel = new SamplingControlPanel(this.m_resources);
        JPanel controlAndTotalPanel = this.createControlAndTotalPanel();
        JTabbedPane tabbedPane = new JTabbedPane();
        TestGraphPanel graphPanel = new TestGraphPanel(tabbedPane, this.m_model, this.m_sampleModelViews, this.m_resources, swingDispatcherFactory);
        graphPanel.resetTests();
        JScrollPane graphTabPane = new JScrollPane(graphPanel, 20, 31);
        graphTabPane.setBorder(BorderFactory.createEmptyBorder());
        tabbedPane.addTab(this.m_resources.getString("graphTab.title"), this.m_resources.getImageIcon("graphTab.image"), graphTabPane, this.m_resources.getString("graphTab.tip"));
        this.m_titleLabelFont = new JLabel().getFont().deriveFont(2);
        this.m_cumulativeTableModel = new CumulativeStatisticsTableModel(this.m_model, this.m_sampleModelViews, this.m_resources, swingDispatcherFactory);
        JScrollPane cumulativeTablePane = new JScrollPane(new Table(this.m_cumulativeTableModel));
        cumulativeTablePane.setBorder(this.createTitledBorder("cumulativeTable.label"));
        cumulativeTablePane.setMinimumSize(new Dimension(100, 60));
        SampleStatisticsTableModel sampleModel = new SampleStatisticsTableModel(this.m_model, this.m_sampleModelViews, this.m_resources, swingDispatcherFactory);
        JScrollPane sampleTablePane = new JScrollPane(new Table(sampleModel));
        sampleTablePane.setBorder(this.createTitledBorder("sampleTable.label"));
        sampleTablePane.setMinimumSize(new Dimension(100, 60));
        JSplitPane resultsPane = new JSplitPane(0, cumulativeTablePane, sampleTablePane);
        resultsPane.setOneTouchExpandable(true);
        resultsPane.setResizeWeight(1.0);
        resultsPane.setBorder(BorderFactory.createEmptyBorder());
        tabbedPane.addTab(this.m_resources.getString("resultsTab.title"), this.m_resources.getImageIcon("resultsTab.image"), resultsPane, this.m_resources.getString("resultsTab.tip"));
        ProcessStatusTableModel processStatusModel = new ProcessStatusTableModel(this.m_resources, this.m_processControl, swingDispatcherFactory);
        JScrollPane processStatusPane = new JScrollPane(new Table(processStatusModel));
        processStatusPane.setBorder(this.createTitledBorder("processStatusTableTab.tip"));
        tabbedPane.addTab(this.m_resources.getString("processStatusTableTab.title"), this.m_resources.getImageIcon("processStatusTableTab.image"), processStatusPane, this.m_resources.getString("processStatusTableTab.tip"));
        JToolBar editorToolBar = new JToolBar();
        new ToolBarAssembler(editorToolBar, true).populate("editor.toolbar");
        Font editorSmallFont = this.m_titleLabelFont.deriveFont(0).deriveFont(this.m_titleLabelFont.getSize2D() * 0.8f);
        EditorControls editorControls = new EditorControls(this.m_resources, this.m_editorModel, editorSmallFont, editorToolBar);
        Editor editor = new Editor(this.m_editorModel, this.m_saveFileAction);
        final FileTreeModel fileTreeModel = new FileTreeModel(this.m_editorModel, this.m_fileDistribution.getDistributionFileFilter());
        fileTreeModel.setRootDirectory(this.m_properties.getDistributionDirectory().getFile());
        this.m_properties.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("grinder.console.scriptDistributionDirectory")) {
                    fileTreeModel.setRootDirectory(ConsoleUI.this.m_properties.getDistributionDirectory().getFile());
                }
            }
        });
        this.m_fileDistribution.addFileChangedListener(new FileTreeModel.RefreshChangedDirectoriesListener(fileTreeModel));
        JPopupMenu fileTreePopupMenu = new JPopupMenu();
        FileTree fileTree = new FileTree(this.m_resources, this.getErrorHandler(), this.m_editorModel, new BufferTreeModel(this.m_editorModel), fileTreeModel, editorSmallFont, fileTreePopupMenu, this.m_properties);
        CustomAction[] fileTreeActions = fileTree.getActions();
        for (int i = 0; i < fileTreeActions.length; ++i) {
            this.m_actionTable.add(fileTreeActions[i]);
        }
        new PopupMenuAssembler(fileTreePopupMenu).populate("editor.filetree.popupmenu");
        JPanel editorPanel = new JPanel();
        editorPanel.setLayout(new FlowLayout(1, 0, 0));
        editorPanel.add(editorControls.getComponent());
        editorPanel.add(editor.getComponent());
        JToolBar fileTreeToolBar = new JToolBar();
        new ToolBarAssembler(fileTreeToolBar, true).populate("filetree.toolbar");
        fileTreeToolBar.setFloatable(false);
        fileTreeToolBar.setAlignmentX(0.0f);
        JComponent fileTreeComponent = fileTree.getComponent();
        fileTreeComponent.setAlignmentX(0.0f);
        fileTreeComponent.setPreferredSize(new Dimension(200, 100));
        JPanel fileTreeControlPanel = new JPanel();
        fileTreeControlPanel.setLayout(new BoxLayout(fileTreeControlPanel, 1));
        fileTreeControlPanel.setBorder(BorderFactory.createEmptyBorder());
        fileTreeControlPanel.add(fileTreeToolBar);
        fileTreeControlPanel.add(fileTreeComponent);
        JSplitPane scriptPane = new JSplitPane(1, fileTreeControlPanel, editorPanel);
        scriptPane.setOneTouchExpandable(true);
        scriptPane.setBorder(BorderFactory.createEmptyBorder());
        tabbedPane.addTab(this.m_resources.getString("scriptTab.title"), this.m_resources.getImageIcon("scriptTab.image"), scriptPane, this.m_resources.getString("scriptTab.tip"));
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.add((Component)controlAndTotalPanel, "West");
        contentPanel.add((Component)tabbedPane, "Center");
        JPanel toolBarPanel = new JPanel(new BorderLayout());
        JToolBar mainToolBar = new JToolBar();
        new ToolBarAssembler(mainToolBar, false).populate("main.toolbar");
        toolBarPanel.add((Component)mainToolBar, "North");
        toolBarPanel.add((Component)contentPanel, "Center");
        this.m_frame.setDefaultCloseOperation(0);
        this.m_frame.addWindowListener(new WindowCloseAdapter());
        Container topLevelPane = this.m_frame.getContentPane();
        JMenuBar menuBar = new JMenuBar();
        new MenuBarAssembler(menuBar).populate("menubar");
        topLevelPane.add((Component)menuBar, "North");
        topLevelPane.add((Component)toolBarPanel, "Center");
        ImageIcon logoIcon = this.m_resources.getImageIcon("logo.image");
        if (logoIcon != null && (logoImage = logoIcon.getImage()) != null) {
            this.m_frame.setIconImage(logoImage);
        }
        this.m_model.addModelListener((SampleModel.Listener)swingDispatcherFactory.create(new SampleModel.AbstractListener(){

            public void stateChanged() {
                ConsoleUI.this.stateChanged();
            }
        }));
        this.m_lookAndFeel.addListener(new LookAndFeelListener());
        this.m_frameBounds = new FrameBounds(this.m_properties, this.m_frame);
        this.m_frameBounds.restore();
        resultsPane.setDividerLocation(resultsPane.getMaximumDividerLocation());
        this.m_frame.setVisible(true);
    }

    private TitledBorder createTitledBorder(String titleResource) {
        TitledBorder border = BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), this.m_resources.getString(titleResource));
        border.setTitleFont(this.m_titleLabelFont);
        border.setTitleColor(Colours.HIGHLIGHT_TEXT);
        border.setTitleJustification(3);
        return border;
    }

    private JPanel createControlAndTotalPanel() {
        final LabelledGraph totalGraph = new LabelledGraph(this.m_resources.getString("totalGraph.title"), this.m_resources, Colours.DARK_GREY, this.m_model.getTPSExpression(), this.m_model.getPeakTPSExpression(), this.m_sampleModelViews.getTestStatisticsQueries());
        final JLabel tpsLabel = new JLabel();
        tpsLabel.setForeground(Colours.BLACK);
        tpsLabel.setFont(new Font("helvetica", 3, 40));
        tpsLabel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        this.m_model.addTotalSampleListener(new SampleListener(){
            private final String m_suffix;
            {
                this.m_suffix = ' ' + ConsoleUI.this.m_resources.getString("tps.units");
            }

            public void update(StatisticsSet intervalStatistics, StatisticsSet cumulativeStatistics) {
                NumberFormat format = ConsoleUI.this.m_sampleModelViews.getNumberFormat();
                tpsLabel.setText(format.format(ConsoleUI.this.m_model.getTPSExpression().getDoubleValue(intervalStatistics)) + this.m_suffix);
                totalGraph.add(intervalStatistics, cumulativeStatistics, format);
            }
        });
        CustomJButton stateButton = new CustomJButton();
        stateButton.setBorderPainted(true);
        ((AbstractButton)stateButton).setAction(this.m_stopAction);
        stateButton.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.m_stopAction.registerButton(stateButton);
        this.m_stateLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 0));
        JPanel statePanel = new JPanel();
        statePanel.setLayout(new BoxLayout(statePanel, 0));
        statePanel.add(stateButton);
        statePanel.add(this.m_stateLabel);
        statePanel.setAlignmentX(0.0f);
        this.m_samplingControlPanel.add(Box.createRigidArea(new Dimension(0, 40)));
        this.m_samplingControlPanel.add(statePanel);
        this.m_samplingControlPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        this.m_samplingControlPanel.setProperties(this.m_properties);
        JPanel controlAndTotalPanel = new JPanel();
        controlAndTotalPanel.setLayout(new BoxLayout(controlAndTotalPanel, 1));
        this.m_samplingControlPanel.setAlignmentX(0.0f);
        tpsLabel.setAlignmentX(0.0f);
        totalGraph.setAlignmentX(0.0f);
        controlAndTotalPanel.add(this.m_samplingControlPanel);
        controlAndTotalPanel.add(Box.createRigidArea(new Dimension(0, 100)));
        controlAndTotalPanel.add(tpsLabel);
        controlAndTotalPanel.add(Box.createRigidArea(new Dimension(0, 20)));
        controlAndTotalPanel.add(totalGraph);
        JPanel hackToFixLayout = new JPanel();
        hackToFixLayout.add(controlAndTotalPanel);
        return hackToFixLayout;
    }

    private void stateChanged() {
        SampleModel.State state = this.m_model.getState();
        this.m_stateLabel.setText(state.getDescription());
        if (state.isCapturing()) {
            this.m_stateLabel.setForeground(Colours.DARK_GREEN);
        } else if (state.isStopped()) {
            this.m_stateLabel.setForeground(Colours.DARK_RED);
            this.m_stopAction.stopped();
        } else {
            this.m_stateLabel.setForeground(UIManager.getColor("Label.foreground"));
        }
    }

    public ErrorHandler getErrorHandler() {
        return this.m_errorHandler;
    }

    static /* synthetic */ SamplingControlPanel access$1600(ConsoleUI x0) {
        return x0.m_samplingControlPanel;
    }

    private final class DistributeFilesAction
    extends CustomAction {
        private final Condition m_cacheStateCondition;

        DistributeFilesAction() {
            super(ConsoleUI.this.m_resources, "distribute-files");
            this.m_cacheStateCondition = new Condition();
            AgentCacheState agentCacheState = ConsoleUI.this.m_fileDistribution.getAgentCacheState();
            agentCacheState.addListener(new PropertyChangeListener(this){
                private final /* synthetic */ DistributeFilesAction this$1;
                {
                    this.this$1 = this$1;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void propertyChange(PropertyChangeEvent ignored) {
                    this.this$1.setEnabled(DistributeFilesAction.access$2800(this.this$1));
                    Condition condition = DistributeFilesAction.access$2900(this.this$1);
                    synchronized (condition) {
                        DistributeFilesAction.access$2900(this.this$1).notifyAll();
                    }
                }
            });
            this.setEnabled(this.shouldEnable());
        }

        private boolean shouldEnable() {
            return ConsoleUI.this.m_fileDistribution.getAgentCacheState().getOutOfDate();
        }

        public void actionPerformed(ActionEvent event) {
            this.distribute(null);
        }

        public void distribute(Runnable onCompletionCallback) {
            FileDistributionHandler distributionHandler = ConsoleUI.this.m_fileDistribution.getHandler();
            ProgressMonitor progressMonitor = new ProgressMonitor(ConsoleUI.this.m_frame, this.getValue("Name"), "", 0, 100);
            progressMonitor.setMillisToDecideToPopup(0);
            progressMonitor.setMillisToPopup(0);
            Runnable distributionRunnable = new Runnable(this, progressMonitor, distributionHandler, onCompletionCallback){
                private final /* synthetic */ ProgressMonitor val$progressMonitor;
                private final /* synthetic */ FileDistributionHandler val$distributionHandler;
                private final /* synthetic */ Runnable val$onCompletionCallback;
                private final /* synthetic */ DistributeFilesAction this$1;
                {
                    this.this$1 = this$1;
                    this.val$progressMonitor = val$progressMonitor;
                    this.val$distributionHandler = val$distributionHandler;
                    this.val$onCompletionCallback = val$onCompletionCallback;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    while (!this.val$progressMonitor.isCanceled()) {
                        try {
                            FileDistributionHandler.Result result = this.val$distributionHandler.sendNextFile();
                            if (result == null) break;
                            this.val$progressMonitor.setProgress(result.getProgressInCents());
                            this.val$progressMonitor.setNote(result.getFileName());
                        }
                        catch (FileContents.FileContentsException e) {
                            e.printStackTrace();
                        }
                    }
                    this.val$progressMonitor.close();
                    if (this.val$onCompletionCallback != null) {
                        Condition condition = DistributeFilesAction.access$2900(this.this$1);
                        synchronized (condition) {
                            for (int i = 0; i < 5 && DistributeFilesAction.access$2800(this.this$1); ++i) {
                                DistributeFilesAction.access$2900(this.this$1).waitNoInterrruptException(1000L);
                            }
                        }
                        SwingUtilities.invokeLater(this.val$onCompletionCallback);
                    }
                }
            };
            new Thread(distributionRunnable).start();
        }

        static /* synthetic */ boolean access$2800(DistributeFilesAction x0) {
            return x0.shouldEnable();
        }

        static /* synthetic */ Condition access$2900(DistributeFilesAction x0) {
            return x0.m_cacheStateCondition;
        }
    }

    private final class ChooseDirectoryAction
    extends CustomAction {
        private final JFileChooser m_fileChooser;

        ChooseDirectoryAction() {
            super(ConsoleUI.this.m_resources, "choose-directory", true);
            this.m_fileChooser = new JFileChooser(".");
            this.m_fileChooser.setDialogTitle(ConsoleUI.this.m_resources.getString("choose-directory.tip"));
            this.m_fileChooser.setFileSelectionMode(1);
            this.m_fileChooser.setSelectedFile(ConsoleUI.this.m_properties.getDistributionDirectory().getFile());
            ConsoleUI.this.m_lookAndFeel.addListener(new LookAndFeel.ComponentListener(this.m_fileChooser));
        }

        public void actionPerformed(ActionEvent event) {
            try {
                String title = MnemonicHeuristics.removeMnemonicMarkers(ConsoleUI.this.m_resources.getString("choose-directory.label"));
                if (this.m_fileChooser.showDialog(ConsoleUI.this.m_frame, title) == 0) {
                    Directory directory = new Directory(this.m_fileChooser.getSelectedFile());
                    File file = directory.getFile();
                    if (!file.exists()) {
                        if (JOptionPane.showConfirmDialog(ConsoleUI.this.m_frame, ConsoleUI.this.m_resources.getString("createDirectory.text"), file.toString(), 0) == 1) {
                            return;
                        }
                        directory.create();
                    }
                    ConsoleProperties properties = ConsoleUI.this.m_properties;
                    properties.setAndSaveDistributionDirectory(directory);
                }
            }
            catch (IOException e) {
                UncheckedInterruptedException.ioException(e);
                ConsoleUI.this.getErrorHandler().handleException(e);
            }
            catch (GrinderException e) {
                ConsoleUI.this.getErrorHandler().handleException(e);
            }
        }
    }

    private final class StopProcessesAction
    extends CustomAction {
        StopProcessesAction() {
            super(ConsoleUI.this.m_resources, "stop-processes");
            ConsoleUI.this.m_processControl.addProcessStatusListener(new EnableIfAgentsConnected(this));
        }

        public void actionPerformed(ActionEvent event) {
            try {
                int chosen = ConsoleUI.this.m_optionalConfirmDialog.show(ConsoleUI.this.m_resources.getString("stopProcessesConfirmation.text"), (String)this.getValue("Name"), 2, "stopProcessesAsk");
                if (chosen != 0 && chosen != 999) {
                    return;
                }
            }
            catch (GrinderException e) {
                ConsoleUI.this.getErrorHandler().handleException(e);
                return;
            }
            ConsoleUI.this.m_processControl.stopAgentAndWorkerProcesses();
        }
    }

    private final class ResetProcessesAction
    extends CustomAction {
        ResetProcessesAction() {
            super(ConsoleUI.this.m_resources, "reset-processes");
            ConsoleUI.this.m_processControl.addProcessStatusListener(new EnableIfAgentsConnected(this));
        }

        public void actionPerformed(ActionEvent event) {
            ConsoleProperties properties = ConsoleUI.this.m_properties;
            try {
                int chosen = ConsoleUI.this.m_optionalConfirmDialog.show(ConsoleUI.this.m_resources.getString("resetConsoleWithProcessesConfirmation.text"), (String)this.getValue("Name"), 1, "resetConsoleWithProcessesAsk");
                switch (chosen) {
                    case 0: {
                        properties.setResetConsoleWithProcesses(true);
                        break;
                    }
                    case 1: {
                        properties.setResetConsoleWithProcesses(false);
                        break;
                    }
                    case 999: {
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
            catch (GrinderException e) {
                ConsoleUI.this.getErrorHandler().handleException(e);
                return;
            }
            if (properties.getResetConsoleWithProcesses()) {
                ConsoleUI.this.m_model.reset();
                ConsoleUI.this.m_sampleModelViews.resetStatisticsViews();
            }
            ConsoleUI.this.m_processControl.resetWorkerProcesses();
        }
    }

    private class StartProcessesAction
    extends CustomAction {
        StartProcessesAction() {
            super(ConsoleUI.this.m_resources, "start-processes");
            ConsoleUI.this.m_processControl.addProcessStatusListener(new EnableIfAgentsConnected(this));
        }

        public void actionPerformed(ActionEvent event) {
            try {
                File propertiesFile = ConsoleUI.this.m_editorModel.getSelectedPropertiesFile();
                if (propertiesFile == null) {
                    int chosen = ConsoleUI.this.m_optionalConfirmDialog.show(ConsoleUI.this.m_resources.getString("propertiesNotSetConfirmation.text"), (String)this.getValue("Name"), 2, "propertiesNotSetAsk");
                    if (chosen != 0 && chosen != 999) {
                        return;
                    }
                    ConsoleUI.this.m_processControl.startWorkerProcesses(null);
                } else {
                    int chosen;
                    if (ConsoleUI.this.m_editorModel.isABufferDirty() && (chosen = ConsoleUI.this.m_optionalConfirmDialog.show(ConsoleUI.this.m_resources.getString("startWithUnsavedBuffersConfirmation.text"), (String)this.getValue("Name"), 2, "startWithUnsavedBuffersAsk")) != 0 && chosen != 999) {
                        return;
                    }
                    if (ConsoleUI.this.m_fileDistribution.getAgentCacheState().getOutOfDate()) {
                        chosen = ConsoleUI.this.m_optionalConfirmDialog.show(ConsoleUI.this.m_resources.getString("cachesOutOfDateConfirmation.text"), (String)this.getValue("Name"), 2, "distributeOnStartAsk");
                        if (chosen != 0 && chosen != 999) {
                            return;
                        }
                        ConsoleUI.this.m_distributeFilesAction.distribute(new Runnable(this, event){
                            private final /* synthetic */ ActionEvent val$event;
                            private final /* synthetic */ StartProcessesAction this$1;
                            {
                                this.this$1 = this$1;
                                this.val$event = val$event;
                            }

                            public void run() {
                                this.this$1.actionPerformed(this.val$event);
                            }
                        });
                        return;
                    }
                    GrinderProperties properties = new GrinderProperties(propertiesFile);
                    File scriptFile = properties.resolveRelativeFile(properties.getFile("grinder.script", GrinderProperties.DEFAULT_SCRIPT));
                    Directory directory = ConsoleUI.this.m_properties.getDistributionDirectory();
                    File relativePath = directory.getRelativePath(scriptFile);
                    if (relativePath != null && !directory.getFile(relativePath).isFile()) {
                        ConsoleUI.this.getErrorHandler().handleErrorMessage(ConsoleUI.this.m_resources.getString("scriptNotInDirectoryError.text"), (String)this.getValue("Name"));
                        return;
                    }
                    properties.setAssociatedFile(directory.getRelativePath(propertiesFile));
                    ConsoleUI.this.m_processControl.startWorkerProcesses(properties);
                }
            }
            catch (GrinderException e) {
                ConsoleUI.this.getErrorHandler().handleException(e);
            }
        }
    }

    private class EnableIfAgentsConnected
    implements ProcessControl.Listener {
        private final Action m_action;

        EnableIfAgentsConnected(Action action) {
            this.m_action = action;
            this.enableOrDisable();
        }

        public final void update(ProcessControl.ProcessReports[] processStatuses) {
            this.enableOrDisable();
        }

        protected final void enableOrDisable() {
            this.m_action.setEnabled(this.shouldEnable());
        }

        protected boolean shouldEnable() {
            return ConsoleUI.this.m_processControl.getNumberOfLiveAgents() > 0;
        }
    }

    private final class CloseFileAction
    extends CustomAction {
        public CloseFileAction() {
            super(ConsoleUI.this.m_resources, "close-file");
            ConsoleUI.this.m_editorModel.addListener(new EditorModel.AbstractListener(this){
                private final /* synthetic */ CloseFileAction this$1;
                {
                    this.this$1 = this$1;
                }

                public void bufferStateChanged(Buffer ignored) {
                    this.this$1.setEnabled(ConsoleUI.access$200(CloseFileAction.access$2300(this.this$1)).getSelectedBuffer() != null);
                }
            });
        }

        public void actionPerformed(ActionEvent event) {
            this.closeBuffer(ConsoleUI.this.m_editorModel.getSelectedBuffer());
        }

        boolean closeBuffer(Buffer buffer) {
            if (buffer != null) {
                while (buffer.isDirty()) {
                    String confirmationMessage = MessageFormat.format(ConsoleUI.this.m_resources.getString("saveModifiedBufferConfirmation.text"), buffer.getDisplayName());
                    int chosen = JOptionPane.showConfirmDialog(ConsoleUI.this.m_frame, confirmationMessage, (String)this.getValue("Name"), 1);
                    if (chosen == 0) {
                        try {
                            if (buffer.getFile() != null) {
                                buffer.save();
                                continue;
                            }
                            ConsoleUI.this.m_saveFileAsAction.saveBufferAs(buffer);
                            continue;
                        }
                        catch (GrinderException e) {
                            ConsoleUI.this.getErrorHandler().handleException(e);
                            return false;
                        }
                    }
                    if (chosen == 1) break;
                    return false;
                }
                ConsoleUI.this.m_editorModel.closeBuffer(buffer);
            }
            return true;
        }

        static /* synthetic */ ConsoleUI access$2300(CloseFileAction x0) {
            return x0.ConsoleUI.this;
        }
    }

    private final class SaveFileAsAction
    extends CustomAction {
        private final JFileChooser m_fileChooser;

        public SaveFileAsAction() {
            super(ConsoleUI.this.m_resources, "save-file-as", true);
            this.m_fileChooser = new JFileChooser(".");
            ConsoleUI.this.m_editorModel.addListener(new EditorModel.AbstractListener(this){
                private final /* synthetic */ SaveFileAsAction this$1;
                {
                    this.this$1 = this$1;
                }

                public void bufferStateChanged(Buffer ignored) {
                    this.this$1.setEnabled(ConsoleUI.access$200(SaveFileAsAction.access$2200(this.this$1)).getSelectedBuffer() != null);
                }
            });
            this.m_fileChooser.setDialogTitle(MnemonicHeuristics.removeMnemonicMarkers(ConsoleUI.this.m_resources.getString("save-file-as.label")));
            String pythonFilesText = ConsoleUI.this.m_resources.getString("pythonScripts.label");
            this.m_fileChooser.addChoosableFileFilter(new FileFilter(this, pythonFilesText){
                private final /* synthetic */ String val$pythonFilesText;
                private final /* synthetic */ SaveFileAsAction this$1;
                {
                    this.this$1 = this$1;
                    this.val$pythonFilesText = val$pythonFilesText;
                }

                public boolean accept(File file) {
                    return ConsoleUI.access$200(SaveFileAsAction.access$2200(this.this$1)).isPythonFile(file) || file.isDirectory();
                }

                public String getDescription() {
                    return this.val$pythonFilesText;
                }
            });
            ConsoleUI.this.m_lookAndFeel.addListener(new LookAndFeel.ComponentListener(this.m_fileChooser));
        }

        public void actionPerformed(ActionEvent event) {
            try {
                this.saveBufferAs(ConsoleUI.this.m_editorModel.getSelectedBuffer());
            }
            catch (ConsoleException e) {
                ConsoleUI.this.getErrorHandler().handleException(e);
            }
        }

        void saveBufferAs(Buffer buffer) throws ConsoleException {
            File currentFile = buffer.getFile();
            Directory distributionDirectory = ConsoleUI.this.m_properties.getDistributionDirectory();
            if (currentFile != null) {
                this.m_fileChooser.setSelectedFile(currentFile);
            } else {
                this.m_fileChooser.setCurrentDirectory(distributionDirectory.getFile());
            }
            if (this.m_fileChooser.showSaveDialog(ConsoleUI.this.m_frame) != 0) {
                return;
            }
            File file = this.m_fileChooser.getSelectedFile();
            if (!distributionDirectory.isParentOf(file) && JOptionPane.showConfirmDialog(ConsoleUI.this.m_frame, ConsoleUI.this.m_resources.getString("saveOutsideOfDistributionConfirmation.text"), (String)this.getValue("Name"), 0) == 1) {
                return;
            }
            if (!file.equals(currentFile)) {
                Buffer oldBuffer = ConsoleUI.this.m_editorModel.getBufferForFile(file);
                if (oldBuffer != null) {
                    ArrayList<String> messages = new ArrayList<String>();
                    messages.add(ConsoleUI.this.m_resources.getString("ignoreExistingBufferConfirmation.text"));
                    if (oldBuffer.isDirty()) {
                        messages.add(ConsoleUI.this.m_resources.getString("existingBufferHasUnsavedChanges.text"));
                    }
                    if (!oldBuffer.isUpToDate()) {
                        messages.add(ConsoleUI.this.m_resources.getString("existingBufferOutOfDate.text"));
                    }
                    messages.add(ConsoleUI.this.m_resources.getString("ignoreExistingBufferConfirmation2.text"));
                    if (JOptionPane.showConfirmDialog(ConsoleUI.this.m_frame, messages.toArray(), file.toString(), 0) == 1) {
                        return;
                    }
                    ConsoleUI.this.m_editorModel.closeBuffer(oldBuffer);
                } else if (file.exists() && JOptionPane.showConfirmDialog(ConsoleUI.this.m_frame, ConsoleUI.this.m_resources.getString("overwriteConfirmation.text"), file.toString(), 0) == 1) {
                    return;
                }
            } else if (!buffer.isUpToDate() && JOptionPane.showConfirmDialog(ConsoleUI.this.m_frame, ConsoleUI.this.m_resources.getString("outOfDateOverwriteConfirmation.text"), buffer.getFile().toString(), 0) == 1) {
                return;
            }
            buffer.save(file);
        }

        static /* synthetic */ ConsoleUI access$2200(SaveFileAsAction x0) {
            return x0.ConsoleUI.this;
        }
    }

    private final class SaveFileAction
    extends CustomAction {
        public SaveFileAction() {
            super(ConsoleUI.this.m_resources, "save-file");
            ConsoleUI.this.m_editorModel.addListener(new EditorModel.AbstractListener(this){
                private final /* synthetic */ SaveFileAction this$1;
                {
                    this.this$1 = this$1;
                }

                public void bufferStateChanged(Buffer ignored) {
                    Buffer buffer = ConsoleUI.access$200(SaveFileAction.access$2000(this.this$1)).getSelectedBuffer();
                    this.this$1.setEnabled(buffer != null && buffer.isDirty());
                }
            });
        }

        public void actionPerformed(ActionEvent event) {
            try {
                Buffer buffer = ConsoleUI.this.m_editorModel.getSelectedBuffer();
                if (buffer.getFile() != null) {
                    if (!buffer.isUpToDate() && JOptionPane.showConfirmDialog(ConsoleUI.this.m_frame, ConsoleUI.this.m_resources.getString("outOfDateOverwriteConfirmation.text"), buffer.getFile().toString(), 0) == 1) {
                        return;
                    }
                    buffer.save();
                } else {
                    ConsoleUI.this.m_saveFileAsAction.saveBufferAs(buffer);
                }
            }
            catch (ConsoleException e) {
                ConsoleUI.this.getErrorHandler().handleException(e);
            }
        }

        static /* synthetic */ ConsoleUI access$2000(SaveFileAction x0) {
            return x0.ConsoleUI.this;
        }
    }

    private final class NewFileAction
    extends CustomAction {
        public NewFileAction() {
            super(ConsoleUI.this.m_resources, "new-file");
        }

        public void actionPerformed(ActionEvent event) {
            ConsoleUI.this.m_editorModel.selectNewBuffer();
        }
    }

    private final class StopAction
    extends CustomAction {
        StopAction() {
            super(ConsoleUI.this.m_resources, "stop");
        }

        public void actionPerformed(ActionEvent e) {
            ConsoleUI.this.m_model.stop();
            this.stopped();
        }

        public void stopped() {
            this.firePropertyChange("setAction", null, ConsoleUI.this.m_startAction);
        }
    }

    private final class StartAction
    extends CustomAction {
        StartAction() {
            super(ConsoleUI.this.m_resources, "start");
        }

        public void actionPerformed(ActionEvent e) {
            ConsoleUI.this.m_model.start();
            this.firePropertyChange("setAction", null, ConsoleUI.this.m_stopAction);
        }
    }

    private final class ExitAction
    extends CustomAction {
        ExitAction() {
            super(ConsoleUI.this.m_resources, "exit");
        }

        public void actionPerformed(ActionEvent e) {
            this.exit();
        }

        void exit() {
            try {
                ConsoleUI.this.m_frameBounds.store();
            }
            catch (ConsoleException e) {
                ConsoleUI.this.getErrorHandler().handleException(e);
            }
            Buffer[] buffers = ConsoleUI.this.m_editorModel.getBuffers();
            for (int i = 0; i < buffers.length; ++i) {
                if (ConsoleUI.this.m_closeFileAction.closeBuffer(buffers[i])) continue;
                return;
            }
            System.exit(0);
        }
    }

    private final class AboutAction
    extends CustomAction {
        private final ImageIcon m_logoIcon;

        AboutAction(ImageIcon logoIcon) {
            super(ConsoleUI.this.m_resources, "about", true);
            this.m_logoIcon = logoIcon;
        }

        public void actionPerformed(ActionEvent event) {
            Resources resources = ConsoleUI.this.m_resources;
            String title = MnemonicHeuristics.removeMnemonicMarkers(resources.getString("about.label"));
            String aboutText = resources.getStringFromFile("about.text", true);
            JEditorPane htmlPane = new JEditorPane("text/html", aboutText);
            htmlPane.setEditable(false);
            htmlPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            htmlPane.setBackground(new JLabel().getBackground());
            JScrollPane contents = new JScrollPane(this, htmlPane, 20, 31){
                private final /* synthetic */ AboutAction this$1;
                {
                    this.this$1 = this$1;
                    super(x0, x1, x2);
                }

                public Dimension getPreferredSize() {
                    Dimension d = super.getPreferredSize();
                    d.width = 500;
                    d.height = 400;
                    return d;
                }
            };
            htmlPane.setCaretPosition(0);
            JOptionPane.showMessageDialog(ConsoleUI.this.m_frame, contents, title, -1, this.m_logoIcon);
        }
    }

    private final class OptionsAction
    extends CustomAction {
        private final OptionsDialogHandler m_optionsDialogHandler;

        OptionsAction() {
            super(ConsoleUI.this.m_resources, "options", true);
            this.m_optionsDialogHandler = new OptionsDialogHandler(this, ConsoleUI.this.m_frame, ConsoleUI.this.m_lookAndFeel, ConsoleUI.this.m_properties, ConsoleUI.this.m_resources){
                private final /* synthetic */ OptionsAction this$1;
                {
                    this.this$1 = this$1;
                    super(x0, x1, x2, x3);
                }

                protected void setNewOptions(ConsoleProperties newOptions) {
                    ConsoleUI.access$100(OptionsAction.access$1500(this.this$1)).set(newOptions);
                    ConsoleUI.access$1600(OptionsAction.access$1500(this.this$1)).refresh();
                }
            };
        }

        public void actionPerformed(ActionEvent event) {
            this.m_optionsDialogHandler.showDialog(ConsoleUI.this.m_properties);
        }

        static /* synthetic */ ConsoleUI access$1500(OptionsAction x0) {
            return x0.ConsoleUI.this;
        }
    }

    private final class SaveResultsAction
    extends CustomAction {
        private final JFileChooser m_fileChooser;

        SaveResultsAction() {
            super(ConsoleUI.this.m_resources, "save-results", true);
            this.m_fileChooser = new JFileChooser(".");
            this.m_fileChooser.setDialogTitle(MnemonicHeuristics.removeMnemonicMarkers(ConsoleUI.this.m_resources.getString("save-results.label")));
            this.m_fileChooser.setSelectedFile(new File(ConsoleUI.this.m_resources.getString("default.filename")));
            ConsoleUI.this.m_lookAndFeel.addListener(new LookAndFeel.ComponentListener(this.m_fileChooser));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent event) {
            if (this.m_fileChooser.showSaveDialog(ConsoleUI.this.m_frame) == 0) {
                File file = this.m_fileChooser.getSelectedFile();
                if (file.exists() && JOptionPane.showConfirmDialog(ConsoleUI.this.m_frame, ConsoleUI.this.m_resources.getString("overwriteConfirmation.text"), file.toString(), 0) == 1) {
                    return;
                }
                FileWriter writer = null;
                try {
                    writer = new FileWriter(file);
                    ConsoleUI.this.m_cumulativeTableModel.write(writer, "\t", System.getProperty("line.separator"));
                }
                catch (IOException e) {
                    try {
                        UncheckedInterruptedException.ioException(e);
                        ConsoleUI.this.getErrorHandler().handleErrorMessage(e.getMessage(), ConsoleUI.this.m_resources.getString("fileError.title"));
                    }
                    catch (Throwable throwable) {
                        Closer.close(writer);
                        throw throwable;
                    }
                    Closer.close(writer);
                }
                Closer.close(writer);
            }
        }
    }

    private final class WindowCloseAdapter
    extends WindowAdapter {
        private WindowCloseAdapter() {
        }

        public void windowClosing(WindowEvent e) {
            ConsoleUI.this.m_exitAction.exit();
        }
    }

    private static class ActionTable {
        private final Map m_map = new HashMap();

        private ActionTable() {
        }

        public void add(CustomAction action) {
            this.m_map.put(action.getKey(), action);
        }

        public void setAction(AbstractButton button, String actionKey) {
            CustomAction action = (CustomAction)this.m_map.get(actionKey);
            if (action != null) {
                button.setAction(action);
                action.registerButton(button);
            } else {
                System.err.println("Action '" + actionKey + "' not found");
                button.setEnabled(false);
            }
        }
    }

    private final class ToolBarAssembler
    extends ListTokeniserTemplate {
        private final boolean m_small;

        protected ToolBarAssembler(JComponent component, boolean small) {
            super(component);
            this.m_small = small;
        }

        protected void dash() {
            ((JToolBar)this.getComponent()).addSeparator();
        }

        protected void token(String key) {
            CustomJButton button = new CustomJButton();
            if (this.m_small) {
                button.setBorder(BorderFactory.createEmptyBorder());
            }
            this.getComponent().add(button);
            ConsoleUI.this.m_actionTable.setAction(button, key);
        }
    }

    private final class MenuBarAssembler
    extends ListTokeniserTemplate {
        protected MenuBarAssembler(JComponent component) {
            super(component);
            new MnemonicHeuristics(component);
        }

        protected void greaterThan() {
            this.getComponent().add(Box.createHorizontalGlue());
        }

        protected void token(String key) {
            JMenu menu = new JMenu(ConsoleUI.this.m_resources.getString(key + ".menu.label"));
            new MenuAssembler(menu).populate(key + ".menu");
            this.getComponent().add(menu);
        }
    }

    private final class PopupMenuAssembler
    extends AbstractMenuAssembler {
        protected PopupMenuAssembler(JPopupMenu component) {
            super(component);
            component.addContainerListener(new ContainerAdapter(this, ConsoleUI.this){
                private final /* synthetic */ ConsoleUI val$this$0;
                private final /* synthetic */ PopupMenuAssembler this$1;
                {
                    this.this$1 = this$1;
                    this.val$this$0 = val$this$0;
                }

                public void componentAdded(ContainerEvent e) {
                    if (e.getChild() instanceof JMenuItem) {
                        JMenuItem menuItem = (JMenuItem)e.getChild();
                        menuItem.setVisible(((CustomAction)menuItem.getAction()).isRelevantToSelection());
                        menuItem.getAction().addPropertyChangeListener(new PropertyChangeListener(this, menuItem){
                            private final /* synthetic */ JMenuItem val$menuItem;
                            private final /* synthetic */ 7 this$2;
                            {
                                this.this$2 = this$2;
                                this.val$menuItem = val$menuItem;
                            }

                            public void propertyChange(PropertyChangeEvent evt) {
                                if (evt.getPropertyName().equals("RelevantToSelection")) {
                                    this.val$menuItem.setVisible(((CustomAction)this.val$menuItem.getAction()).isRelevantToSelection());
                                }
                            }
                        });
                    }
                }
            });
        }

        protected void dash() {
            ((JPopupMenu)this.getComponent()).addSeparator();
        }
    }

    private final class MenuAssembler
    extends AbstractMenuAssembler {
        protected MenuAssembler(JMenu component) {
            super(component);
        }

        protected void dash() {
            ((JMenu)this.getComponent()).addSeparator();
        }
    }

    private abstract class AbstractMenuAssembler
    extends ListTokeniserTemplate {
        protected AbstractMenuAssembler(JComponent component) {
            super(component);
            new MnemonicHeuristics(component);
        }

        protected void token(String menuItemKey) {
            JMenuItem menuItem = new JMenuItem(this){
                private final /* synthetic */ AbstractMenuAssembler this$1;
                {
                    this.this$1 = this$1;
                }

                public Dimension getPreferredSize() {
                    Dimension d = super.getPreferredSize();
                    d.height = (int)((double)d.height * 0.9);
                    return d;
                }
            };
            ConsoleUI.this.m_actionTable.setAction(menuItem, menuItemKey);
            Icon icon = menuItem.getIcon();
            Icon rolloverIcon = (Icon)menuItem.getAction().getValue("RolloverIcon");
            menuItem.addChangeListener(new ChangeListener(this, menuItem, rolloverIcon, icon){
                private final /* synthetic */ JMenuItem val$menuItem;
                private final /* synthetic */ Icon val$rolloverIcon;
                private final /* synthetic */ Icon val$icon;
                private final /* synthetic */ AbstractMenuAssembler this$1;
                {
                    this.this$1 = this$1;
                    this.val$menuItem = val$menuItem;
                    this.val$rolloverIcon = val$rolloverIcon;
                    this.val$icon = val$icon;
                }

                public void stateChanged(ChangeEvent e) {
                    this.val$menuItem.setIcon(this.val$menuItem.isArmed() ? this.val$rolloverIcon : this.val$icon);
                }
            });
            this.getComponent().add(menuItem);
        }
    }

    private abstract class ListTokeniserTemplate {
        private final JComponent m_component;

        protected ListTokeniserTemplate(JComponent component) {
            this.m_component = component;
        }

        public void populate(String key) {
            String tokens = ConsoleUI.this.m_resources.getString(key);
            Iterator<Object> iterator = Collections.list(new StringTokenizer(tokens)).iterator();
            while (iterator.hasNext()) {
                String itemKey = (String)iterator.next();
                if ("-".equals(itemKey)) {
                    this.dash();
                    continue;
                }
                if (">".equals(itemKey)) {
                    this.greaterThan();
                    continue;
                }
                this.token(itemKey);
            }
        }

        protected final JComponent getComponent() {
            return this.m_component;
        }

        protected void dash() {
        }

        protected void greaterThan() {
        }

        protected abstract void token(String var1);
    }

    private final class LookAndFeelListener
    extends LookAndFeel.ComponentListener {
        private LookAndFeelListener() {
            super(ConsoleUI.this.m_frame);
        }

        public void lookAndFeelChanged() {
            ConsoleUI.this.m_frame.setVisible(false);
            try {
                ConsoleUI.this.m_frameBounds.store();
            }
            catch (ConsoleException e) {
                ConsoleUI.this.getErrorHandler().handleException(e);
            }
            super.lookAndFeelChanged();
            ConsoleUI.this.m_frameBounds.restore();
            ConsoleUI.this.m_frame.setVisible(true);
        }
    }
}

