/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.tools.tcpproxy;

import net.grinder.tools.tcpproxy.EndPoint;

public final class ConnectionDetails {
    private final EndPoint m_localEndPoint;
    private final EndPoint m_remoteEndPoint;
    private final boolean m_isSecure;
    private final String m_connectionDescription;
    private final ConnectionDetails m_origin;

    public ConnectionDetails(EndPoint localEndPoint, EndPoint remoteEndPoint, boolean isSecure) {
        this.m_localEndPoint = localEndPoint;
        this.m_remoteEndPoint = remoteEndPoint;
        this.m_isSecure = isSecure;
        this.m_origin = this;
        this.m_connectionDescription = this.createConnectionDescription(localEndPoint, remoteEndPoint, isSecure);
    }

    private ConnectionDetails(EndPoint localEndPoint, EndPoint remoteEndPoint, boolean isSecure, ConnectionDetails origin) {
        this.m_localEndPoint = localEndPoint;
        this.m_remoteEndPoint = remoteEndPoint;
        this.m_isSecure = isSecure;
        this.m_origin = origin;
        this.m_connectionDescription = this.createConnectionDescription(localEndPoint, remoteEndPoint, isSecure);
    }

    private String createConnectionDescription(EndPoint localEndPoint, EndPoint remoteEndPoint, boolean isSecure) {
        int c = localEndPoint.compareTo(remoteEndPoint);
        if (c == 0) {
            throw new IllegalArgumentException("Local and remote sockets are the same");
        }
        if (c < 0) {
            return localEndPoint + "|" + remoteEndPoint + "|" + isSecure;
        }
        return remoteEndPoint + "|" + localEndPoint + "|" + isSecure;
    }

    public String toString() {
        return this.m_localEndPoint + "->" + this.m_remoteEndPoint;
    }

    public boolean isSecure() {
        return this.m_isSecure;
    }

    public EndPoint getRemoteEndPoint() {
        return this.m_remoteEndPoint;
    }

    public EndPoint getLocalEndPoint() {
        return this.m_localEndPoint;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || other.getClass() != ConnectionDetails.class) {
            return false;
        }
        ConnectionDetails otherConnectionDetails = (ConnectionDetails)other;
        return this.m_origin == otherConnectionDetails.m_origin && this.getLocalEndPoint().equals(otherConnectionDetails.getLocalEndPoint());
    }

    public int hashCode() {
        return this.m_connectionDescription.hashCode();
    }

    public String getConnectionIdentity() {
        return this.m_connectionDescription;
    }

    public ConnectionDetails getOtherEnd() {
        return new ConnectionDetails(this.getRemoteEndPoint(), this.getLocalEndPoint(), this.isSecure(), this.m_origin);
    }
}

