/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.console.swingui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import net.grinder.console.common.ConsoleException;
import net.grinder.console.editor.AbstractTextSource;
import net.grinder.console.editor.Buffer;
import net.grinder.console.editor.EditorModel;
import net.grinder.console.editor.TextSource;
import net.grinder.console.swingui.Colours;
import org.syntax.jedit.JEditTextArea;
import org.syntax.jedit.SyntaxDocument;
import org.syntax.jedit.SyntaxStyle;
import org.syntax.jedit.TextAreaDefaults;
import org.syntax.jedit.TextAreaPainter;
import org.syntax.jedit.tokenmarker.BatchFileTokenMarker;
import org.syntax.jedit.tokenmarker.HTMLTokenMarker;
import org.syntax.jedit.tokenmarker.JavaTokenMarker;
import org.syntax.jedit.tokenmarker.PropsTokenMarker;
import org.syntax.jedit.tokenmarker.PythonTokenMarker;
import org.syntax.jedit.tokenmarker.ShellScriptTokenMarker;
import org.syntax.jedit.tokenmarker.TokenMarker;
import org.syntax.jedit.tokenmarker.XMLTokenMarker;

final class Editor {
    private final EditorModel m_editorModel;
    private final CustomJEditTextArea m_scriptTextArea;

    public Editor(EditorModel editorModel, Action saveFileAsAction) throws ConsoleException {
        this.m_editorModel = editorModel;
        TextAreaDefaults textAreaDefaults = TextAreaDefaults.getDefaults();
        SyntaxStyle[] styles = textAreaDefaults.styles;
        styles[6] = new SyntaxStyle(Colours.RED, false, false);
        styles[7] = styles[6];
        styles[8] = styles[6];
        styles[1] = new SyntaxStyle(Colours.DARK_GREEN, true, false);
        styles[3] = new SyntaxStyle(Colours.BLUE, false, false);
        styles[4] = styles[3];
        textAreaDefaults.caretColor = Colours.DARK_RED;
        textAreaDefaults.lineHighlightColor = Colours.FAINT_YELLOW;
        textAreaDefaults.bracketHighlightColor = Colours.GREY;
        textAreaDefaults.selectionColor = Colours.GREY;
        textAreaDefaults.cols = 1;
        textAreaDefaults.inputHandler.addKeyBinding("C+S", saveFileAsAction);
        this.m_scriptTextArea = new CustomJEditTextArea(textAreaDefaults);
        this.m_scriptTextArea.setBorder(BorderFactory.createEtchedBorder());
        this.m_editorModel.addListener(new EditorModel.AbstractListener(){

            public void bufferStateChanged(Buffer buffer) {
                Buffer selectedBuffer = Editor.this.m_editorModel.getSelectedBuffer();
                if (selectedBuffer == null) {
                    Editor.this.m_scriptTextArea.setDocument(new SyntaxDocument());
                    Editor.this.m_scriptTextArea.setEnabled(false);
                } else if (buffer.equals(selectedBuffer)) {
                    JEditSyntaxTextSource textSource = (JEditSyntaxTextSource)buffer.getTextSource();
                    Editor.this.m_scriptTextArea.setDocument(textSource.getSyntaxDocument());
                    Editor.this.m_scriptTextArea.setTokenMarker(Editor.this.getTokenMarker(buffer.getType()));
                    Editor.this.m_scriptTextArea.setEnabled(true);
                    Editor.this.m_scriptTextArea.requestFocus();
                }
                Editor.this.m_scriptTextArea.repaint();
            }
        });
        this.m_scriptTextArea.setEnabled(false);
    }

    public JComponent getComponent() {
        return this.m_scriptTextArea;
    }

    private TokenMarker getTokenMarker(Buffer.Type bufferType) {
        if (bufferType == Buffer.HTML_BUFFER) {
            return new HTMLTokenMarker();
        }
        if (bufferType == Buffer.JAVA_BUFFER) {
            return new JavaTokenMarker();
        }
        if (bufferType == Buffer.MSDOS_BATCH_BUFFER) {
            return new BatchFileTokenMarker();
        }
        if (bufferType == Buffer.PROPERTIES_BUFFER) {
            return new PropsTokenMarker();
        }
        if (bufferType == Buffer.PYTHON_BUFFER) {
            return new PythonTokenMarker();
        }
        if (bufferType == Buffer.SHELL_BUFFER) {
            return new ShellScriptTokenMarker();
        }
        if (bufferType == Buffer.TEXT_BUFFER) {
            return null;
        }
        if (bufferType == Buffer.XML_BUFFER) {
            return new XMLTokenMarker();
        }
        return null;
    }

    private static final class CustomJEditTextArea
    extends JEditTextArea {
        private final Color m_enabledBackground;
        private final Color m_enabledCaretColour;

        public CustomJEditTextArea(TextAreaDefaults textAreaDefaults) {
            super(textAreaDefaults);
            TextAreaPainter thePainter = this.getPainter();
            this.m_enabledBackground = thePainter.getBackground();
            this.m_enabledCaretColour = thePainter.getCaretColor();
        }

        public Dimension getPreferredSize() {
            Dimension parentSize = this.getParent().getSize();
            Insets insets = this.getParent().getInsets();
            return new Dimension(parentSize.width - insets.left - insets.right, parentSize.height - insets.top - insets.bottom - 10);
        }

        public void setEnabled(boolean b) {
            super.setEnabled(b);
            this.setEditable(b);
            TextAreaPainter thePainter = this.getPainter();
            thePainter.setCaretColor(b ? this.m_enabledCaretColour : Colours.GREY);
            thePainter.setBackground(b ? this.m_enabledBackground : Colours.GREY);
            thePainter.setLineHighlightEnabled(b);
            if (!b) {
                this.transferFocus();
            }
            this.setRequestFocusEnabled(b);
        }

        public boolean isFocusable() {
            return this.isEnabled();
        }
    }

    static class TextSourceFactory
    implements TextSource.Factory {
        TextSourceFactory() {
        }

        public TextSource create() {
            return new JEditSyntaxTextSource();
        }
    }

    private static class JEditSyntaxTextSource
    extends AbstractTextSource {
        private final SyntaxDocument m_syntaxDocument = new SyntaxDocument();

        JEditSyntaxTextSource() {
            this.m_syntaxDocument.addDocumentListener(new DocumentListener(this){
                private final /* synthetic */ JEditSyntaxTextSource this$0;
                {
                    this.this$0 = this$0;
                }

                public void insertUpdate(DocumentEvent event) {
                    this.documentChanged();
                }

                public void removeUpdate(DocumentEvent event) {
                    this.documentChanged();
                }

                public void changedUpdate(DocumentEvent event) {
                    this.documentChanged();
                }

                private void documentChanged() {
                    JEditSyntaxTextSource.access$300(this.this$0);
                }
            });
        }

        SyntaxDocument getSyntaxDocument() {
            return this.m_syntaxDocument;
        }

        public String getText() {
            this.setClean();
            try {
                return this.m_syntaxDocument.getText(0, this.m_syntaxDocument.getLength());
            }
            catch (BadLocationException bl) {
                bl.printStackTrace();
                return "";
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setText(String text) {
            try {
                this.m_syntaxDocument.beginCompoundEdit();
                this.m_syntaxDocument.remove(0, this.m_syntaxDocument.getLength());
                this.m_syntaxDocument.insertString(0, text, null);
            }
            catch (BadLocationException bl) {
                bl.printStackTrace();
            }
            finally {
                this.m_syntaxDocument.endCompoundEdit();
            }
            this.setClean();
        }

        static /* synthetic */ void access$300(JEditSyntaxTextSource x0) {
            x0.setChanged();
        }
    }
}

