/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.util;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import net.grinder.common.SSLContextFactory;

public final class InsecureSSLContextFactory
implements SSLContextFactory {
    private static final TrustManager[] s_trustManagers = new TrustManager[]{new TrustEveryone()};
    private static final SecureRandom s_insecureRandom = new SecureRandom();
    private final KeyManager[] m_keyManagers;

    public InsecureSSLContextFactory() {
        this(null);
    }

    public InsecureSSLContextFactory(KeyManager[] keyManagers) {
        this.m_keyManagers = keyManagers;
    }

    public InsecureSSLContextFactory(InputStream keyStoreStream, char[] keyStorePassword, String keyStoreType) throws GeneralSecurityException, IOException {
        KeyStore keyStore = KeyStore.getInstance(keyStoreType);
        keyStore.load(keyStoreStream, keyStorePassword);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, keyStorePassword);
        this.m_keyManagers = keyManagerFactory.getKeyManagers();
    }

    public SSLContext getSSLContext() throws SSLContextFactory.SSLContextFactoryException {
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(this.m_keyManagers, s_trustManagers, s_insecureRandom);
            return sslContext;
        }
        catch (GeneralSecurityException e) {
            throw new SSLContextFactory.SSLContextFactoryException("The JSSE could not create the SSLContext", e);
        }
    }

    static {
        s_insecureRandom.setSeed(new byte[0]);
    }

    private static class TrustEveryone
    implements X509TrustManager {
        private TrustEveryone() {
        }

        public void checkClientTrusted(X509Certificate[] chain, String authenticationType) {
        }

        public void checkServerTrusted(X509Certificate[] chain, String authenticationType) {
        }

        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }
}

