/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.base;

import org.python.google.common.base.CharMatcher;

final class MediumCharMatcher
extends CharMatcher {
    private final char[] table;
    private final boolean containsZero;
    private final long filter;

    private MediumCharMatcher(char[] table, long filter, boolean containsZero, String description) {
        super(description);
        this.table = table;
        this.filter = filter;
        this.containsZero = containsZero;
    }

    @Override
    public final CharMatcher precomputed() {
        return this;
    }

    static CharMatcher from(char[] chars, String description) {
        int n;
        long filter = 0L;
        int size = chars.length;
        boolean containsZero = chars[0] == '\u0000';
        char[] arr$ = chars;
        int len$ = chars.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            char c = arr$[i$];
            filter |= 1L << c;
        }
        int n2 = size;
        if (n2 == 1) {
            n = 2;
        } else {
            int n3 = Integer.highestOneBit(n2 - 1) << 1;
            while ((double)n3 * 0.5 < (double)n2) {
                n3 <<= 1;
            }
            n = n3;
        }
        char[] table = new char[n];
        int mask = table.length - 1;
        char[] arr$2 = chars;
        int len$2 = chars.length;
        for (int i$ = 0; i$ < len$2; ++i$) {
            char c = arr$2[i$];
            int index = c & mask;
            while (true) {
                if (table[index] == '\u0000') break;
                index = index + 1 & mask;
            }
            table[index] = c;
        }
        return new MediumCharMatcher(table, filter, containsZero, description);
    }

    @Override
    public final boolean matches(char c) {
        int startingIndex;
        if (c == '\u0000') {
            return this.containsZero;
        }
        char c2 = c;
        MediumCharMatcher mediumCharMatcher = this;
        if (!(1L == (1L & mediumCharMatcher.filter >> c2))) {
            return false;
        }
        int mask = this.table.length - 1;
        int index = startingIndex = c & mask;
        do {
            if (this.table[index] == '\u0000') {
                return false;
            }
            if (this.table[index] != c) continue;
            return true;
        } while ((index = index + 1 & mask) != startingIndex);
        return false;
    }
}

