/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.base;

import java.util.Iterator;
import javax.annotation.CheckReturnValue;
import org.python.google.common.base.AbstractIterator;
import org.python.google.common.base.CharMatcher;
import org.python.google.common.base.Joiner;

public final class Splitter {
    private final CharMatcher trimmer;
    private final boolean omitEmptyStrings;
    private final Strategy strategy;
    private final int limit;

    private Splitter(Strategy strategy) {
        this(strategy, false, CharMatcher.NONE, Integer.MAX_VALUE);
    }

    private Splitter(Strategy strategy, boolean omitEmptyStrings, CharMatcher trimmer, int limit) {
        this.strategy = strategy;
        this.omitEmptyStrings = omitEmptyStrings;
        this.trimmer = trimmer;
        this.limit = limit;
    }

    public static Splitter on(char separator) {
        final CharMatcher charMatcher = CharMatcher.is(separator);
        CharMatcher.LookupTable.checkNotNull(charMatcher);
        return new Splitter(new Strategy(){});
    }

    @CheckReturnValue
    public final Splitter trimResults() {
        CharMatcher charMatcher = CharMatcher.WHITESPACE;
        Splitter splitter = this;
        CharMatcher.LookupTable.checkNotNull(charMatcher);
        return new Splitter(splitter.strategy, splitter.omitEmptyStrings, charMatcher, splitter.limit);
    }

    public final Iterable<String> split(CharSequence sequence) {
        CharMatcher.LookupTable.checkNotNull(sequence);
        return new Iterable<String>(this, sequence){
            private /* synthetic */ CharSequence val$sequence;
            private /* synthetic */ Splitter this$0;
            {
                this.this$0 = splitter;
                this.val$sequence = charSequence;
            }

            @Override
            public final Iterator<String> iterator() {
                return Splitter.access$000(this.this$0, this.val$sequence);
            }

            public final String toString() {
                return Joiner.on(", ").appendTo(new StringBuilder("["), this).append(']').toString();
            }
        };
    }

    static /* synthetic */ Iterator access$000(Splitter x0, CharSequence x1) {
        CharSequence charSequence = x1;
        Splitter splitter = x0;
        return splitter.strategy.iterator(splitter, charSequence);
    }

    static abstract class SplittingIterator
    extends AbstractIterator<String> {
        final CharSequence toSplit;
        private CharMatcher trimmer;
        private boolean omitEmptyStrings;
        private int offset = 0;
        private int limit;

        abstract int separatorStart(int var1);

        abstract int separatorEnd(int var1);

        protected SplittingIterator(Splitter splitter, CharSequence toSplit) {
            this.trimmer = splitter.trimmer;
            this.omitEmptyStrings = splitter.omitEmptyStrings;
            this.limit = splitter.limit;
            this.toSplit = toSplit;
        }
    }

    static interface Strategy {
        public Iterator<String> iterator(Splitter var1, CharSequence var2);
    }
}

