/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.cache;

import com.kenai.jffi.ArrayFlags;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.python.google.common.base.CharMatcher;
import org.python.google.common.base.Objects$ToStringHelper;
import org.python.google.common.base.Supplier;
import org.python.google.common.base.Ticker;
import org.python.google.common.cache.AbstractCache$StatsCounter;
import org.python.google.common.cache.CacheBuilderSpec;
import org.python.google.common.cache.CacheLoader;
import org.python.google.common.cache.CacheStats;
import org.python.google.common.cache.LoadingCache;
import org.python.google.common.cache.LocalCache;
import org.python.google.common.cache.RemovalListener;
import org.python.google.common.cache.Weigher;

public final class CacheBuilder<K, V> {
    private static Supplier<? extends AbstractCache$StatsCounter> NULL_STATS_COUNTER = CharMatcher.LookupTable.ofInstance(new AbstractCache$StatsCounter(){

        @Override
        public final void recordHits(int count2) {
        }

        @Override
        public final void recordMisses(int count2) {
        }

        @Override
        public final void recordLoadSuccess(long loadTime) {
        }

        @Override
        public final void recordLoadException(long loadTime) {
        }

        @Override
        public final void recordEviction() {
        }
    });
    static final Ticker NULL_TICKER;
    private static final Logger logger;
    private boolean strictParsing = true;
    int initialCapacity = -1;
    int concurrencyLevel = -1;
    long maximumSize = -1L;
    long maximumWeight = -1L;
    Weigher<? super K, ? super V> weigher;
    LocalCache.Strength keyStrength;
    private LocalCache.Strength valueStrength;
    long expireAfterWriteNanos = -1L;
    long expireAfterAccessNanos = -1L;
    long refreshNanos = -1L;
    Supplier<? extends AbstractCache$StatsCounter> statsCounterSupplier = NULL_STATS_COUNTER;

    CacheBuilder() {
    }

    public static CacheBuilder<Object, Object> from(String spec) {
        TimeUnit timeUnit;
        CacheBuilder cacheBuilder;
        int n;
        CacheBuilderSpec cacheBuilderSpec = CacheBuilderSpec.parse(spec);
        Object object = cacheBuilderSpec;
        CacheBuilder cacheBuilder2 = new CacheBuilder();
        if (((CacheBuilderSpec)object).initialCapacity != null) {
            n = ((CacheBuilderSpec)object).initialCapacity;
            cacheBuilder = cacheBuilder2;
            CharMatcher.LookupTable.checkState(cacheBuilder.initialCapacity == -1, "initial capacity was already set to %s", cacheBuilder.initialCapacity);
            CharMatcher.LookupTable.checkArgument(n >= 0);
            cacheBuilder.initialCapacity = n;
        }
        if (((CacheBuilderSpec)object).maximumSize != null) {
            long l = ((CacheBuilderSpec)object).maximumSize;
            cacheBuilder = cacheBuilder2;
            CharMatcher.LookupTable.checkState(cacheBuilder.maximumSize == -1L, "maximum size was already set to %s", cacheBuilder.maximumSize);
            CharMatcher.LookupTable.checkState(cacheBuilder.maximumWeight == -1L, "maximum weight was already set to %s", cacheBuilder.maximumWeight);
            CharMatcher.LookupTable.checkState(cacheBuilder.weigher == null, "maximum size can not be combined with weigher");
            CharMatcher.LookupTable.checkArgument(l >= 0L, "maximum size must not be negative");
            cacheBuilder.maximumSize = l;
        }
        if (((CacheBuilderSpec)object).maximumWeight != null) {
            long l = ((CacheBuilderSpec)object).maximumWeight;
            cacheBuilder = cacheBuilder2;
            CharMatcher.LookupTable.checkState(cacheBuilder.maximumWeight == -1L, "maximum weight was already set to %s", cacheBuilder.maximumWeight);
            CharMatcher.LookupTable.checkState(cacheBuilder.maximumSize == -1L, "maximum size was already set to %s", cacheBuilder.maximumSize);
            cacheBuilder.maximumWeight = l;
            CharMatcher.LookupTable.checkArgument(l >= 0L, "maximum weight must not be negative");
        }
        if (((CacheBuilderSpec)object).concurrencyLevel != null) {
            n = ((CacheBuilderSpec)object).concurrencyLevel;
            cacheBuilder = cacheBuilder2;
            CharMatcher.LookupTable.checkState(cacheBuilder.concurrencyLevel == -1, "concurrency level was already set to %s", cacheBuilder.concurrencyLevel);
            CharMatcher.LookupTable.checkArgument(n > 0);
            cacheBuilder.concurrencyLevel = n;
        }
        if (((CacheBuilderSpec)object).keyStrength != null) {
            switch (((CacheBuilderSpec)object).keyStrength) {
                case WEAK: {
                    cacheBuilder = cacheBuilder2;
                    LocalCache.Strength strength = LocalCache.Strength.WEAK;
                    CacheBuilder cacheBuilder3 = cacheBuilder;
                    CharMatcher.LookupTable.checkState(cacheBuilder.keyStrength == null, "Key strength was already set to %s", new Object[]{cacheBuilder3.keyStrength});
                    cacheBuilder3.keyStrength = CharMatcher.LookupTable.checkNotNull(strength);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        if (((CacheBuilderSpec)object).valueStrength != null) {
            switch (((CacheBuilderSpec)object).valueStrength) {
                case SOFT: {
                    cacheBuilder = cacheBuilder2;
                    cacheBuilder.setValueStrength(LocalCache.Strength.SOFT);
                    break;
                }
                case WEAK: {
                    cacheBuilder = cacheBuilder2;
                    cacheBuilder.setValueStrength(LocalCache.Strength.WEAK);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        if (((CacheBuilderSpec)object).writeExpirationTimeUnit != null) {
            timeUnit = ((CacheBuilderSpec)object).writeExpirationTimeUnit;
            long l = ((CacheBuilderSpec)object).writeExpirationDuration;
            cacheBuilder = cacheBuilder2;
            CharMatcher.LookupTable.checkState(cacheBuilder.expireAfterWriteNanos == -1L, "expireAfterWrite was already set to %s ns", cacheBuilder.expireAfterWriteNanos);
            CharMatcher.LookupTable.checkArgument(l >= 0L, "duration cannot be negative: %s %s", new Object[]{l, timeUnit});
            cacheBuilder.expireAfterWriteNanos = timeUnit.toNanos(l);
        }
        if (((CacheBuilderSpec)object).accessExpirationTimeUnit != null) {
            timeUnit = ((CacheBuilderSpec)object).accessExpirationTimeUnit;
            long l = ((CacheBuilderSpec)object).accessExpirationDuration;
            cacheBuilder = cacheBuilder2;
            CharMatcher.LookupTable.checkState(cacheBuilder.expireAfterAccessNanos == -1L, "expireAfterAccess was already set to %s ns", cacheBuilder.expireAfterAccessNanos);
            CharMatcher.LookupTable.checkArgument(l >= 0L, "duration cannot be negative: %s %s", new Object[]{l, timeUnit});
            cacheBuilder.expireAfterAccessNanos = timeUnit.toNanos(l);
        }
        if (((CacheBuilderSpec)object).refreshTimeUnit != null) {
            timeUnit = ((CacheBuilderSpec)object).refreshTimeUnit;
            long l = ((CacheBuilderSpec)object).refreshDuration;
            cacheBuilder = cacheBuilder2;
            CharMatcher.LookupTable.checkNotNull(timeUnit);
            CharMatcher.LookupTable.checkState(cacheBuilder.refreshNanos == -1L, "refresh was already set to %s ns", cacheBuilder.refreshNanos);
            CharMatcher.LookupTable.checkArgument(l > 0L, "duration must be positive: %s %s", new Object[]{l, timeUnit});
            cacheBuilder.refreshNanos = timeUnit.toNanos(l);
        }
        object = cacheBuilder2;
        cacheBuilder2.strictParsing = false;
        return object;
    }

    public final <K1 extends K, V1 extends V> CacheBuilder<K1, V1> weigher(Weigher<? super K1, ? super V1> weigher) {
        CharMatcher.LookupTable.checkState(this.weigher == null);
        if (this.strictParsing) {
            CharMatcher.LookupTable.checkState(this.maximumSize == -1L, "weigher can not be combined with maximum size", this.maximumSize);
        }
        CacheBuilder me = this;
        this.weigher = CharMatcher.LookupTable.checkNotNull(weigher);
        return me;
    }

    final LocalCache.Strength getKeyStrength() {
        return CharMatcher.LookupTable.firstNonNull(this.keyStrength, LocalCache.Strength.STRONG);
    }

    final CacheBuilder<K, V> setValueStrength(LocalCache.Strength strength) {
        CharMatcher.LookupTable.checkState(this.valueStrength == null, "Value strength was already set to %s", new Object[]{this.valueStrength});
        this.valueStrength = CharMatcher.LookupTable.checkNotNull(strength);
        return this;
    }

    final LocalCache.Strength getValueStrength() {
        return CharMatcher.LookupTable.firstNonNull(this.valueStrength, LocalCache.Strength.STRONG);
    }

    public final <K1 extends K, V1 extends V> LoadingCache<K1, V1> build(CacheLoader<? super K1, V1> loader) {
        CacheBuilder cacheBuilder = this;
        if (cacheBuilder.weigher == null) {
            CharMatcher.LookupTable.checkState(cacheBuilder.maximumWeight == -1L, "maximumWeight requires weigher");
        } else if (cacheBuilder.strictParsing) {
            CharMatcher.LookupTable.checkState(cacheBuilder.maximumWeight != -1L, "weigher requires maximumWeight");
        } else if (cacheBuilder.maximumWeight == -1L) {
            logger.log(Level.WARNING, "ignoring weigher specified without maximumWeight");
        }
        return new LocalCache.LocalLoadingCache<K1, V1>(this, loader);
    }

    public final String toString() {
        Objects$ToStringHelper s = CharMatcher.LookupTable.toStringHelper(this);
        if (this.initialCapacity != -1) {
            s.add("initialCapacity", this.initialCapacity);
        }
        if (this.concurrencyLevel != -1) {
            s.add("concurrencyLevel", this.concurrencyLevel);
        }
        if (this.maximumWeight != -1L) {
            if (this.weigher == null) {
                s.add("maximumSize", this.maximumWeight);
            } else {
                s.add("maximumWeight", this.maximumWeight);
            }
        }
        if (this.expireAfterWriteNanos != -1L) {
            s.add("expireAfterWrite", this.expireAfterWriteNanos + "ns");
        }
        if (this.expireAfterAccessNanos != -1L) {
            s.add("expireAfterAccess", this.expireAfterAccessNanos + "ns");
        }
        if (this.keyStrength != null) {
            s.add("keyStrength", ArrayFlags.toLowerCase(this.keyStrength.toString()));
        }
        if (this.valueStrength != null) {
            s.add("valueStrength", ArrayFlags.toLowerCase(this.valueStrength.toString()));
        }
        return s.toString();
    }

    static {
        new CacheStats(0L, 0L, 0L, 0L, 0L, 0L);
        new Supplier<AbstractCache$StatsCounter>(){};
        NULL_TICKER = new Ticker(){

            @Override
            public final long read() {
                return 0L;
            }
        };
        logger = Logger.getLogger(CacheBuilder.class.getName());
    }

    static final class OneWeigher
    extends Enum<OneWeigher>
    implements Weigher<Object, Object> {
        public static final /* enum */ OneWeigher INSTANCE;

        @Override
        public final int weigh(Object key, Object value) {
            return 1;
        }

        static {
            (new OneWeigher[1])[0] = INSTANCE = new OneWeigher();
        }
    }

    static final class NullListener
    extends Enum<NullListener>
    implements RemovalListener<Object, Object> {
        public static final /* enum */ NullListener INSTANCE;

        static {
            (new NullListener[1])[0] = INSTANCE = new NullListener();
        }
    }
}

