/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.cache;

import java.io.Serializable;
import org.python.google.common.cache.Striped64;

final class LongAdder
extends Striped64
implements Serializable {
    @Override
    final long fn(long v, long x) {
        return v + x;
    }

    public final void add(long x) {
        Striped64.Cell[] as = this.cells;
        if (this.cells != null || !this.casBase(0L, x + 0L)) {
            long v;
            Striped64.Cell a;
            int n;
            boolean uncontended = true;
            Striped64.HashCode hc = (Striped64.HashCode)threadHashCode.get();
            int h = hc.code;
            if (as == null || (n = as.length) <= 0 || (a = as[n - 1 & h]) == null || !(uncontended = a.cas(v = a.value, v + x))) {
                boolean bl = uncontended;
                Striped64.HashCode hashCode = hc;
                long l = x;
                LongAdder longAdder = this;
                int n2 = hashCode.code;
                boolean bl2 = false;
                while (true) {
                    int n3;
                    Striped64.Cell[] cellArray = longAdder.cells;
                    if (longAdder.cells != null && (n3 = cellArray.length) > 0) {
                        Striped64.Cell cell = cellArray[n3 - 1 & n2];
                        if (cell == null) {
                            Striped64.Cell cell2 = new Striped64.Cell(l);
                            if (longAdder.casBusy()) {
                                boolean bl3 = false;
                                try {
                                    int n4;
                                    int n5;
                                    Striped64.Cell[] cellArray2 = longAdder.cells;
                                    if (longAdder.cells != null && (n5 = cellArray2.length) > 0 && cellArray2[n4 = n5 - 1 & n2] == null) {
                                        cellArray2[n4] = cell2;
                                        bl3 = true;
                                    }
                                }
                                finally {
                                    longAdder.busy = 0;
                                }
                                if (!bl3) continue;
                                break;
                            }
                            bl2 = false;
                        } else if (!bl) {
                            bl = true;
                        } else {
                            long l2 = cell.value;
                            if (cell.cas(l2, ((Striped64)longAdder).fn(l2, l))) break;
                            if (n3 >= Striped64.NCPU || longAdder.cells != cellArray) {
                                bl2 = false;
                            } else if (!bl2) {
                                bl2 = true;
                            } else if (longAdder.casBusy()) {
                                try {
                                    if (longAdder.cells == cellArray) {
                                        Striped64.Cell[] cellArray3 = new Striped64.Cell[n3 << 1];
                                        for (int i = 0; i < n3; ++i) {
                                            cellArray3[i] = cellArray[i];
                                        }
                                        longAdder.cells = cellArray3;
                                    }
                                }
                                finally {
                                    longAdder.busy = 0;
                                }
                                bl2 = false;
                                continue;
                            }
                        }
                        n2 ^= n2 << 13;
                        n2 ^= n2 >>> 17;
                        n2 ^= n2 << 5;
                        continue;
                    }
                    if (longAdder.cells == cellArray && longAdder.casBusy()) {
                        boolean bl4 = false;
                        try {
                            if (longAdder.cells == cellArray) {
                                Striped64.Cell[] cellArray4 = new Striped64.Cell[2];
                                Striped64.Cell[] cellArray5 = cellArray4;
                                cellArray4[n2 & 1] = new Striped64.Cell(l);
                                longAdder.cells = cellArray5;
                                bl4 = true;
                            }
                        }
                        finally {
                            longAdder.busy = 0;
                        }
                        if (bl4) break;
                        continue;
                    }
                    if (longAdder.casBase(0L, ((Striped64)longAdder).fn(0L, l))) break;
                }
                hashCode.code = n2;
            }
        }
    }

    private long sum() {
        long sum = 0L;
        Striped64.Cell[] as = this.cells;
        if (this.cells != null) {
            for (Striped64.Cell a : as) {
                if (a == null) continue;
                sum += a.value;
            }
        }
        return sum;
    }

    public final String toString() {
        return Long.toString(this.sum());
    }

    @Override
    public final long longValue() {
        return this.sum();
    }

    @Override
    public final int intValue() {
        return (int)this.sum();
    }

    @Override
    public final float floatValue() {
        return this.sum();
    }

    @Override
    public final double doubleValue() {
        return this.sum();
    }
}

