/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import org.python.indexer.Indexer;
import org.python.indexer.Scope;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNodeVisitor;
import org.python.indexer.types.NType;
import org.python.indexer.types.NUnionType;
import org.python.indexer.types.NUnknownType;

public final class NBinOp
extends NNode {
    private NNode left;
    private NNode right;
    private String op;

    public NBinOp(NNode target, NNode value, String op) {
        this(null, null, null, 0, 1);
    }

    public NBinOp(NNode target, NNode value, String op, int start, int end) {
        super(start, end);
        this.left = target;
        this.right = value;
        this.op = op;
        this.addChildren(target, value);
    }

    @Override
    public final NType resolve(Scope s) throws Exception {
        NType nType;
        NType ltype = null;
        NType rtype = null;
        if (this.left != null) {
            nType = NBinOp.resolveExpr(this.left, s);
            ltype = NUnknownType.follow(nType);
        }
        if (this.right != null) {
            nType = NBinOp.resolveExpr(this.right, s);
            rtype = NUnknownType.follow(nType);
        }
        if (ltype == Indexer.idx.builtins.BaseStr || rtype == Indexer.idx.builtins.BaseStr) {
            return this.setType(Indexer.idx.builtins.BaseStr);
        }
        if (ltype == Indexer.idx.builtins.BaseNum || rtype == Indexer.idx.builtins.BaseNum) {
            return this.setType(Indexer.idx.builtins.BaseNum);
        }
        if (ltype == null) {
            return this.setType(rtype == null ? new NUnknownType() : rtype);
        }
        if (rtype == null) {
            return this.setType(ltype == null ? new NUnknownType() : ltype);
        }
        return this.setType(NUnionType.union(ltype, rtype));
    }

    public final String toString() {
        return "<BinOp:" + this.left + " " + this.op + " " + this.right + ">";
    }

    @Override
    public final void visit(NNodeVisitor v) {
        if (v.visit(this)) {
            NBinOp.visitNode(this.left, v);
            NBinOp.visitNode(this.right, v);
        }
    }
}

