/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import java.util.List;
import org.python.indexer.Scope;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNodeVisitor;
import org.python.indexer.types.NType;

public final class NPrint
extends NNode {
    private NNode dest;
    private List<NNode> values;

    public NPrint(NNode dest, List<NNode> elts) {
        this(null, null, 0, 1);
    }

    public NPrint(NNode dest, List<NNode> elts, int start, int end) {
        super(start, end);
        this.dest = dest;
        this.values = elts;
        this.addChildren(dest);
        this.addChildren(elts);
    }

    @Override
    public final NType resolve(Scope s) throws Exception {
        NPrint.resolveExpr(this.dest, s);
        NPrint.resolveList(this.values, s);
        return this.getType();
    }

    public final String toString() {
        return "<Print:" + this.values + ">";
    }

    @Override
    public final void visit(NNodeVisitor v) {
        if (v.visit(this)) {
            NPrint.visitNode(this.dest, v);
            NPrint.visitNodeList(this.values, v);
        }
    }
}

