/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import java.util.List;
import org.python.indexer.Indexer;
import org.python.indexer.NBinding;
import org.python.indexer.Scope;
import org.python.indexer.ast.NAttribute;
import org.python.indexer.ast.NList;
import org.python.indexer.ast.NName;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NSubscript;
import org.python.indexer.ast.NTuple;
import org.python.indexer.types.NClassType;
import org.python.indexer.types.NDictType;
import org.python.indexer.types.NFuncType;
import org.python.indexer.types.NListType;
import org.python.indexer.types.NModuleType;
import org.python.indexer.types.NTupleType;
import org.python.indexer.types.NType;
import org.python.indexer.types.NUnionType;
import org.python.indexer.types.NUnknownType;

public final class NameBinder {
    private static final NameBinder DEFAULT_BINDER = new NameBinder();
    private static final NameBinder ATTRIBUTE_BINDER = new NameBinder(NBinding.Kind.ATTRIBUTE);
    private static final NameBinder CLASS_BINDER = new NameBinder(NBinding.Kind.CLASS);
    private static final NameBinder CONSTRUCTOR_BINDER = new NameBinder(NBinding.Kind.CONSTRUCTOR);
    private static final NameBinder FUNCTION_BINDER = new NameBinder(NBinding.Kind.FUNCTION);
    private static final NameBinder METHOD_BINDER = new NameBinder(NBinding.Kind.METHOD);
    private static final NameBinder MODULE_BINDER = new NameBinder(NBinding.Kind.MODULE);
    private static final NameBinder PARAMETER_BINDER = new NameBinder(NBinding.Kind.PARAMETER);
    private static final NameBinder VARIABLE_BINDER = new NameBinder(NBinding.Kind.VARIABLE);
    private NBinding.Kind kind;

    public static NameBinder make() {
        return DEFAULT_BINDER;
    }

    public static NameBinder make(NBinding.Kind kind) {
        switch (kind) {
            case ATTRIBUTE: {
                return ATTRIBUTE_BINDER;
            }
            case CLASS: {
                return CLASS_BINDER;
            }
            case CONSTRUCTOR: {
                return CONSTRUCTOR_BINDER;
            }
            case FUNCTION: {
                return FUNCTION_BINDER;
            }
            case METHOD: {
                return METHOD_BINDER;
            }
            case MODULE: {
                return MODULE_BINDER;
            }
            case PARAMETER: {
                return PARAMETER_BINDER;
            }
            case VARIABLE: {
                return VARIABLE_BINDER;
            }
        }
        return DEFAULT_BINDER;
    }

    private NameBinder() {
    }

    private NameBinder(NBinding.Kind kind) {
        this.kind = kind;
    }

    public final void bind(Scope s, NNode target, NType rvalue) throws Exception {
        if (target instanceof NName) {
            this.bindName(s, (NName)target, rvalue);
            return;
        }
        if (target instanceof NTuple) {
            this.bind(s, ((NTuple)target).elts, rvalue);
            return;
        }
        if (target instanceof NList) {
            this.bind(s, ((NList)target).elts, rvalue);
            return;
        }
        if (target instanceof NAttribute) {
            if (!s.isNameBindingPhase()) {
                NBinding nBinding;
                NType nType;
                NType nType2 = rvalue;
                Scope scope = s;
                NAttribute nAttribute = (NAttribute)target;
                nAttribute.setType(new NUnknownType());
                NType nType3 = nType = NAttribute.resolveExpr(nAttribute.target, scope);
                if (!(nType instanceof NUnionType && (nType = ((NUnionType)(nType3 = nType)).firstKnownNonNullAlternate()) == null || (nType = NUnknownType.follow(nType3 = nType)) == Indexer.idx.builtins.None || (nBinding = nType.getTable().putAttr(nAttribute.attr.id, nAttribute.attr, nType2, NBinding.Kind.ATTRIBUTE)) == null)) {
                    nAttribute.setType(nAttribute.attr.setType(nBinding.followType()));
                }
            }
            return;
        }
        if (target instanceof NSubscript) {
            if (!s.isNameBindingPhase()) {
                NNode.resolveExpr(target, s);
            }
            return;
        }
        Indexer.idx.putProblem(target, "invalid location for assignment");
    }

    public final void bind(Scope s, List<NNode> xs, NType rvalue) throws Exception {
        NType nType;
        while (true) {
            if ((nType = rvalue) instanceof NTupleType) {
                nType = rvalue;
                List<NType> vs = ((NTupleType)nType).getElementTypes();
                if (xs.size() != vs.size()) {
                    int n = vs.size();
                    List<NNode> list = xs;
                    int n2 = list.size();
                    int n3 = list.get(0).start();
                    int n4 = list.get(list.size() - 1).end();
                    int n5 = n2 - n;
                    String string = n5 > 0 ? "ValueError: need more than " + n + " values to unpack" : "ValueError: too many values to unpack";
                    Indexer.idx.putProblem(list.get(0).getFile(), n3, n4, string);
                    return;
                }
                for (int i = 0; i < xs.size(); ++i) {
                    this.bind(s, xs.get(i), vs.get(i));
                }
                return;
            }
            nType = rvalue;
            if (nType instanceof NListType) {
                nType = rvalue;
                rvalue = ((NListType)nType).toTupleType(xs.size());
                continue;
            }
            nType = rvalue;
            if (!(nType instanceof NDictType)) break;
            nType = rvalue;
            rvalue = ((NDictType)nType).toTupleType(xs.size());
        }
        nType = rvalue;
        if (!(nType instanceof NUnknownType)) {
            Indexer.idx.putProblem(xs.get(0).getFile(), xs.get(0).start(), xs.get(xs.size() - 1).end(), "unpacking non-iterable: " + rvalue);
        }
        for (int i = 0; i < xs.size(); ++i) {
            this.bind(s, xs.get(i), (NType)new NUnknownType());
        }
    }

    public final NBinding bindName(Scope s, NName name, NType rvalue) throws Exception {
        NType nameType;
        NBinding b;
        if (s.isGlobalName(name.id)) {
            b = s.getGlobalTable().put(name.id, name, rvalue, this.kindOr(NBinding.Kind.SCOPE));
            Indexer.idx.putLocation(name, b);
        } else {
            Scope bindingScope = s.getScopeSymtab();
            b = bindingScope.put(name.id, name, rvalue, this.kindOr(bindingScope.isFunctionScope() ? NBinding.Kind.VARIABLE : NBinding.Kind.SCOPE));
        }
        name.setType(b.followType());
        NType nType = nameType = name.getType();
        if (!(nameType instanceof NModuleType) && !((nType = nameType) instanceof NClassType)) {
            nameType.getTable().setPath(b.getQname());
        }
        return b;
    }

    public final void bindIter(Scope s, NNode target, NNode iter) throws Exception {
        NType iterType;
        NType nType = iterType = NNode.resolveExpr(iter, s);
        if (iterType instanceof NListType) {
            nType = iterType;
            this.bind(s, target, ((NListType)nType).getElementType());
            return;
        }
        nType = iterType;
        if (nType instanceof NTupleType) {
            nType = iterType;
            this.bind(s, target, ((NTupleType)nType).toListType().getElementType());
            return;
        }
        NBinding ent = iterType.getTable().lookupAttr("__iter__");
        if (ent == null || !((nType = ent.getType()) instanceof NFuncType)) {
            nType = iterType;
            if (!(nType instanceof NUnknownType)) {
                iter.addWarning("not an iterable type: " + iterType);
            }
            this.bind(s, target, (NType)new NUnknownType());
            return;
        }
        nType = ent.getType();
        this.bind(s, target, ((NFuncType)nType).getReturnType());
    }

    private NBinding.Kind kindOr(NBinding.Kind k) {
        if (this.kind != null) {
            return this.kind;
        }
        return k;
    }
}

