/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.jffi;

import com.kenai.jffi.Function;
import com.kenai.jffi.Platform;
import org.python.core.PyObject;
import org.python.modules.jffi.AsmClassBuilder;
import org.python.modules.jffi.CodegenUtils;
import org.python.modules.jffi.Invoker;
import org.python.modules.jffi.JITInvoker;
import org.python.modules.jffi.JITMethodGenerator;
import org.python.modules.jffi.JITRuntime;
import org.python.modules.jffi.JITSignature;
import org.python.modules.jffi.NativeDataConverter;
import org.python.modules.jffi.NativeType;
import org.python.modules.jffi.Pointer;
import org.python.modules.jffi.SkinnyMethodAdapter;
import org.python.objectweb.asm.Label;

abstract class AbstractNumericMethodGenerator
implements JITMethodGenerator {
    AbstractNumericMethodGenerator() {
    }

    @Override
    public void generate(AsmClassBuilder builder, String functionName, JITSignature signature) {
        SkinnyMethodAdapter mv = new SkinnyMethodAdapter(builder.getClassVisitor(), 17, functionName, CodegenUtils.sig(PyObject.class, CodegenUtils.params(PyObject.class, signature.getParameterCount())), null, null);
        mv.start();
        this.generate(builder, mv, signature);
        mv.visitMaxs(10, 10);
        mv.visitEnd();
    }

    public void generate(AsmClassBuilder builder, SkinnyMethodAdapter mv, JITSignature signature) {
        int i;
        Class nativeIntType = this.getInvokerIntType();
        int maxPointerIndex = -1;
        Label[] fallback = new Label[signature.getParameterCount()];
        for (int i2 = 0; i2 < signature.getParameterCount(); ++i2) {
            fallback[i2] = new Label();
        }
        mv.getstatic(CodegenUtils.p(JITInvoker.class), "jffiInvoker", CodegenUtils.ci(com.kenai.jffi.Invoker.class));
        mv.aload(0);
        mv.getfield(CodegenUtils.p(JITInvoker.class), "jffiFunction", CodegenUtils.ci(Function.class));
        for (i = 0; i < signature.getParameterCount(); ++i) {
            if (!signature.hasParameterConverter(i)) continue;
            mv.aload(0);
            mv.getfield(builder.getClassName(), AsmClassBuilder.getParameterConverterFieldName(i), CodegenUtils.ci(NativeDataConverter.class));
            mv.aload(i + 1);
            mv.invokevirtual(CodegenUtils.p(NativeDataConverter.class), "toNative", CodegenUtils.sig(PyObject.class, PyObject.class));
            mv.astore(i + 1);
        }
        block18: for (i = 0; i < signature.getParameterCount(); ++i) {
            NativeType parameterType = signature.getParameterType(i);
            int paramVar = i + 1;
            mv.aload(paramVar);
            switch (parameterType) {
                case BOOL: {
                    this.unbox(mv, "boolValue");
                    continue block18;
                }
                case BYTE: {
                    this.unbox(mv, "s8Value");
                    continue block18;
                }
                case UBYTE: {
                    this.unbox(mv, "u8Value");
                    continue block18;
                }
                case SHORT: {
                    this.unbox(mv, "s16Value");
                    continue block18;
                }
                case USHORT: {
                    this.unbox(mv, "u16Value");
                    continue block18;
                }
                case INT: {
                    this.unbox(mv, "s32Value");
                    continue block18;
                }
                case UINT: {
                    this.unbox(mv, "u32Value");
                    continue block18;
                }
                case LONG: {
                    if (Platform.getPlatform().longSize() == 32) {
                        this.unbox(mv, "s32Value");
                        continue block18;
                    }
                    this.unbox(mv, "s64Value");
                    continue block18;
                }
                case ULONG: {
                    if (Platform.getPlatform().longSize() == 32) {
                        this.unbox(mv, "u32Value");
                        continue block18;
                    }
                    this.unbox(mv, "u64Value");
                    continue block18;
                }
                case LONGLONG: {
                    this.unbox(mv, "s64Value");
                    continue block18;
                }
                case ULONGLONG: {
                    this.unbox(mv, "u64Value");
                    continue block18;
                }
                case POINTER: {
                    maxPointerIndex = i;
                    Label direct = new Label();
                    Label done = new Label();
                    Label converted = new Label();
                    mv.instance_of(CodegenUtils.p(Pointer.class));
                    mv.iftrue(direct);
                    mv.aload(paramVar);
                    mv.invokestatic(CodegenUtils.p(JITRuntime.class), "other2ptr", CodegenUtils.sig(PyObject.class, PyObject.class));
                    mv.label(converted);
                    mv.dup();
                    mv.astore(paramVar);
                    mv.instance_of(CodegenUtils.p(Pointer.class));
                    mv.iffalse(fallback[i]);
                    mv.label(direct);
                    mv.aload(paramVar);
                    this.unbox(mv, "pointerValue");
                    mv.label(done);
                    continue block18;
                }
                case FLOAT: {
                    this.unbox(mv, "f32Value");
                    continue block18;
                }
                case DOUBLE: {
                    this.unbox(mv, "f64Value");
                    continue block18;
                }
                default: {
                    throw new UnsupportedOperationException("unsupported parameter type " + (Object)((Object)parameterType));
                }
            }
        }
        mv.invokevirtual(CodegenUtils.p(com.kenai.jffi.Invoker.class), this.getInvokerMethodName(signature), this.getInvokerSignature(signature.getParameterCount()));
        this.boxResult(mv, signature.getResultType());
        this.emitResultConversion(mv, builder, signature);
        mv.areturn();
        if (maxPointerIndex >= 0) {
            for (i = maxPointerIndex; i > 0; --i) {
                mv.label(fallback[i]);
                if (Integer.TYPE == nativeIntType) {
                    mv.pop();
                    continue;
                }
                mv.pop2();
            }
            mv.label(fallback[0]);
            mv.pop();
            mv.pop();
            mv.aload(0);
            mv.getfield(CodegenUtils.p(JITInvoker.class), "fallbackInvoker", CodegenUtils.ci(Invoker.class));
            for (i = 0; i < signature.getParameterCount(); ++i) {
                mv.aload(i + 1);
            }
            mv.invokevirtual(CodegenUtils.p(Invoker.class), "invoke", CodegenUtils.sig(PyObject.class, CodegenUtils.params(PyObject.class, signature.getParameterCount())));
            this.emitResultConversion(mv, builder, signature);
            mv.areturn();
        }
    }

    private void emitResultConversion(SkinnyMethodAdapter mv, AsmClassBuilder builder, JITSignature signature) {
        if (signature.hasResultConverter()) {
            mv.aload(0);
            mv.getfield(builder.getClassName(), AsmClassBuilder.getResultConverterFieldName(), CodegenUtils.ci(NativeDataConverter.class));
            mv.swap();
            mv.invokevirtual(CodegenUtils.p(NativeDataConverter.class), "fromNative", CodegenUtils.sig(PyObject.class, PyObject.class));
        }
    }

    private void boxResult(SkinnyMethodAdapter mv, String boxMethodName) {
        mv.invokestatic(CodegenUtils.p(JITRuntime.class), boxMethodName, CodegenUtils.sig(PyObject.class, this.getInvokerIntType()));
    }

    private void boxResult(SkinnyMethodAdapter mv, NativeType type) {
        switch (type) {
            case BOOL: {
                this.boxResult(mv, "newBoolean");
                return;
            }
            case BYTE: {
                this.boxResult(mv, "newSigned8");
                return;
            }
            case UBYTE: {
                this.boxResult(mv, "newUnsigned8");
                return;
            }
            case SHORT: {
                this.boxResult(mv, "newSigned16");
                return;
            }
            case USHORT: {
                this.boxResult(mv, "newUnsigned16");
                return;
            }
            case INT: {
                this.boxResult(mv, "newSigned32");
                return;
            }
            case UINT: {
                this.boxResult(mv, "newUnsigned32");
                return;
            }
            case LONG: {
                if (Platform.getPlatform().longSize() == 32) {
                    this.boxResult(mv, "newSigned32");
                    return;
                }
                this.boxResult(mv, "newSigned64");
                return;
            }
            case ULONG: {
                if (Platform.getPlatform().longSize() == 32) {
                    this.boxResult(mv, "newUnsigned32");
                    return;
                }
                this.boxResult(mv, "newUnsigned64");
                return;
            }
            case LONGLONG: {
                this.boxResult(mv, "newSigned64");
                return;
            }
            case ULONGLONG: {
                this.boxResult(mv, "newUnsigned64");
                return;
            }
            case FLOAT: {
                this.boxResult(mv, "newFloat32");
                return;
            }
            case DOUBLE: {
                this.boxResult(mv, "newFloat64");
                return;
            }
            case VOID: {
                this.boxResult(mv, "newNone");
                return;
            }
            case POINTER: {
                this.boxResult(mv, "newPointer" + Platform.getPlatform().addressSize());
                return;
            }
            case STRING: {
                this.boxResult(mv, "newString");
                return;
            }
        }
        throw new UnsupportedOperationException("native return type not supported: " + (Object)((Object)type));
    }

    private void unbox(SkinnyMethodAdapter mv, String method) {
        mv.invokestatic(CodegenUtils.p(JITRuntime.class), this.getRuntimeMethod(method), CodegenUtils.sig(this.getInvokerIntType(), PyObject.class));
    }

    private String getRuntimeMethod(String method) {
        return method + (Integer.TYPE == this.getInvokerIntType() ? "32" : "64");
    }

    abstract String getInvokerMethodName(JITSignature var1);

    abstract String getInvokerSignature(int var1);

    abstract Class getInvokerIntType();

    public static boolean isPrimitiveInt(Class c) {
        return Byte.TYPE == c || Character.TYPE == c || Short.TYPE == c || Integer.TYPE == c || Boolean.TYPE == c;
    }

    public static final void widen(SkinnyMethodAdapter mv, Class from, Class to) {
        if (Long.TYPE == to && Long.TYPE != from && AbstractNumericMethodGenerator.isPrimitiveInt(from)) {
            mv.i2l();
        }
    }

    public static final void narrow(SkinnyMethodAdapter mv, Class from, Class to) {
        if (!from.equals(to) && AbstractNumericMethodGenerator.isPrimitiveInt(to)) {
            if (Long.TYPE == from) {
                mv.l2i();
            }
            if (Byte.TYPE == to) {
                mv.i2b();
                return;
            }
            if (Short.TYPE == to) {
                mv.i2s();
                return;
            }
            if (Character.TYPE == to) {
                mv.i2c();
                return;
            }
            if (Boolean.TYPE == to) {
                mv.iconst_1();
                mv.iand();
            }
        }
    }

    protected static String[] buildSignatures(Class nativeIntClass, int maxParameters) {
        char sigChar = Integer.TYPE == nativeIntClass ? (char)'I' : 'J';
        String[] signatures = new String[maxParameters + 1];
        for (int i = 0; i < signatures.length; ++i) {
            StringBuilder sb = new StringBuilder();
            sb.append('(').append(CodegenUtils.ci(Function.class));
            for (int n = 0; n < i; ++n) {
                sb.append(sigChar);
            }
            signatures[i] = sb.append(")").append(sigChar).toString();
        }
        return signatures;
    }
}

