/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.jffi;

import com.kenai.jffi.MemoryIO;
import com.kenai.jffi.Platform;
import org.python.modules.jffi.DirectMemory;
import org.python.modules.jffi.Memory;
import org.python.modules.jffi.NativeMemory;
import org.python.modules.jffi.Util;

class BoundedNativeMemory
implements DirectMemory,
Memory {
    protected static final MemoryIO IO = MemoryIO.getInstance();
    protected static final int LONG_SIZE = Platform.getPlatform().longSize();
    protected static final int ADDRESS_SIZE = Platform.getPlatform().addressSize();
    private long address;
    private long size;
    private BoundedNativeMemory parent;

    BoundedNativeMemory(long address, int size) {
        this.address = address;
        this.size = size;
    }

    private BoundedNativeMemory(BoundedNativeMemory parent, long offset) {
        this.address = parent.address + offset;
        this.size = parent.size - offset;
    }

    private final void checkBounds(long off, long len) {
        Util.checkBounds(this.size, off, len);
    }

    @Override
    public final long getAddress() {
        return this.address;
    }

    @Override
    public BoundedNativeMemory slice(long offset) {
        this.checkBounds(offset, 1L);
        if (offset == 0L) {
            return this;
        }
        return new BoundedNativeMemory(this, offset);
    }

    public final boolean equals(Object obj) {
        return obj instanceof DirectMemory && ((DirectMemory)obj).getAddress() == this.address;
    }

    public final int hashCode() {
        int hash = 265 + (int)(this.address ^ this.address >>> 32);
        return hash;
    }

    @Override
    public final boolean isNull() {
        return this.address == 0L;
    }

    @Override
    public final boolean isDirect() {
        return true;
    }

    @Override
    public final byte getByte(long offset) {
        this.checkBounds(offset, 1L);
        return IO.getByte(this.address + offset);
    }

    @Override
    public final short getShort(long offset) {
        this.checkBounds(offset, 2L);
        return IO.getShort(this.address + offset);
    }

    @Override
    public final int getInt(long offset) {
        this.checkBounds(offset, 4L);
        return IO.getInt(this.address + offset);
    }

    @Override
    public final long getLong(long offset) {
        this.checkBounds(offset, 8L);
        return IO.getLong(this.address + offset);
    }

    @Override
    public final long getNativeLong(long offset) {
        if (LONG_SIZE == 32) {
            return this.getInt(offset);
        }
        return this.getLong(offset);
    }

    @Override
    public final float getFloat(long offset) {
        this.checkBounds(offset, 4L);
        return IO.getFloat(this.address + offset);
    }

    @Override
    public final double getDouble(long offset) {
        this.checkBounds(offset, 8L);
        return IO.getDouble(this.address + offset);
    }

    @Override
    public final long getAddress(long offset) {
        this.checkBounds(offset, ADDRESS_SIZE >> 3);
        return IO.getAddress(this.address + offset);
    }

    @Override
    public final DirectMemory getMemory(long offset) {
        this.checkBounds(offset, ADDRESS_SIZE >> 3);
        long ptr = IO.getAddress(this.address + offset);
        if (ptr != 0L) {
            return new NativeMemory(ptr);
        }
        return null;
    }

    @Override
    public final byte[] getZeroTerminatedByteArray(long offset) {
        this.checkBounds(offset, 1L);
        return MemoryIO.getZeroTerminatedByteArray(this.address + offset, (int)(this.size - offset));
    }

    @Override
    public void putZeroTerminatedByteArray(long offset, byte[] bytes, int off, int len) {
        this.checkBounds(offset, len + 1);
        MemoryIO.putZeroTerminatedByteArray(this.address + offset, bytes, off, len);
    }

    @Override
    public final void putByte(long offset, byte value) {
        this.checkBounds(offset, 1L);
        IO.putByte(this.address + offset, value);
    }

    @Override
    public final void putShort(long offset, short value) {
        this.checkBounds(offset, 2L);
        IO.putShort(this.address + offset, value);
    }

    @Override
    public final void putInt(long offset, int value) {
        this.checkBounds(offset, 4L);
        IO.putInt(this.address + offset, value);
    }

    @Override
    public final void putLong(long offset, long value) {
        this.checkBounds(offset, 8L);
        IO.putLong(this.address + offset, value);
    }

    @Override
    public final void putNativeLong(long offset, long value) {
        if (LONG_SIZE == 32) {
            this.putInt(offset, (int)value);
            return;
        }
        this.putLong(offset, value);
    }

    @Override
    public final void putAddress(long offset, long value) {
        this.checkBounds(offset, ADDRESS_SIZE >> 3);
        IO.putAddress(this.address + offset, value);
    }

    @Override
    public final void putFloat(long offset, float value) {
        this.checkBounds(offset, 4L);
        IO.putFloat(this.address + offset, value);
    }

    @Override
    public final void putDouble(long offset, double value) {
        this.checkBounds(offset, 8L);
        IO.putDouble(this.address + offset, value);
    }

    @Override
    public final void putAddress(long offset, Memory value) {
        this.checkBounds(offset, ADDRESS_SIZE >> 3);
        IO.putAddress(this.address + offset, ((DirectMemory)value).getAddress());
    }

    @Override
    public final void get(long offset, byte[] dst, int off, int len) {
        this.checkBounds(offset, len);
        MemoryIO.getByteArray(this.address + offset, dst, off, len);
    }

    @Override
    public final void put(long offset, byte[] src, int off, int len) {
        this.checkBounds(offset, len);
        MemoryIO.putByteArray(this.address + offset, src, off, len);
    }

    @Override
    public final void get(long offset, short[] dst, int off, int len) {
        this.checkBounds(offset, len << 1);
        MemoryIO.getShortArray(this.address + offset, dst, off, len);
    }

    @Override
    public final void put(long offset, short[] src, int off, int len) {
        this.checkBounds(offset, len << 1);
        MemoryIO.putShortArray(this.address + offset, src, off, len);
    }

    @Override
    public final void get(long offset, int[] dst, int off, int len) {
        this.checkBounds(offset, len << 2);
        MemoryIO.getIntArray(this.address + offset, dst, off, len);
    }

    @Override
    public final void put(long offset, int[] src, int off, int len) {
        this.checkBounds(offset, len << 2);
        MemoryIO.putIntArray(this.address + offset, src, off, len);
    }

    @Override
    public final void get(long offset, long[] dst, int off, int len) {
        this.checkBounds(offset, len << 3);
        MemoryIO.getLongArray(this.address + offset, dst, off, len);
    }

    @Override
    public final void put(long offset, long[] src, int off, int len) {
        this.checkBounds(offset, len << 3);
        MemoryIO.putLongArray(this.address + offset, src, off, len);
    }

    @Override
    public final void get(long offset, float[] dst, int off, int len) {
        this.checkBounds(offset, len << 2);
        MemoryIO.getFloatArray(this.address + offset, dst, off, len);
    }

    @Override
    public final void put(long offset, float[] src, int off, int len) {
        this.checkBounds(offset, len << 2);
        MemoryIO.putFloatArray(this.address + offset, src, off, len);
    }

    @Override
    public final void get(long offset, double[] dst, int off, int len) {
        this.checkBounds(offset, len << 3);
        MemoryIO.getDoubleArray(this.address + offset, dst, off, len);
    }

    @Override
    public final void put(long offset, double[] src, int off, int len) {
        this.checkBounds(offset, len << 3);
        MemoryIO.putDoubleArray(this.address + offset, src, off, len);
    }

    @Override
    public final int indexOf(long offset, byte value) {
        if (value == 0) {
            return (int)MemoryIO.getStringLength(this.address + offset);
        }
        return (int)MemoryIO.indexOf(this.address + offset, value);
    }

    @Override
    public final int indexOf(long offset, byte value, int maxlen) {
        return (int)MemoryIO.indexOf(this.address, value, maxlen);
    }

    @Override
    public final void setMemory(long offset, long size, byte value) {
        this.checkBounds(offset, size);
        IO.setMemory(this.address + offset, size, value);
    }
}

