/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.tools.tcpproxy;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.grinder.common.GrinderBuild;
import net.grinder.common.Logger;
import net.grinder.common.UncheckedInterruptedException;
import net.grinder.tools.tcpproxy.AbstractFilterDecorator;
import net.grinder.tools.tcpproxy.AbstractTCPProxyEngine;
import net.grinder.tools.tcpproxy.ConnectionDetails;
import net.grinder.tools.tcpproxy.EndPoint;
import net.grinder.tools.tcpproxy.HTTPMethodAbsoluteURIFilterDecorator;
import net.grinder.tools.tcpproxy.HTTPMethodRelativeURIFilterDecorator;
import net.grinder.tools.tcpproxy.HTTPResponse;
import net.grinder.tools.tcpproxy.TCPProxyFilter;
import net.grinder.tools.tcpproxy.TCPProxySSLSocketFactory;
import net.grinder.tools.tcpproxy.TCPProxySocketFactory;
import net.grinder.tools.tcpproxy.TCPProxySocketFactoryImplementation;
import net.grinder.tools.tcpproxy.VerboseConnectException;
import net.grinder.util.StreamCopier;
import net.grinder.util.html.HTMLElement;
import net.grinder.util.thread.InterruptibleRunnable;

public final class HTTPProxyTCPProxyEngine
extends AbstractTCPProxyEngine {
    private static final long s_connectTimeout = Long.getLong("tcpproxy.connecttimeout", 5000L);
    private final Pattern m_httpConnectPattern;
    private final Pattern m_httpsConnectPattern;
    private final ProxySSLEngine m_proxySSLEngine;
    private final Thread m_proxySSLEngineThread;
    private final EndPoint m_chainedHTTPProxy;
    private final HTTPSProxySocketFactory m_httpsProxySocketFactory;
    private final EndPoint m_proxyAddress;

    public HTTPProxyTCPProxyEngine(TCPProxySSLSocketFactory sslSocketFactory, TCPProxyFilter requestFilter, TCPProxyFilter responseFilter, Logger logger, EndPoint localEndPoint, boolean useColour, int timeout, EndPoint chainedHTTPProxy, EndPoint chainedHTTPSProxy) throws IOException, PatternSyntaxException {
        super(new TCPProxySocketFactoryImplementation(), requestFilter, responseFilter, logger, localEndPoint, useColour, timeout);
        this.m_proxyAddress = localEndPoint;
        this.m_chainedHTTPProxy = chainedHTTPProxy;
        this.m_httpConnectPattern = Pattern.compile("^([A-Z]+)[ \\t]+http://([^/:]+):?(\\d*)/.*\r\n\r\n", 32);
        this.m_httpsConnectPattern = Pattern.compile("^CONNECT[ \\t]+([^:]+):(\\d+).*\r\n\r\n", 32);
        if (chainedHTTPSProxy != null) {
            this.m_httpsProxySocketFactory = new HTTPSProxySocketFactory(sslSocketFactory, chainedHTTPSProxy);
            this.m_proxySSLEngine = new ProxySSLEngine(this.m_httpsProxySocketFactory, this.getRequestFilter(), this.getResponseFilter(), logger, useColour);
        } else {
            this.m_httpsProxySocketFactory = null;
            this.m_proxySSLEngine = new ProxySSLEngine(sslSocketFactory, this.getRequestFilter(), this.getResponseFilter(), logger, useColour);
        }
        this.m_proxySSLEngineThread = new Thread((Runnable)this.m_proxySSLEngine, "HTTPS proxy SSL engine");
        this.m_proxySSLEngineThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        byte[] buffer = new byte[40960];
        block9: while (!this.isStopped()) {
            Socket localSocket;
            try {
                localSocket = this.accept();
            }
            catch (IOException e) {
                UncheckedInterruptedException.ioException(e);
                this.logIOException(e);
                continue;
            }
            try {
                BufferedInputStream in = new BufferedInputStream(localSocket.getInputStream(), buffer.length);
                in.mark(buffer.length);
                int time = 0;
                while (true) {
                    if ((long)time < s_connectTimeout && in.available() == 0) {
                        this.sleep(10);
                        time += 10;
                        continue;
                    }
                    boolean timeout = in.available() == 0;
                    in.reset();
                    int bytesRead = in.available() > 0 ? in.read(buffer) : 0;
                    String bufferAsString = new String(buffer, 0, bytesRead, "US-ASCII");
                    if (timeout) {
                        HTMLElement message = new HTMLElement();
                        message.addElement("p").addText("Failed to determine proxy destination.");
                        if (bufferAsString.length() > 0) {
                            HTMLElement paragraph1 = message.addElement("p");
                            paragraph1.addText("Do not type TCPProxy address into your browser. ");
                            paragraph1.addText("The browser proxy settings should be set to the TCPProxy address (");
                            paragraph1.addElement("code").addText(this.m_proxyAddress.toString());
                            paragraph1.addText("), and you should type the address of the target server into the browser.");
                            message.addElement("p").addText("Text of received message follows:");
                            message.addElement("p").addElement("pre").addElement("blockquote").addText(bufferAsString);
                        } else {
                            message.addElement("p").addText("Client opened connection but sent no bytes.");
                        }
                        this.sendHTTPErrorResponse(message, "400 Bad Request", localSocket.getOutputStream());
                        localSocket.close();
                        continue block9;
                    }
                    Matcher httpConnectMatcher = this.m_httpConnectPattern.matcher(bufferAsString);
                    Matcher httpsConnectMatcher = this.m_httpsConnectPattern.matcher(bufferAsString);
                    if (httpConnectMatcher.find()) {
                        in.reset();
                        new AbstractTCPProxyEngine.StreamThread(new HTTPProxyStreamDemultiplexer(in, localSocket, EndPoint.clientEndPoint(localSocket)), "HTTPProxyStreamDemultiplexer for " + localSocket, in).start();
                        continue block9;
                    }
                    if (httpsConnectMatcher.find()) {
                        Socket sslProxySocket;
                        EndPoint remoteEndPoint = new EndPoint(httpsConnectMatcher.group(1), Integer.parseInt(httpsConnectMatcher.group(2)));
                        if (this.m_httpsProxySocketFactory != null) {
                            ByteArrayOutputStream additionalRequestBytes = new ByteArrayOutputStream();
                            additionalRequestBytes.write(bufferAsString.substring(httpsConnectMatcher.end(2)).getBytes());
                            this.m_httpsProxySocketFactory.setAdditionalRequestBytes(additionalRequestBytes.toByteArray());
                        }
                        ProxySSLEngine proxySSLEngine = this.m_proxySSLEngine;
                        synchronized (proxySSLEngine) {
                            this.m_proxySSLEngine.setConnectionDetails(EndPoint.clientEndPoint(localSocket), remoteEndPoint);
                            sslProxySocket = this.getSocketFactory().createClientSocket(this.m_proxySSLEngine.getListenEndPoint());
                        }
                        new AbstractTCPProxyEngine.StreamThread(new StreamCopier(4096, true).getInterruptibleRunnable(in, sslProxySocket.getOutputStream()), "Copy to proxy engine for " + remoteEndPoint, in).start();
                        OutputStream out = localSocket.getOutputStream();
                        new AbstractTCPProxyEngine.StreamThread(new StreamCopier(4096, true).getInterruptibleRunnable(sslProxySocket.getInputStream(), out), "Copy from proxy engine for " + remoteEndPoint, sslProxySocket.getInputStream()).start();
                        if (this.m_httpsProxySocketFactory != null) {
                            out.write(this.m_httpsProxySocketFactory.getResponseBytes());
                            out.flush();
                            continue block9;
                        }
                        StringBuffer response = new StringBuffer();
                        response.append("HTTP/1.0 200 OK\r\n");
                        response.append("Proxy-agent: The Grinder/");
                        response.append(GrinderBuild.getVersionString());
                        response.append("\r\n");
                        response.append("\r\n");
                        out.write(response.toString().getBytes());
                        out.flush();
                        continue block9;
                    }
                    if (bytesRead == buffer.length) break;
                }
                while (in.available() > 0) {
                    in.read(buffer);
                }
                HTMLElement message = new HTMLElement();
                message.addElement("p").addText("Buffer overflow - failed to match HTTP message after " + buffer.length + " bytes");
                this.sendHTTPErrorResponse(message, "400 Bad Request", localSocket.getOutputStream());
            }
            catch (IOException e) {
                UncheckedInterruptedException.ioException(e);
                this.logIOException(e);
                try {
                    localSocket.close();
                }
                catch (IOException closeException) {
                    throw new AssertionError((Object)closeException);
                }
            }
        }
    }

    public void stop() {
        super.stop();
        this.m_proxySSLEngine.stop();
        try {
            this.m_proxySSLEngineThread.join();
        }
        catch (InterruptedException e) {
            throw new UncheckedInterruptedException(e);
        }
    }

    private void sendHTTPErrorResponse(HTMLElement message, String status, OutputStream outputStream) throws IOException {
        this.getLogger().error(message.toText());
        HTTPResponse response = new HTTPResponse();
        response.setStatus(status);
        response.setMessage(status, message);
        outputStream.write(response.toString().getBytes("US-ASCII"));
    }

    private void sleep(int milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException e) {
            throw new UncheckedInterruptedException(e);
        }
    }

    private final class HTTPSProxySocketFactory
    implements TCPProxySocketFactory {
        private final TCPProxySSLSocketFactory m_delegate;
        private final EndPoint m_httpsProxy;
        private byte[] m_additionalRequestBytes;
        private byte[] m_responseBytes;

        public HTTPSProxySocketFactory(TCPProxySSLSocketFactory delegate, EndPoint chainedHTTPSProxy) {
            this.m_delegate = delegate;
            this.m_httpsProxy = chainedHTTPSProxy;
        }

        public ServerSocket createServerSocket(EndPoint localEndPoint, int timeout) throws IOException {
            return this.m_delegate.createServerSocket(localEndPoint, timeout);
        }

        public void setAdditionalRequestBytes(byte[] additionalRequestBytes) {
            this.m_additionalRequestBytes = additionalRequestBytes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] getResponseBytes() throws IOException {
            HTTPSProxySocketFactory hTTPSProxySocketFactory = this;
            synchronized (hTTPSProxySocketFactory) {
                byte[] byArray;
                try {
                    while (this.m_responseBytes == null) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            throw new UncheckedInterruptedException(e);
                        }
                    }
                    byArray = this.m_responseBytes;
                    this.m_responseBytes = null;
                }
                catch (Throwable throwable) {
                    this.m_responseBytes = null;
                    throw throwable;
                }
                return byArray;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Socket createClientSocket(EndPoint remoteEndPoint) throws IOException {
            Socket socket;
            try {
                socket = new Socket(this.m_httpsProxy.getHost(), this.m_httpsProxy.getPort());
            }
            catch (ConnectException e) {
                HTTPSProxySocketFactory hTTPSProxySocketFactory = this;
                synchronized (hTTPSProxySocketFactory) {
                    this.m_responseBytes = new byte[0];
                    this.notifyAll();
                }
                throw new VerboseConnectException(e, "HTTPS proxy " + this.m_httpsProxy);
            }
            BufferedOutputStream outputStream = new BufferedOutputStream(socket.getOutputStream());
            InputStream inputStream = socket.getInputStream();
            ((OutputStream)outputStream).write(("CONNECT " + remoteEndPoint).getBytes());
            ((OutputStream)outputStream).write(this.m_additionalRequestBytes);
            ((OutputStream)outputStream).flush();
            byte[] buffer = new byte[1024];
            int i = 0;
            while ((long)i < s_connectTimeout && inputStream.available() == 0) {
                HTTPProxyTCPProxyEngine.this.sleep(10);
                i += 10;
            }
            if (inputStream.available() == 0) {
                throw new IOException("HTTPS proxy " + this.m_httpsProxy + " failed to respond after " + s_connectTimeout + " ms");
            }
            ByteArrayOutputStream responseBytes = new ByteArrayOutputStream();
            while (inputStream.available() > 0) {
                int n = inputStream.read(buffer);
                if (n <= 0) continue;
                responseBytes.write(buffer, 0, n);
            }
            HTTPSProxySocketFactory hTTPSProxySocketFactory = this;
            synchronized (hTTPSProxySocketFactory) {
                this.m_responseBytes = responseBytes.toByteArray();
                this.notifyAll();
            }
            return this.m_delegate.createClientSocket(socket, remoteEndPoint);
        }
    }

    private static final class ProxySSLEngine
    extends AbstractTCPProxyEngine {
        private EndPoint m_clientEndPoint;
        private EndPoint m_remoteEndPoint;

        ProxySSLEngine(TCPProxySocketFactory socketFactory, TCPProxyFilter requestFilter, TCPProxyFilter responseFilter, Logger logger, boolean useColour) throws IOException {
            super(socketFactory, requestFilter, responseFilter, logger, new EndPoint(InetAddress.getByName(null), 0), useColour, 0);
        }

        public void run() {
            while (true) {
                Socket localSocket;
                try {
                    localSocket = this.accept();
                }
                catch (IOException e) {
                    UncheckedInterruptedException.ioException(e);
                    if (this.isStopped()) break;
                    this.logIOException(e);
                    continue;
                }
                try {
                    this.launchThreadPair(localSocket, this.m_remoteEndPoint, this.m_clientEndPoint, true);
                }
                catch (IOException e) {
                    UncheckedInterruptedException.ioException(e);
                    if (this.isStopped()) break;
                    this.logIOException(e);
                    try {
                        localSocket.close();
                    }
                    catch (IOException closeException) {
                        throw new AssertionError((Object)closeException);
                    }
                }
            }
        }

        public void setConnectionDetails(EndPoint clientEndPoint, EndPoint remoteEndPoint) {
            this.m_clientEndPoint = clientEndPoint;
            this.m_remoteEndPoint = remoteEndPoint;
        }
    }

    private final class HTTPProxyStreamDemultiplexer
    implements InterruptibleRunnable {
        private final InputStream m_in;
        private final Socket m_localSocket;
        private final EndPoint m_clientEndPoint;
        private final Map m_remoteStreamMap = new HashMap();
        private AbstractTCPProxyEngine.OutputStreamFilterTee m_lastRemoteStream;

        HTTPProxyStreamDemultiplexer(InputStream in, Socket localSocket, EndPoint clientEndPoint) {
            this.m_in = in;
            this.m_localSocket = localSocket;
            this.m_clientEndPoint = clientEndPoint;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void interruptibleRun() {
            block22: {
                int bytesRead;
                byte[] buffer = new byte[40960];
                while ((bytesRead = this.m_in.read(buffer)) != -1) {
                    String bytesReadAsString = new String(buffer, 0, bytesRead, "US-ASCII");
                    Matcher matcher = HTTPProxyTCPProxyEngine.this.m_httpConnectPattern.matcher(bytesReadAsString);
                    if (matcher.find()) {
                        String remoteHost = matcher.group(2);
                        int remotePort = 80;
                        try {
                            remotePort = Integer.parseInt(matcher.group(3));
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                        EndPoint remoteEndPoint = new EndPoint(remoteHost, remotePort);
                        String key = remoteEndPoint.toString();
                        this.m_lastRemoteStream = (AbstractTCPProxyEngine.OutputStreamFilterTee)this.m_remoteStreamMap.get(key);
                        if (this.m_lastRemoteStream == null) {
                            AbstractFilterDecorator requestFilter;
                            Socket remoteSocket;
                            if (HTTPProxyTCPProxyEngine.this.m_chainedHTTPProxy != null) {
                                remoteSocket = HTTPProxyTCPProxyEngine.this.getSocketFactory().createClientSocket(HTTPProxyTCPProxyEngine.this.m_chainedHTTPProxy);
                                requestFilter = new HTTPMethodAbsoluteURIFilterDecorator(new HTTPMethodRelativeURIFilterDecorator(HTTPProxyTCPProxyEngine.this.getRequestFilter()), remoteEndPoint);
                            } else {
                                remoteSocket = HTTPProxyTCPProxyEngine.this.getSocketFactory().createClientSocket(remoteEndPoint);
                                requestFilter = new HTTPMethodRelativeURIFilterDecorator(HTTPProxyTCPProxyEngine.this.getRequestFilter());
                            }
                            ConnectionDetails connectionDetails = new ConnectionDetails(this.m_clientEndPoint, remoteEndPoint, false);
                            this.m_lastRemoteStream = new AbstractTCPProxyEngine.OutputStreamFilterTee(connectionDetails, remoteSocket.getOutputStream(), requestFilter, HTTPProxyTCPProxyEngine.this.getRequestColour());
                            this.m_lastRemoteStream.connectionOpened();
                            this.m_remoteStreamMap.put(key, this.m_lastRemoteStream);
                            new AbstractTCPProxyEngine.FilteredStreamThread(remoteSocket.getInputStream(), new AbstractTCPProxyEngine.OutputStreamFilterTee(connectionDetails.getOtherEnd(), this.m_localSocket.getOutputStream(), HTTPProxyTCPProxyEngine.this.getResponseFilter(), HTTPProxyTCPProxyEngine.this.getResponseColour()));
                        }
                    } else if (this.m_lastRemoteStream == null) {
                        throw new AssertionError((Object)"No last stream");
                    }
                    this.m_lastRemoteStream.handle(buffer, bytesRead);
                }
                Object var13_17 = null;
                Iterator iterator = this.m_remoteStreamMap.values().iterator();
                while (iterator.hasNext()) {
                    ((AbstractTCPProxyEngine.OutputStreamFilterTee)iterator.next()).connectionClosed();
                }
                try {
                    this.m_localSocket.close();
                }
                catch (IOException e2) {
                    UncheckedInterruptedException.ioException(e2);
                }
                break block22;
                {
                    catch (IOException e) {
                        UncheckedInterruptedException.ioException(e);
                        String description = HTTPProxyTCPProxyEngine.this.logIOException(e);
                        HTMLElement message = new HTMLElement();
                        message.addElement("p").addText(description);
                        try {
                            HTTPProxyTCPProxyEngine.this.sendHTTPErrorResponse(message, "502 Bad Gateway", this.m_localSocket.getOutputStream());
                        }
                        catch (IOException e2) {
                            UncheckedInterruptedException.ioException(e2);
                        }
                        Object var13_18 = null;
                        iterator = this.m_remoteStreamMap.values().iterator();
                        while (iterator.hasNext()) {
                            ((AbstractTCPProxyEngine.OutputStreamFilterTee)iterator.next()).connectionClosed();
                        }
                        try {
                            this.m_localSocket.close();
                        }
                        catch (IOException e2) {
                            UncheckedInterruptedException.ioException(e2);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var13_19 = null;
                    iterator = this.m_remoteStreamMap.values().iterator();
                    while (iterator.hasNext()) {
                        ((AbstractTCPProxyEngine.OutputStreamFilterTee)iterator.next()).connectionClosed();
                    }
                    try {
                        this.m_localSocket.close();
                    }
                    catch (IOException e2) {
                        UncheckedInterruptedException.ioException(e2);
                    }
                    throw throwable;
                }
            }
        }
    }
}

