/*
 * Decompiled with CFR 0.152.
 */
package jnr.posix;

import java.io.FileDescriptor;
import java.io.IOException;
import java.util.Collection;
import jnr.constants.platform.Sysconf;
import jnr.posix.FileStat;
import jnr.posix.Group;
import jnr.posix.LibC;
import jnr.posix.POSIX;
import jnr.posix.POSIXFactory;
import jnr.posix.POSIXHandler;
import jnr.posix.Passwd;
import jnr.posix.SpawnFileAction;
import jnr.posix.Times;
import jnr.posix.util.ProcessMaker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LazyPOSIX
implements POSIX {
    private final POSIXHandler handler;
    private final boolean useNativePosix;
    private volatile POSIX posix;

    LazyPOSIX(POSIXHandler handler, boolean useNativePosix) {
        this.handler = handler;
        this.useNativePosix = useNativePosix;
    }

    private final POSIX posix() {
        if (this.posix != null) {
            return this.posix;
        }
        return this.loadPOSIX();
    }

    private final synchronized POSIX loadPOSIX() {
        if (this.posix != null) {
            return this.posix;
        }
        this.posix = POSIXFactory.loadPOSIX(this.handler, this.useNativePosix);
        return this.posix;
    }

    @Override
    public final ProcessMaker newProcessMaker(String ... command) {
        return this.posix().newProcessMaker(command);
    }

    @Override
    public final ProcessMaker newProcessMaker() {
        return this.posix().newProcessMaker();
    }

    @Override
    public final FileStat allocateStat() {
        return this.posix().allocateStat();
    }

    @Override
    public final int chmod(String filename, int mode) {
        return this.posix().chmod(filename, mode);
    }

    @Override
    public final int chown(String filename, int user, int group) {
        return this.posix().chown(filename, user, group);
    }

    @Override
    public final int endgrent() {
        return this.posix().endgrent();
    }

    @Override
    public final int endpwent() {
        return this.posix().endpwent();
    }

    @Override
    public final int errno() {
        return this.posix().errno();
    }

    @Override
    public final void errno(int value) {
        this.posix().errno(value);
    }

    @Override
    public final int exec(String path, String ... args) {
        return this.posix().exec(path, args);
    }

    @Override
    public final int exec(String path, String[] args, String[] envp) {
        return this.posix().exec(path, args, envp);
    }

    @Override
    public final int execv(String path, String[] argv) {
        return this.posix().execv(path, argv);
    }

    @Override
    public final int execve(String path, String[] argv, String[] envp) {
        return this.posix().execve(path, argv, envp);
    }

    @Override
    public final int fork() {
        return this.posix().fork();
    }

    @Override
    public final FileStat fstat(int fd) {
        return this.posix().fstat(fd);
    }

    @Override
    public final int fstat(int fd, FileStat stat) {
        return this.posix().fstat(fd, stat);
    }

    @Override
    public final FileStat fstat(FileDescriptor descriptor) {
        return this.posix().fstat(descriptor);
    }

    @Override
    public final int fstat(FileDescriptor descriptor, FileStat stat) {
        return this.posix().fstat(descriptor, stat);
    }

    @Override
    public final int getegid() {
        return this.posix().getegid();
    }

    @Override
    public final int geteuid() {
        return this.posix().geteuid();
    }

    @Override
    public final int getgid() {
        return this.posix().getgid();
    }

    @Override
    public final Group getgrent() {
        return this.posix().getgrent();
    }

    @Override
    public final Group getgrgid(int which) {
        return this.posix().getgrgid(which);
    }

    @Override
    public final Group getgrnam(String which) {
        return this.posix().getgrnam(which);
    }

    @Override
    public final String getlogin() {
        return this.posix().getlogin();
    }

    @Override
    public final int getpgid() {
        return this.posix().getpgid();
    }

    @Override
    public final int getpgid(int pid) {
        return this.posix().getpgid(pid);
    }

    @Override
    public final int getpgrp() {
        return this.posix().getpgrp();
    }

    @Override
    public final int getpid() {
        return this.posix().getpid();
    }

    @Override
    public final int getppid() {
        return this.posix().getppid();
    }

    @Override
    public final int getpriority(int which, int who) {
        return this.posix().getpriority(which, who);
    }

    @Override
    public final Passwd getpwent() {
        return this.posix().getpwent();
    }

    @Override
    public final Passwd getpwnam(String which) {
        return this.posix().getpwnam(which);
    }

    @Override
    public final Passwd getpwuid(int which) {
        return this.posix().getpwuid(which);
    }

    @Override
    public final int getuid() {
        return this.posix().getuid();
    }

    @Override
    public final boolean isatty(FileDescriptor descriptor) {
        return this.posix().isatty(descriptor);
    }

    @Override
    public final int kill(int pid, int signal) {
        return this.posix().kill(pid, signal);
    }

    @Override
    public final int lchmod(String filename, int mode) {
        return this.posix().lchmod(filename, mode);
    }

    @Override
    public final int lchown(String filename, int user, int group) {
        return this.posix().lchown(filename, user, group);
    }

    @Override
    public final int link(String oldpath, String newpath) {
        return this.posix().link(oldpath, newpath);
    }

    @Override
    public final FileStat lstat(String path) {
        return this.posix().lstat(path);
    }

    @Override
    public final int lstat(String path, FileStat stat) {
        return this.posix().lstat(path, stat);
    }

    @Override
    public final int mkdir(String path, int mode) {
        return this.posix().mkdir(path, mode);
    }

    @Override
    public final String readlink(String path) throws IOException {
        return this.posix().readlink(path);
    }

    @Override
    public final int rmdir(String path) {
        return this.posix().rmdir(path);
    }

    @Override
    public final int setegid(int egid) {
        return this.posix().setegid(egid);
    }

    @Override
    public final int seteuid(int euid) {
        return this.posix().seteuid(euid);
    }

    @Override
    public final int setgid(int gid) {
        return this.posix().setgid(gid);
    }

    @Override
    public final int setgrent() {
        return this.posix().setgrent();
    }

    @Override
    public final int setpgid(int pid, int pgid) {
        return this.posix().setpgid(pid, pgid);
    }

    @Override
    public final int setpgrp(int pid, int pgrp) {
        return this.posix().setpgrp(pid, pgrp);
    }

    @Override
    public final int setpriority(int which, int who, int prio) {
        return this.posix().setpriority(which, who, prio);
    }

    @Override
    public final int setpwent() {
        return this.posix().setpwent();
    }

    @Override
    public final int setsid() {
        return this.posix().setsid();
    }

    @Override
    public final int setuid(int uid) {
        return this.posix().setuid(uid);
    }

    @Override
    public final FileStat stat(String path) {
        return this.posix().stat(path);
    }

    @Override
    public final int stat(String path, FileStat stat) {
        return this.posix().stat(path, stat);
    }

    @Override
    public final int symlink(String oldpath, String newpath) {
        return this.posix().symlink(oldpath, newpath);
    }

    @Override
    public final int umask(int mask) {
        return this.posix().umask(mask);
    }

    @Override
    public final int utimes(String path, long[] atimeval, long[] mtimeval) {
        return this.posix().utimes(path, atimeval, mtimeval);
    }

    @Override
    public final int wait(int[] status) {
        return this.posix().wait(status);
    }

    @Override
    public final int waitpid(int pid, int[] status, int flags) {
        return this.posix().waitpid(pid, status, flags);
    }

    @Override
    public final boolean isNative() {
        return this.posix().isNative();
    }

    @Override
    public final LibC libc() {
        return this.posix().libc();
    }

    @Override
    public final String getenv(String envName) {
        return this.posix().getenv(envName);
    }

    @Override
    public final int setenv(String envName, String envValue, int overwrite) {
        return this.posix().setenv(envName, envValue, overwrite);
    }

    @Override
    public final int unsetenv(String envName) {
        return this.posix().unsetenv(envName);
    }

    @Override
    public final long posix_spawnp(String path, Collection<? extends SpawnFileAction> fileActions, Collection<? extends CharSequence> argv, Collection<? extends CharSequence> envp) {
        return this.posix().posix_spawnp(path, fileActions, argv, envp);
    }

    @Override
    public final long sysconf(Sysconf name) {
        return this.posix().sysconf(name);
    }

    @Override
    public final Times times() {
        return this.posix().times();
    }
}

