/*
 * Decompiled with CFR 0.152.
 */
package org.python.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.EnumSet;
import org.python.core.BytecodeLoader;
import org.python.core.Py;
import org.python.core.PyCode;
import org.python.core.PyList;
import org.python.core.PyModule;
import org.python.core.PyObject;
import org.python.core.PyType;
import org.python.core.imp;

public abstract class importer<T>
extends PyObject {
    private SearchOrderEntry[] searchOrder = this.makeSearchOrder();

    public importer(PyType subType) {
        super(subType);
    }

    public importer() {
    }

    protected abstract String getSeparator();

    protected abstract String makePackagePath(String var1);

    protected abstract String makeFilename(String var1);

    protected abstract String makeFilePath(String var1);

    protected abstract T makeEntry(String var1);

    protected abstract Bundle makeBundle(String var1, T var2);

    private SearchOrderEntry[] makeSearchOrder() {
        return new SearchOrderEntry[]{new SearchOrderEntry(this.getSeparator() + "__init__$py.class", EnumSet.of(EntryType.IS_PACKAGE, EntryType.IS_BYTECODE)), new SearchOrderEntry(this.getSeparator() + "__init__.py", EnumSet.of(EntryType.IS_PACKAGE, EntryType.IS_SOURCE)), new SearchOrderEntry("$py.class", EnumSet.of(EntryType.IS_BYTECODE)), new SearchOrderEntry(".py", EnumSet.of(EntryType.IS_SOURCE))};
    }

    protected final PyObject importer_find_module(String fullname, String path) {
        ModuleInfo moduleInfo = this.getModuleInfo(fullname);
        if (moduleInfo == ModuleInfo.ERROR || moduleInfo == ModuleInfo.NOT_FOUND) {
            return Py.None;
        }
        return this;
    }

    protected final PyObject importer_load_module(String fullname) {
        ModuleCodeData moduleCodeData = this.getModuleCode(fullname);
        if (moduleCodeData == null) {
            return Py.None;
        }
        PyModule mod2 = imp.addModule(fullname);
        mod2.__dict__.__setitem__("__loader__", (PyObject)this);
        if (moduleCodeData.isPackage) {
            PyList pkgpath = new PyList();
            pkgpath.add(this.makePackagePath(fullname));
            mod2.__dict__.__setitem__("__path__", (PyObject)pkgpath);
        }
        imp.createFromCode(fullname, moduleCodeData.code, moduleCodeData.path);
        Py.writeDebug("import", "import " + fullname + " # loaded from " + moduleCodeData.path);
        return mod2;
    }

    protected abstract long getSourceMtime(String var1);

    protected final ModuleInfo getModuleInfo(String fullname) {
        String path = this.makeFilename(fullname);
        SearchOrderEntry[] arr$ = this.searchOrder;
        int len$ = this.searchOrder.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            SearchOrderEntry entry = arr$[i$];
            T importEntry = this.makeEntry(path + entry.suffix);
            if (importEntry == null) continue;
            if (entry.type.contains((Object)EntryType.IS_PACKAGE)) {
                return ModuleInfo.PACKAGE;
            }
            return ModuleInfo.MODULE;
        }
        return ModuleInfo.NOT_FOUND;
    }

    protected final ModuleCodeData getModuleCode(String fullname) {
        String path = this.makeFilename(fullname);
        String fullPath = this.makeFilePath(fullname);
        if (path.length() < 0) {
            return null;
        }
        SearchOrderEntry[] arr$ = this.searchOrder;
        int len$ = this.searchOrder.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            byte[] codeBytes;
            boolean isPackage;
            String fullSearchPath;
            block11: {
                SearchOrderEntry entry = arr$[i$];
                String suffix = entry.suffix;
                String searchPath = path + suffix;
                fullSearchPath = fullPath + suffix;
                Py.writeDebug("import", "# trying " + searchPath);
                T tocEntry = this.makeEntry(searchPath);
                if (tocEntry == null) continue;
                isPackage = entry.type.contains((Object)EntryType.IS_PACKAGE);
                boolean isBytecode = entry.type.contains((Object)EntryType.IS_BYTECODE);
                long mtime = -1L;
                if (isBytecode) {
                    mtime = this.getSourceMtime(searchPath);
                }
                try (Bundle bundle = this.makeBundle(searchPath, tocEntry);){
                    if (isBytecode) {
                        try {
                            codeBytes = imp.readCode(fullname, bundle.inputStream, true, mtime);
                        }
                        catch (IOException ioe) {
                            throw Py.ImportError(ioe.getMessage() + "[path=" + fullSearchPath + "]");
                        }
                        if (codeBytes == null) {
                            continue;
                        }
                        break block11;
                    }
                    codeBytes = imp.compileSource(fullname, bundle.inputStream, fullSearchPath);
                }
            }
            PyCode code = BytecodeLoader.makeCode(fullname + "$py", codeBytes, fullSearchPath);
            return new ModuleCodeData(this, code, isPackage, fullSearchPath);
        }
        return null;
    }

    public static class SearchOrderEntry {
        public String suffix;
        public EnumSet<EntryType> type;

        public SearchOrderEntry(String suffix, EnumSet<EntryType> type) {
            this.suffix = suffix;
            this.type = type;
        }
    }

    public class ModuleCodeData {
        public PyCode code;
        public boolean isPackage;
        public String path;
        private /* synthetic */ importer this$0;

        public ModuleCodeData(importer importer2, PyCode code, boolean isPackage, String path) {
            this.code = code;
            this.isPackage = isPackage;
            this.path = path;
        }
    }

    public static abstract class Bundle {
        public InputStream inputStream;

        public Bundle(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        public abstract void close();
    }

    public static enum ModuleInfo {
        ERROR,
        NOT_FOUND,
        MODULE,
        PACKAGE;

    }

    static enum EntryType {
        IS_SOURCE,
        IS_BYTECODE,
        IS_PACKAGE;

    }
}

