/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.types;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.python.indexer.Scope;

public abstract class NType {
    private Scope table;
    private static Pattern INSTANCE_TAG = Pattern.compile("(.+?)=#([0-9]+)");

    public final void setTable(Scope table) {
        this.table = table;
    }

    public final Scope getTable() {
        if (this.table == null) {
            this.table = new Scope(null, Scope.Type.SCOPE);
        }
        return this.table;
    }

    public String toString() {
        StringBuilder input = new StringBuilder();
        this.print(new CyclicTypeRecorder(this), input);
        StringBuilder sb = new StringBuilder(input.length());
        Matcher m = INSTANCE_TAG.matcher(input.toString());
        int end = -1;
        while (m.find()) {
            end = m.end();
            int num = Integer.parseInt(m.group(2));
            if (input.indexOf("<#" + num + ">") == -1) {
                sb.append(m.group(1));
                continue;
            }
            sb.append(m.group());
        }
        if (end != -1) {
            sb.append(input.substring(end));
        }
        return sb.toString();
    }

    protected final void print(CyclicTypeRecorder ctr, StringBuilder sb) {
        int num = ctr.fetch(this);
        if (num > 0) {
            sb.append("<#").append(num).append(">");
            return;
        }
        String tag = this.getClass().getName();
        tag = tag.substring(tag.lastIndexOf(".") + 2);
        sb.append("<").append(tag).append("=#").append(-num).append(":");
        this.printKids(ctr, sb);
        sb.append(">");
    }

    protected abstract void printKids(CyclicTypeRecorder var1, StringBuilder var2);

    public final class CyclicTypeRecorder {
        private int count = 0;
        private Map<NType, Integer> elements = new HashMap<NType, Integer>();

        protected CyclicTypeRecorder(NType nType) {
        }

        public final int fetch(NType t) {
            Integer i = this.elements.get(t);
            if (i != null) {
                return i;
            }
            i = ++this.count;
            this.elements.put(t, i);
            return -i.intValue();
        }
    }
}

