/*
 * Decompiled with CFR 0.152.
 */
package org.python;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Properties;
import java.util.Set;
import org.python.core.CodeFlag;

public class Version {
    public static String PY_VERSION;
    public static int PY_MAJOR_VERSION;
    public static int PY_MINOR_VERSION;
    public static int PY_MICRO_VERSION;
    public static int PY_RELEASE_LEVEL;
    public static int PY_RELEASE_SERIAL;
    private static String DATE;
    private static String TIME;
    private static String HG_BRANCH;
    private static String HG_TAG;
    private static String HG_VERSION;
    private static final Collection<CodeFlag> defaultCodeFlags;

    public static String getHGVersion() {
        return HG_VERSION;
    }

    public static String getHGIdentifier() {
        if ("".equals(HG_TAG) || "tip".equals(HG_TAG)) {
            return HG_BRANCH;
        }
        return HG_TAG;
    }

    public static String getVersion() {
        Object[] objectArray = new Object[3];
        objectArray[0] = PY_VERSION;
        String string = HG_VERSION;
        String string2 = "".equals(string) ? "" : ":";
        String string3 = Version.getHGIdentifier();
        objectArray[1] = String.format("%s%s%s, %.20s, %.9s", string3, string2, string, DATE, TIME);
        objectArray[2] = String.format("\n[%s (%s)]", System.getProperty("java.vm.name"), System.getProperty("java.vm.vendor"));
        return String.format("%.80s (%.80s) %.80s", objectArray);
    }

    public static Set<CodeFlag> getDefaultCodeFlags() {
        return EnumSet.copyOf(defaultCodeFlags);
    }

    /*
     * Loose catch block
     */
    static {
        boolean bl;
        block12: {
            defaultCodeFlags = Arrays.asList(CodeFlag.CO_NESTED, CodeFlag.CO_GENERATOR_ALLOWED, CodeFlag.CO_FUTURE_WITH_STATEMENT);
            bl = false;
            InputStream inputStream = Version.class.getResourceAsStream("/org/python/version.properties");
            if (inputStream != null) {
                Properties properties = new Properties();
                properties.load(inputStream);
                bl = true;
                PY_VERSION = properties.getProperty("jython.version");
                PY_MAJOR_VERSION = Integer.valueOf(properties.getProperty("jython.major_version"));
                PY_MINOR_VERSION = Integer.valueOf(properties.getProperty("jython.minor_version"));
                PY_MICRO_VERSION = Integer.valueOf(properties.getProperty("jython.micro_version"));
                PY_RELEASE_LEVEL = Integer.valueOf(properties.getProperty("jython.release_level"));
                PY_RELEASE_SERIAL = Integer.valueOf(properties.getProperty("jython.release_serial"));
                DATE = properties.getProperty("jython.build.date");
                TIME = properties.getProperty("jython.build.time");
                HG_BRANCH = properties.getProperty("jython.build.hg_branch");
                HG_TAG = properties.getProperty("jython.build.hg_tag");
                HG_VERSION = properties.getProperty("jython.build.hg_version");
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
                break block12;
                catch (IOException iOException) {
                    try {
                        System.err.println("There was a problem loading ".concat("/org/python/version.properties").concat(":"));
                        iOException.printStackTrace();
                    }
                    catch (Throwable throwable) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException2) {}
                        throw throwable;
                    }
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException3) {}
                }
            }
        }
        if (!bl) {
            throw new RuntimeException("unable to load ".concat("/org/python/version.properties"));
        }
    }
}

