/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.communication;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import net.grinder.common.UncheckedInterruptedException;
import net.grinder.communication.CommunicationException;
import net.grinder.communication.ConnectionIdentity;
import net.grinder.communication.ConnectionType;
import net.grinder.communication.Connector;
import net.grinder.communication.ResourcePool;
import net.grinder.communication.ResourcePoolImplementation;
import net.grinder.communication.SocketWrapper;
import net.grinder.util.ListenerSupport;
import net.grinder.util.thread.InterruptibleRunnable;
import net.grinder.util.thread.ThreadPool;
import net.grinder.util.thread.ThreadSafeQueue;

public final class Acceptor {
    private final ServerSocket m_serverSocket;
    private final ThreadPool m_threadPool;
    private final ThreadSafeQueue m_exceptionQueue = new ThreadSafeQueue();
    private final Map m_socketSets = new HashMap();
    private final Map m_listenerMap = new HashMap();
    private boolean m_isShutdown = false;

    public Acceptor(String addressString, int port, int numberOfThreads) throws CommunicationException {
        if (addressString.length() > 0) {
            try {
                this.m_serverSocket = new ServerSocket(port, 50, InetAddress.getByName(addressString));
            }
            catch (IOException e) {
                UncheckedInterruptedException.ioException(e);
                throw new CommunicationException("Could not bind to address '" + addressString + ':' + port + '\'', e);
            }
        }
        try {
            this.m_serverSocket = new ServerSocket(port, 50);
        }
        catch (IOException e) {
            UncheckedInterruptedException.ioException(e);
            throw new CommunicationException("Could not bind to port '" + port + "' on local interfaces", e);
        }
        ThreadPool.InterruptibleRunnableFactory runnableFactory = new ThreadPool.InterruptibleRunnableFactory(){

            public InterruptibleRunnable create() {
                return new AcceptorRunnable();
            }
        };
        this.m_threadPool = new ThreadPool("Acceptor", numberOfThreads, runnableFactory);
        this.m_threadPool.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void shutdown() throws CommunicationException {
        ResourcePool[] socketSets2222;
        Map map = this.m_socketSets;
        synchronized (map) {
            if (this.m_isShutdown) {
                return;
            }
            this.m_isShutdown = true;
        }
        try {
            try {
                this.m_serverSocket.close();
            }
            catch (IOException e) {
                UncheckedInterruptedException.ioException(e);
                throw new CommunicationException("Error closing socket", e);
            }
            Object var4_3 = null;
            this.m_threadPool.stop();
            socketSets2222 = this.cloneListOfSocketSets();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.m_threadPool.stop();
            ResourcePool[] socketSets2222 = this.cloneListOfSocketSets();
            int i = 0;
            while (true) {
                if (i >= socketSets2222.length) {
                    this.m_exceptionQueue.shutdown();
                    throw throwable;
                }
                socketSets2222[i].closeCurrentResources();
                ++i;
            }
        }
        for (int i = 0; i < socketSets2222.length; ++i) {
            socketSets2222[i].closeCurrentResources();
        }
        this.m_exceptionQueue.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourcePool[] cloneListOfSocketSets() {
        ResourcePool[] resourcePools;
        Map map = this.m_socketSets;
        synchronized (map) {
            resourcePools = this.m_socketSets.values().toArray(new ResourcePool[this.m_socketSets.size()]);
        }
        return resourcePools;
    }

    public int getPort() {
        return this.m_serverSocket.getLocalPort();
    }

    public Exception getPendingException(boolean block) {
        try {
            return (Exception)this.m_exceptionQueue.dequeue(block);
        }
        catch (ThreadSafeQueue.ShutdownException e) {
            return null;
        }
    }

    public int getNumberOfConnections() {
        ResourcePool[] socketSets = this.cloneListOfSocketSets();
        int result = 0;
        for (int i = 0; i < socketSets.length; ++i) {
            result += socketSets[i].countActive();
        }
        return result;
    }

    public void addListener(ConnectionType connectionType, Listener listener) {
        this.getListeners(connectionType).add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResourcePool getSocketSet(final ConnectionType connectionType) throws ShutdownException {
        Map map = this.m_socketSets;
        synchronized (map) {
            if (this.m_isShutdown) {
                throw new ShutdownException("Acceptor has been shut down");
            }
            ResourcePool original = (ResourcePool)this.m_socketSets.get(connectionType);
            if (original != null) {
                return original;
            }
            ResourcePoolImplementation newSocketSet = new ResourcePoolImplementation();
            newSocketSet.addListener(new ResourcePool.Listener(){

                public void resourceAdded(ResourcePool.Resource resource) {
                    ConnectionIdentity connection = ((SocketWrapper)resource).getConnectionIdentity();
                    Acceptor.this.getListeners(connectionType).apply(new ListenerSupport.Informer(this, connection){
                        private final /* synthetic */ ConnectionIdentity val$connection;
                        private final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$connection = val$connection;
                        }

                        public void inform(Object listener) {
                            ((Listener)listener).connectionAccepted(2.access$200(this.this$1), this.val$connection);
                        }
                    });
                }

                public void resourceClosed(ResourcePool.Resource resource) {
                    ConnectionIdentity connection = ((SocketWrapper)resource).getConnectionIdentity();
                    Acceptor.this.getListeners(connectionType).apply(new ListenerSupport.Informer(this, connection){
                        private final /* synthetic */ ConnectionIdentity val$connection;
                        private final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$connection = val$connection;
                        }

                        public void inform(Object listener) {
                            ((Listener)listener).connectionClosed(2.access$200(this.this$1), this.val$connection);
                        }
                    });
                }

                static /* synthetic */ ConnectionType access$200(2 x0) {
                    return x0.connectionType;
                }
            });
            this.m_socketSets.put(connectionType, newSocketSet);
            return newSocketSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ListenerSupport getListeners(ConnectionType connectionType) {
        Map map = this.m_listenerMap;
        synchronized (map) {
            ListenerSupport original = (ListenerSupport)this.m_listenerMap.get(connectionType);
            if (original != null) {
                return original;
            }
            ListenerSupport newList = new ListenerSupport();
            this.m_listenerMap.put(connectionType, newList);
            return newList;
        }
    }

    ThreadGroup getThreadGroup() {
        return this.m_threadPool.getThreadGroup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void discriminateConnection(Socket localSocket) throws IOException, ShutdownException {
        boolean closeSocket = true;
        try {
            try {
                Connector.ConnectDetails connectDetails = Connector.read(localSocket.getInputStream());
                SocketWrapper socketWrapper = new SocketWrapper(localSocket);
                socketWrapper.setAddress(connectDetails.getAddress());
                final ResourcePool.Closeable closeable = this.getSocketSet(connectDetails.getConnectionType()).add(socketWrapper);
                socketWrapper.addClosedListener(new SocketWrapper.ClosedListener(){

                    public void socketClosed() {
                        closeable.close();
                    }
                });
                return;
            }
            catch (CommunicationException e) {
                try {
                    this.m_exceptionQueue.queue(e);
                }
                catch (ThreadSafeQueue.ShutdownException shutdownException) {
                }
                Object var7_9 = null;
                if (!closeSocket) return;
                try {
                    localSocket.close();
                    return;
                }
                catch (IOException ioException) {
                    UncheckedInterruptedException.ioException(ioException);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (!closeSocket) throw throwable;
            try {
                localSocket.close();
                throw throwable;
            }
            catch (IOException ioException) {
                UncheckedInterruptedException.ioException(ioException);
            }
            throw throwable;
        }
    }

    public static final class ShutdownException
    extends CommunicationException {
        private ShutdownException(String s) {
            super(s);
        }
    }

    private class AcceptorRunnable
    implements InterruptibleRunnable {
        private AcceptorRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void interruptibleRun() {
            try {
                while (true) {
                    Socket localSocket = Acceptor.this.m_serverSocket.accept();
                    Acceptor.this.discriminateConnection(localSocket);
                }
            }
            catch (IOException e) {
                try {
                    Acceptor.this.shutdown();
                }
                catch (CommunicationException e2) {}
            }
            catch (ShutdownException e) {
                try {
                    Acceptor.this.shutdown();
                }
                catch (CommunicationException communicationException) {}
                catch (Throwable throwable) {
                    try {
                        Acceptor.this.shutdown();
                    }
                    catch (CommunicationException communicationException) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
    }

    public static interface Listener {
        public void connectionAccepted(ConnectionType var1, ConnectionIdentity var2);

        public void connectionClosed(ConnectionType var1, ConnectionIdentity var2);
    }
}

