/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.communication;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import net.grinder.common.UncheckedInterruptedException;
import net.grinder.communication.ResourcePool;
import net.grinder.util.ListenerSupport;

final class ResourcePoolImplementation
implements ResourcePool {
    private static final int PURGE_FREQUENCY = 1000;
    private final Object m_reservableFreedMutex = new Object();
    private final Object m_reserveAllMutex = new Object();
    private final Object m_reservablesMutex = new Object();
    private List m_reservables = new ArrayList();
    private int m_lastReservable = 0;
    private int m_nextPurge = 0;
    private final ListenerSupport m_listeners = new ListenerSupport();

    public ResourcePoolImplementation() {
        this.m_reservables.add(new Sentinel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourcePool.Closeable add(final ResourcePool.Resource resource) {
        ResourceWrapper resourceWrapper = new ResourceWrapper(resource);
        Object object = this.m_reservablesMutex;
        synchronized (object) {
            this.m_reservables.add(resourceWrapper);
        }
        this.m_listeners.apply(new ListenerSupport.Informer(){

            public void inform(Object listener) {
                ((ResourcePool.Listener)listener).resourceAdded(resource);
            }
        });
        return resourceWrapper;
    }

    public ResourcePool.Reservation reserveNext() {
        Object object = this.m_reservablesMutex;
        synchronized (object) {
            Reservable reservable;
            this.purgeZombieResources();
            do {
                if (++this.m_lastReservable < this.m_reservables.size()) continue;
                this.m_lastReservable = 0;
            } while (!(reservable = (Reservable)this.m_reservables.get(this.m_lastReservable)).reserve());
            return reservable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public List reserveAll() {
        Object object = this.m_reserveAllMutex;
        synchronized (object) {
            void var2_3;
            void var3_4;
            Object object2 = this.m_reservablesMutex;
            synchronized (object2) {
                this.purgeZombieResources();
                ArrayList result = new ArrayList(this.m_reservables.size());
                ArrayList reserveList = new ArrayList(this.m_reservables);
            }
            while (var3_4.size() > 0) {
                ListIterator iterator = var3_4.listIterator(var3_4.size());
                while (iterator.hasPrevious()) {
                    Reservable reservable = (Reservable)iterator.previous();
                    if (reservable.isSentinel()) {
                        iterator.remove();
                        continue;
                    }
                    if (reservable.reserve()) {
                        var2_3.add(reservable);
                        iterator.remove();
                        continue;
                    }
                    if (!reservable.isClosed()) continue;
                    iterator.remove();
                }
                if (var3_4.size() <= 0) continue;
                Object object3 = this.m_reservableFreedMutex;
                synchronized (object3) {
                    try {
                        this.m_reservableFreedMutex.wait(1000L);
                    }
                    catch (InterruptedException e) {
                        throw new UncheckedInterruptedException(e);
                    }
                }
            }
            return var2_3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeCurrentResources() {
        Reservable[] reservablesClone;
        Object object = this.m_reservablesMutex;
        synchronized (object) {
            reservablesClone = this.m_reservables.toArray(new Reservable[this.m_reservables.size()]);
        }
        for (int i = 0; i < reservablesClone.length; ++i) {
            reservablesClone[i].close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countActive() {
        int result = 0;
        Object object = this.m_reservablesMutex;
        synchronized (object) {
            Iterator iterator = this.m_reservables.iterator();
            while (iterator.hasNext()) {
                Reservable reservable = (Reservable)iterator.next();
                if (reservable.isClosed() || reservable.isSentinel()) continue;
                ++result;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeZombieResources() {
        Object object = this.m_reservablesMutex;
        synchronized (object) {
            if (++this.m_nextPurge > 1000) {
                this.m_nextPurge = 0;
                ArrayList<Reservable> newReservables = new ArrayList<Reservable>(this.m_reservables.size());
                Iterator iterator = this.m_reservables.iterator();
                while (iterator.hasNext()) {
                    Reservable reservable = (Reservable)iterator.next();
                    if (reservable.isClosed()) continue;
                    newReservables.add(reservable);
                }
                this.m_reservables = newReservables;
                this.m_lastReservable = 0;
            }
        }
    }

    public void addListener(ResourcePool.Listener listener) {
        this.m_listeners.add(listener);
    }

    private final class ResourceWrapper
    implements Reservable {
        private final ResourcePool.Resource m_resource;
        private boolean m_busy = false;
        private boolean m_closed;

        public ResourceWrapper(ResourcePool.Resource resource) {
            this.m_resource = resource;
        }

        public boolean isSentinel() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean reserve() {
            ResourceWrapper resourceWrapper = this;
            synchronized (resourceWrapper) {
                if (this.m_busy || this.m_closed) {
                    return false;
                }
                this.m_busy = true;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void free() {
            boolean stateChanged;
            Object object = this;
            synchronized (object) {
                stateChanged = this.m_busy;
                this.m_busy = false;
            }
            if (stateChanged) {
                object = ResourcePoolImplementation.this.m_reservableFreedMutex;
                synchronized (object) {
                    ResourcePoolImplementation.this.m_reservableFreedMutex.notifyAll();
                }
            }
        }

        public ResourcePool.Resource getResource() {
            return this.m_resource;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            boolean stateChanged;
            Object object = this;
            synchronized (object) {
                boolean bl = stateChanged = !this.m_closed;
                if (stateChanged) {
                    this.m_busy = false;
                    this.m_closed = true;
                    this.m_resource.close();
                }
            }
            if (stateChanged) {
                ListenerSupport.Informer informer;
                object = ResourcePoolImplementation.this.m_reservableFreedMutex;
                synchronized (object) {
                    ResourcePoolImplementation.this.m_reservableFreedMutex.notifyAll();
                }
                try {
                    informer = new ListenerSupport.Informer(this){
                        private final /* synthetic */ ResourceWrapper this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void inform(Object listener) {
                            ((ResourcePool.Listener)listener).resourceClosed(ResourceWrapper.access$200(this.this$1));
                        }
                    };
                }
                catch (Exception e) {
                    try {
                        throw e;
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (InterruptedException interruptedException) {
                        throw new UncheckedInterruptedException(interruptedException);
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)exception);
                    }
                }
                ResourcePoolImplementation.this.m_listeners.apply(informer);
            }
        }

        public synchronized boolean isClosed() {
            return this.m_closed;
        }

        static /* synthetic */ ResourcePool.Resource access$200(ResourceWrapper x0) {
            return x0.m_resource;
        }
    }

    private static final class Sentinel
    implements Reservable {
        private Sentinel() {
        }

        public boolean isSentinel() {
            return true;
        }

        public boolean reserve() {
            return true;
        }

        public ResourcePool.Resource getResource() {
            return null;
        }

        public void free() {
        }

        public void close() {
        }

        public boolean isClosed() {
            return false;
        }
    }

    private static interface Reservable
    extends ResourcePool.Reservation {
        public boolean reserve();
    }
}

