/*
 * Decompiled with CFR 0.152.
 */
package org.python.antlr;

import java.math.BigInteger;
import java.util.ArrayList;
import org.python.antlr.ErrorHandler;
import org.python.antlr.PythonParser;
import org.python.antlr.PythonTree;
import org.python.antlr.ast.Attribute;
import org.python.antlr.ast.BinOp;
import org.python.antlr.ast.BoolOp;
import org.python.antlr.ast.Call;
import org.python.antlr.ast.Context;
import org.python.antlr.ast.DictComp;
import org.python.antlr.ast.ExtSlice;
import org.python.antlr.ast.For;
import org.python.antlr.ast.FunctionDef;
import org.python.antlr.ast.GeneratorExp;
import org.python.antlr.ast.IfExp;
import org.python.antlr.ast.Index;
import org.python.antlr.ast.Lambda;
import org.python.antlr.ast.List;
import org.python.antlr.ast.ListComp;
import org.python.antlr.ast.Name;
import org.python.antlr.ast.Num;
import org.python.antlr.ast.Repr;
import org.python.antlr.ast.SetComp;
import org.python.antlr.ast.Slice;
import org.python.antlr.ast.Str;
import org.python.antlr.ast.TryExcept;
import org.python.antlr.ast.TryFinally;
import org.python.antlr.ast.Tuple;
import org.python.antlr.ast.UnaryOp;
import org.python.antlr.ast.While;
import org.python.antlr.ast.With;
import org.python.antlr.ast.Yield;
import org.python.antlr.ast.alias;
import org.python.antlr.ast.arguments;
import org.python.antlr.ast.boolopType;
import org.python.antlr.ast.cmpopType;
import org.python.antlr.ast.expr_contextType;
import org.python.antlr.ast.keyword;
import org.python.antlr.ast.operatorType;
import org.python.antlr.ast.unaryopType;
import org.python.antlr.base.excepthandler;
import org.python.antlr.base.expr;
import org.python.antlr.base.slice;
import org.python.antlr.base.stmt;
import org.python.antlr.runtime.Token;
import org.python.core.Py;
import org.python.core.PyComplex;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyLong;
import org.python.core.PyString;
import org.python.core.PyUnicode;
import org.python.core.codecs;

public class GrammarActions {
    private ErrorHandler errorHandler = null;

    public void setErrorHandler(ErrorHandler eh) {
        this.errorHandler = eh;
    }

    static String makeFromText$13dcf1d7(java.util.List<Name> names) {
        StringBuilder d = new StringBuilder();
        d.append(PythonTree.dottedNameListToString(names));
        return d.toString();
    }

    static java.util.List<Name> makeModuleNameNode(java.util.List dots, java.util.List<Name> names) {
        ArrayList<Name> result = new ArrayList<Name>();
        if (dots != null) {
            for (Object o : dots) {
                Token tok = (Token)o;
                result.add(new Name(tok, tok.getText(), expr_contextType.Load));
            }
        }
        if (names != null) {
            result.addAll(names);
        }
        return result;
    }

    static java.util.List<Name> makeDottedName(Token top, java.util.List<PythonTree> attrs) {
        ArrayList<Name> result = new ArrayList<Name>();
        result.add(new Name(top, top.getText(), expr_contextType.Load));
        if (attrs != null) {
            for (PythonTree attr : attrs) {
                Token token = attr.getToken();
                result.add(new Name(token, token.getText(), expr_contextType.Load));
            }
        }
        return result;
    }

    static int makeLevel(java.util.List lev) {
        if (lev == null) {
            return 0;
        }
        return lev.size();
    }

    static java.util.List<alias> makeStarAlias(Token t) {
        ArrayList<alias> result = new ArrayList<alias>();
        result.add(new alias(t, "*", null));
        return result;
    }

    static java.util.List<alias> makeAliases(java.util.List<alias> atypes) {
        if (atypes == null) {
            return new ArrayList<alias>();
        }
        return atypes;
    }

    static java.util.List<expr> makeBases(expr etype) {
        ArrayList<expr> result = new ArrayList<expr>();
        if (etype != null) {
            if (etype instanceof Tuple) {
                return ((Tuple)etype).getInternalElts();
            }
            result.add(etype);
        }
        return result;
    }

    static java.util.List<String> makeNames(java.util.List names) {
        ArrayList<String> s = new ArrayList<String>();
        for (int i = 0; i < names.size(); ++i) {
            s.add(((Token)names.get(i)).getText());
        }
        return s;
    }

    static Name makeNameNode(Token t) {
        if (t == null) {
            return null;
        }
        return new Name(t, t.getText(), expr_contextType.Load);
    }

    final java.util.List<Name> makeNameNodes(java.util.List<Token> names) {
        ArrayList<Name> s = new ArrayList<Name>();
        for (int i = 0; i < names.size(); ++i) {
            s.add(GrammarActions.makeNameNode(names.get(i)));
        }
        return s;
    }

    final void errorGenExpNotSoleArg(PythonTree t) {
        this.errorHandler.error("Generator expression must be parenthesized if not sole argument", t);
    }

    final expr castExpr(Object o) {
        if (o instanceof expr) {
            return (expr)o;
        }
        if (o instanceof PythonTree) {
            return this.errorHandler.errorExpr((PythonTree)o);
        }
        return null;
    }

    final java.util.List<expr> castExprs(java.util.List exprs) {
        return GrammarActions.castExprs(exprs, 0);
    }

    static java.util.List<expr> castExprs(java.util.List exprs, int start) {
        ArrayList<expr> result = new ArrayList<expr>();
        if (exprs != null) {
            for (int i = start; i < exprs.size(); ++i) {
                Object o = exprs.get(i);
                if (o instanceof expr) {
                    result.add((expr)o);
                    continue;
                }
                if (!(o instanceof PythonParser.test_return)) continue;
                result.add((expr)((PythonParser.test_return)o).tree);
            }
        }
        return result;
    }

    final java.util.List<stmt> makeElse(java.util.List elseSuite, PythonTree elif) {
        if (elseSuite != null) {
            return this.castStmts(elseSuite);
        }
        if (elif == null) {
            return new ArrayList<stmt>();
        }
        ArrayList<stmt> s = new ArrayList<stmt>();
        s.add(this.castStmt(elif));
        return s;
    }

    private stmt castStmt(Object o) {
        if (o instanceof stmt) {
            return (stmt)o;
        }
        if (o instanceof PythonParser.stmt_return) {
            return (stmt)((PythonParser.stmt_return)o).tree;
        }
        if (o instanceof PythonTree) {
            return this.errorHandler.errorStmt((PythonTree)o);
        }
        return null;
    }

    static java.util.List<stmt> castStmts(PythonTree t) {
        stmt s = (stmt)t;
        ArrayList<stmt> stmts = new ArrayList<stmt>();
        stmts.add(s);
        return stmts;
    }

    final java.util.List<stmt> castStmts(java.util.List stmts) {
        if (stmts != null) {
            ArrayList<stmt> result = new ArrayList<stmt>();
            for (Object o : stmts) {
                result.add(this.castStmt(o));
            }
            return result;
        }
        return new ArrayList<stmt>();
    }

    final expr makeDottedAttr(Token nameToken, java.util.List attrs) {
        expr current = new Name(nameToken, nameToken.getText(), expr_contextType.Load);
        for (Object o : attrs) {
            Token t = (Token)o;
            current = new Attribute(t, current, this.cantBeNoneName(t), expr_contextType.Load);
        }
        return current;
    }

    final stmt makeWhile(Token t, expr test, java.util.List body, java.util.List orelse) {
        if (test == null) {
            return this.errorHandler.errorStmt(new PythonTree(t));
        }
        java.util.List<stmt> o = this.castStmts(orelse);
        java.util.List<stmt> b = this.castStmts(body);
        return new While(t, test, b, o);
    }

    static stmt makeWith$35a85bdb(java.util.List<With> items, java.util.List<stmt> body) {
        int last = items.size() - 1;
        With result = null;
        for (int i = last; i >= 0; --i) {
            With current = items.get(i);
            if (i != last) {
                body = new ArrayList<stmt>();
                body.add(result);
            }
            result = new With(current.getToken(), current.getInternalContext_expr(), current.getInternalOptional_vars(), body);
        }
        return result;
    }

    final stmt makeFor(Token t, expr target, expr iter, java.util.List body, java.util.List orelse) {
        if (target == null || iter == null) {
            return this.errorHandler.errorStmt(new PythonTree(t));
        }
        expr expr2 = target;
        GrammarActions grammarActions = this;
        if (expr2.getText().equals("None")) {
            grammarActions.errorHandler.error("can't be None", expr2);
        }
        java.util.List<stmt> o = this.castStmts(orelse);
        java.util.List<stmt> b = this.castStmts(body);
        return new For(t, target, iter, b, o);
    }

    final stmt makeTryExcept(Token t, java.util.List body, java.util.List<excepthandler> handlers, java.util.List orelse, java.util.List finBody) {
        java.util.List<stmt> b = this.castStmts(body);
        java.util.List<excepthandler> e = handlers;
        java.util.List<stmt> o = this.castStmts(orelse);
        TryExcept te = new TryExcept(t, b, e, o);
        if (finBody == null) {
            return te;
        }
        java.util.List<stmt> f = this.castStmts(finBody);
        ArrayList<stmt> mainBody = new ArrayList<stmt>();
        mainBody.add(te);
        return new TryFinally(t, mainBody, f);
    }

    final TryFinally makeTryFinally(Token t, java.util.List body, java.util.List finBody) {
        java.util.List<stmt> b = this.castStmts(body);
        java.util.List<stmt> f = this.castStmts(finBody);
        return new TryFinally(t, b, f);
    }

    final stmt makeFuncdef(Token t, Token nameToken, arguments args, java.util.List funcStatements, java.util.List decorators) {
        if (nameToken == null) {
            return this.errorHandler.errorStmt(new PythonTree(t));
        }
        Name n = this.cantBeNoneName(nameToken);
        arguments a = args != null ? args : new arguments(t, new ArrayList<expr>(), null, null, new ArrayList<expr>());
        java.util.List<stmt> s = this.castStmts(funcStatements);
        java.util.List<expr> d = this.castExprs(decorators);
        return new FunctionDef(t, n, a, s, d);
    }

    final java.util.List<expr> makeAssignTargets(expr lhs, java.util.List rhs) {
        ArrayList<expr> e = new ArrayList<expr>();
        this.checkAssign(lhs);
        e.add(lhs);
        for (int i = 0; i < rhs.size() - 1; ++i) {
            expr r = this.castExpr(rhs.get(i));
            this.checkAssign(r);
            e.add(r);
        }
        return e;
    }

    final expr makeAssignValue(java.util.List rhs) {
        expr value = this.castExpr(rhs.get(rhs.size() - 1));
        this.recurseSetContext(value, expr_contextType.Load);
        return value;
    }

    final void recurseSetContext(PythonTree tree, expr_contextType context) {
        if (tree instanceof Context) {
            ((Context)((Object)tree)).setContext(context);
        }
        if (tree instanceof GeneratorExp) {
            GeneratorExp g = (GeneratorExp)tree;
            this.recurseSetContext(g.getInternalElt(), context);
            return;
        }
        if (tree instanceof ListComp) {
            ListComp lc = (ListComp)tree;
            this.recurseSetContext(lc.getInternalElt(), context);
            return;
        }
        if (tree instanceof SetComp) {
            SetComp sc = (SetComp)tree;
            this.recurseSetContext(sc.getInternalElt(), context);
            return;
        }
        if (tree instanceof DictComp) {
            DictComp dc = (DictComp)tree;
            this.recurseSetContext(dc.getInternalKey(), context);
            this.recurseSetContext(dc.getInternalValue(), context);
            return;
        }
        if (!(tree instanceof ListComp || tree instanceof DictComp || tree instanceof SetComp)) {
            for (int i = 0; i < tree.getChildCount(); ++i) {
                this.recurseSetContext(tree.getChild(i), context);
            }
        }
    }

    final arguments makeArgumentsType(Token t, java.util.List params, Token snameToken, Token knameToken, java.util.List defaults) {
        java.util.List list = params;
        GrammarActions grammarActions = this;
        java.util.List<expr> p = GrammarActions.castExprs(list, 0);
        list = defaults;
        grammarActions = this;
        java.util.List<expr> d = GrammarActions.castExprs(list, 0);
        Name s = snameToken == null ? null : this.cantBeNoneName(snameToken);
        Name k = knameToken == null ? null : this.cantBeNoneName(knameToken);
        return new arguments(t, p, s, k, d);
    }

    final java.util.List<keyword> makeKeywords(java.util.List args) {
        ArrayList<keyword> keywords = new ArrayList<keyword>();
        if (args != null) {
            for (Object o : args) {
                java.util.List e = (java.util.List)o;
                Object k = e.get(0);
                Object v = e.get(1);
                this.checkAssign(this.castExpr(k));
                if (k instanceof Name) {
                    Name arg = (Name)k;
                    keywords.add(new keyword(arg, arg.getInternalId(), this.castExpr(v)));
                    continue;
                }
                this.errorHandler.error("keyword must be a name", (PythonTree)k);
            }
        }
        return keywords;
    }

    static Object makeFloat(Token t) {
        return Py.newFloat(Double.valueOf(t.getText()));
    }

    static Object makeComplex(Token t) {
        String s = t.getText();
        s = s.substring(0, s.length() - 1);
        return Py.newImaginary(Double.valueOf(s));
    }

    static Object makeInt(Token t) {
        int i;
        String s = t.getText();
        int radix = 10;
        if (s.startsWith("0x") || s.startsWith("0X")) {
            radix = 16;
            s = s.substring(2, s.length());
        } else if (s.startsWith("0o") || s.startsWith("0O")) {
            radix = 8;
            s = s.substring(2, s.length());
        } else if (s.startsWith("0b") || s.startsWith("0B")) {
            radix = 2;
            s = s.substring(2, s.length());
        } else if (s.startsWith("0")) {
            radix = 8;
        }
        if (s.endsWith("L") || s.endsWith("l")) {
            s = s.substring(0, s.length() - 1);
            return Py.newLong(new BigInteger(s, radix));
        }
        int ndigits = s.length();
        for (i = 0; i < ndigits && s.charAt(i) == '0'; ++i) {
        }
        if (ndigits - i > 11) {
            return Py.newLong(new BigInteger(s, radix));
        }
        long l = Long.valueOf(s, radix);
        if (l > 0xFFFFFFFFL || l > Integer.MAX_VALUE) {
            return Py.newLong(new BigInteger(s, radix));
        }
        return Py.newInteger((int)l);
    }

    final PyString extractStrings(java.util.List s, String encoding, boolean unicodeLiterals) {
        boolean ustring = false;
        StringBuffer sb = new StringBuffer();
        for (Token last : s) {
            StringPair sp;
            boolean bl = unicodeLiterals;
            String string = encoding;
            Token token = last;
            GrammarActions grammarActions = this;
            String string2 = token.getText();
            char c = string2.charAt(0);
            int n = 0;
            boolean bl2 = bl;
            if (c == 'u' || c == 'U') {
                bl2 = true;
                ++n;
            }
            if (c == 'b' || c == 'B') {
                bl2 = false;
                ++n;
            }
            c = string2.charAt(n);
            boolean bl3 = false;
            if (c == 'r' || c == 'R') {
                bl3 = true;
                ++n;
            }
            int n2 = 3;
            if (string2.length() - n == 2) {
                n2 = 1;
            }
            if (string2.charAt(n) != string2.charAt(n + 1)) {
                n2 = 1;
            }
            n = n2 + n;
            int n3 = string2.length() - n2;
            if (!bl2 && string != null) {
                string2 = new PyUnicode(string2.substring(n, n3)).encode(string);
                if (!bl3) {
                    string2 = PyString.decode_UnicodeEscape(string2, 0, string2.length(), "strict", bl2);
                }
            } else if (bl3) {
                string2 = string2.substring(n, n3);
                if (bl2) {
                    string2 = codecs.PyUnicode_DecodeRawUnicodeEscape(string2, "strict");
                }
            } else {
                string2 = PyString.decode_UnicodeEscape(string2, n, n3, "strict", bl2);
            }
            if ((sp = new StringPair(grammarActions, string2, bl2)).isUnicode()) {
                ustring = true;
            }
            sb.append(sp.getString());
        }
        if (ustring) {
            return new PyUnicode(sb.toString());
        }
        return new PyString(sb.toString());
    }

    private StringPair extractString(Token t, String encoding, boolean unicodeLiterals) {
        String string = t.getText();
        char quoteChar = string.charAt(0);
        int start = 0;
        boolean ustring = unicodeLiterals;
        if (quoteChar == 'u' || quoteChar == 'U') {
            ustring = true;
            ++start;
        }
        if (quoteChar == 'b' || quoteChar == 'B') {
            ustring = false;
            ++start;
        }
        quoteChar = string.charAt(start);
        boolean raw = false;
        if (quoteChar == 'r' || quoteChar == 'R') {
            raw = true;
            ++start;
        }
        int quotes = 3;
        if (string.length() - start == 2) {
            quotes = 1;
        }
        if (string.charAt(start) != string.charAt(start + 1)) {
            quotes = 1;
        }
        start = quotes + start;
        int end = string.length() - quotes;
        if (!ustring && encoding != null) {
            string = new PyUnicode(string.substring(start, end)).encode(encoding);
            if (!raw) {
                string = PyString.decode_UnicodeEscape(string, 0, string.length(), "strict", ustring);
            }
        } else if (raw) {
            string = string.substring(start, end);
            if (ustring) {
                string = codecs.PyUnicode_DecodeRawUnicodeEscape(string, "strict");
            }
        } else {
            string = PyString.decode_UnicodeEscape(string, start, end, "strict", ustring);
        }
        return new StringPair(this, string, ustring);
    }

    static Token extractStringToken(java.util.List s) {
        return (Token)s.get(0);
    }

    final expr makeCall(Token t, expr func) {
        return this.makeCall(t, func, null, null, null, null);
    }

    final expr makeCall(Token t, expr func, java.util.List args, java.util.List keywords, expr starargs, expr kwargs) {
        if (func == null) {
            return this.errorHandler.errorExpr(new PythonTree(t));
        }
        java.util.List<keyword> k = this.makeKeywords(keywords);
        java.util.List list = args;
        GrammarActions grammarActions = this;
        java.util.List<expr> a = GrammarActions.castExprs(list, 0);
        return new Call(t, func, a, k, starargs, kwargs);
    }

    private static expr negate(PythonTree t, expr o) {
        if (o instanceof Num) {
            Num num = (Num)o;
            if (num.getInternalN() instanceof PyInteger) {
                int v = ((PyInteger)num.getInternalN()).getValue();
                if (v >= 0) {
                    num.setN(new PyInteger(-v));
                    return num;
                }
            } else if (num.getInternalN() instanceof PyLong) {
                BigInteger v = ((PyLong)num.getInternalN()).getValue();
                if (v.compareTo(BigInteger.ZERO) == 1) {
                    num.setN(new PyLong(v.negate()));
                    return num;
                }
            } else if (num.getInternalN() instanceof PyFloat) {
                double d;
                double v = ((PyFloat)num.getInternalN()).getValue();
                if (d >= 0.0) {
                    num.setN(new PyFloat(-v));
                    return num;
                }
            } else if (num.getInternalN() instanceof PyComplex) {
                double d;
                double v = ((PyComplex)num.getInternalN()).imag;
                if (d >= 0.0) {
                    num.setN(new PyComplex(0.0, -v));
                    return num;
                }
            }
        }
        return new UnaryOp(t, unaryopType.USub, o);
    }

    final Name cantBeNoneName(Token t) {
        if (t == null || t.getText().equals("None")) {
            this.errorHandler.error("can't be None", new PythonTree(t));
        }
        return new Name(t, t.getText(), expr_contextType.Load);
    }

    private void cantBeNone(PythonTree e) {
        if (e.getText().equals("None")) {
            this.errorHandler.error("can't be None", e);
        }
    }

    private void checkGenericAssign(expr e) {
        if (e instanceof Name && ((Name)e).getInternalId().equals("None")) {
            this.errorHandler.error("assignment to None", e);
            return;
        }
        if (e instanceof GeneratorExp) {
            this.errorHandler.error("can't assign to generator expression", e);
            return;
        }
        if (e instanceof Num) {
            this.errorHandler.error("can't assign to number", e);
            return;
        }
        if (e instanceof Str) {
            this.errorHandler.error("can't assign to string", e);
            return;
        }
        if (e instanceof Yield) {
            this.errorHandler.error("can't assign to yield expression", e);
            return;
        }
        if (e instanceof BinOp) {
            this.errorHandler.error("can't assign to operator", e);
            return;
        }
        if (e instanceof BoolOp) {
            this.errorHandler.error("can't assign to operator", e);
            return;
        }
        if (e instanceof Lambda) {
            this.errorHandler.error("can't assign to lambda", e);
            return;
        }
        if (e instanceof Call) {
            this.errorHandler.error("can't assign to function call", e);
            return;
        }
        if (e instanceof Repr) {
            this.errorHandler.error("can't assign to repr", e);
            return;
        }
        if (e instanceof IfExp) {
            this.errorHandler.error("can't assign to conditional expression", e);
            return;
        }
        if (e instanceof ListComp) {
            this.errorHandler.error("can't assign to list comprehension", e);
            return;
        }
        if (e instanceof SetComp) {
            this.errorHandler.error("can't assign to set comprehension", e);
            return;
        }
        if (e instanceof DictComp) {
            this.errorHandler.error("can't assign to dict comprehension", e);
        }
    }

    final void checkAugAssign(expr e) {
        this.checkGenericAssign(e);
        if (e instanceof Tuple) {
            this.errorHandler.error("assignment to tuple illegal for augmented assignment", e);
            return;
        }
        if (e instanceof List) {
            this.errorHandler.error("assignment to list illegal for augmented assignment", e);
        }
    }

    final void checkAssign(expr e) {
        this.checkGenericAssign(e);
        if (e instanceof Tuple) {
            java.util.List<expr> elts = ((Tuple)e).getInternalElts();
            if (elts.size() == 0) {
                this.errorHandler.error("can't assign to ()", e);
            }
            for (int i = 0; i < elts.size(); ++i) {
                this.checkAssign(elts.get(i));
            }
            return;
        }
        if (e instanceof List) {
            java.util.List<expr> elts = ((List)e).getInternalElts();
            for (int i = 0; i < elts.size(); ++i) {
                this.checkAssign(elts.get(i));
            }
        }
    }

    final java.util.List<expr> makeDeleteList(java.util.List deletes) {
        java.util.List list = deletes;
        GrammarActions grammarActions = this;
        java.util.List<expr> exprs = GrammarActions.castExprs(list, 0);
        for (expr e : exprs) {
            this.checkDelete(e);
        }
        return exprs;
    }

    private void checkDelete(expr e) {
        if (e instanceof Call) {
            this.errorHandler.error("can't delete function call", e);
            return;
        }
        if (e instanceof Num) {
            this.errorHandler.error("can't delete number", e);
            return;
        }
        if (e instanceof Str) {
            this.errorHandler.error("can't delete string", e);
            return;
        }
        if (e instanceof Tuple) {
            java.util.List<expr> elts = ((Tuple)e).getInternalElts();
            if (elts.size() == 0) {
                this.errorHandler.error("can't delete ()", e);
            }
            for (int i = 0; i < elts.size(); ++i) {
                this.checkDelete(elts.get(i));
            }
            return;
        }
        if (e instanceof List) {
            java.util.List<expr> elts = ((List)e).getInternalElts();
            for (int i = 0; i < elts.size(); ++i) {
                this.checkDelete(elts.get(i));
            }
        }
    }

    final slice makeSubscript(PythonTree lower, Token colon, PythonTree upper, PythonTree sliceop) {
        boolean isSlice = false;
        expr s = null;
        expr e = null;
        expr o = null;
        if (lower != null) {
            s = this.castExpr(lower);
        }
        if (colon != null) {
            isSlice = true;
            if (upper != null) {
                e = this.castExpr(upper);
            }
        }
        if (sliceop != null) {
            isSlice = true;
            o = sliceop != null ? this.castExpr(sliceop) : new Name(sliceop, "None", expr_contextType.Load);
        }
        PythonTree tok = lower;
        if (lower == null) {
            tok = new PythonTree(colon);
        }
        if (isSlice) {
            return new Slice(tok, s, e, o);
        }
        return new Index(tok, s);
    }

    static java.util.List<cmpopType> makeCmpOps(java.util.List cmps) {
        ArrayList<cmpopType> result = new ArrayList<cmpopType>();
        for (Object o : cmps) {
            result.add((cmpopType)((Object)o));
        }
        return result;
    }

    final BoolOp makeBoolOp(Token t, PythonTree left, boolopType op, java.util.List right) {
        ArrayList<PythonTree> values = new ArrayList<PythonTree>();
        values.add(left);
        values.addAll(right);
        return new BoolOp(t, op, this.castExprs(values));
    }

    final BinOp makeBinOp(Token t, PythonTree left, operatorType op, java.util.List rights) {
        BinOp current = new BinOp(t, this.castExpr(left), op, this.castExpr(rights.get(0)));
        for (int i = 1; i < rights.size(); ++i) {
            expr right = this.castExpr(rights.get(i));
            current = new BinOp(left, (expr)current, op, right);
        }
        return current;
    }

    final BinOp makeBinOp(Token t, PythonTree left, java.util.List ops, java.util.List rights, java.util.List toks) {
        BinOp current = new BinOp(t, this.castExpr(left), (operatorType)((Object)ops.get(0)), this.castExpr(rights.get(0)));
        for (int i = 1; i < rights.size(); ++i) {
            expr right = this.castExpr(rights.get(i));
            operatorType op = (operatorType)((Object)ops.get(i));
            current = new BinOp((Token)toks.get(i), (expr)current, op, right);
        }
        return current;
    }

    private java.util.List<slice> castSlices(java.util.List slices) {
        ArrayList<slice> result = new ArrayList<slice>();
        if (slices != null) {
            for (Object o : slices) {
                result.add(this.castSlice(o));
            }
        }
        return result;
    }

    final slice castSlice(Object o) {
        if (o instanceof slice) {
            return (slice)o;
        }
        return this.errorHandler.errorSlice((PythonTree)o);
    }

    final slice makeSliceType(Token begin, Token c1, Token c2, java.util.List sltypes) {
        boolean isTuple = false;
        if (c1 != null || c2 != null) {
            isTuple = true;
        }
        slice s = null;
        boolean extslice = false;
        if (isTuple) {
            ArrayList<expr> etypes = new ArrayList<expr>();
            for (Object o : sltypes) {
                if (o instanceof Index) {
                    Index i = (Index)o;
                    etypes.add(i.getInternalValue());
                    continue;
                }
                extslice = true;
                break;
            }
            if (!extslice) {
                Tuple t = new Tuple(begin, etypes, expr_contextType.Load);
                s = new Index(begin, (expr)t);
            }
        } else if (sltypes.size() == 1) {
            s = this.castSlice(sltypes.get(0));
        } else if (sltypes.size() != 0) {
            extslice = true;
        }
        if (extslice) {
            java.util.List<slice> st = this.castSlices(sltypes);
            s = new ExtSlice(begin, st);
        }
        return s;
    }

    class StringPair {
        private String s;
        private boolean unicode;
        private /* synthetic */ GrammarActions this$0;

        StringPair(GrammarActions grammarActions, String s, boolean unicode) {
            this.s = s;
            this.unicode = unicode;
        }

        final String getString() {
            return this.s;
        }

        final boolean isUnicode() {
            return this.unicode;
        }
    }
}

