/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyBoolean$PyExposer;
import org.python.core.PyInteger;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PyType;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;

@ExposedType(name="bool", isBaseType=false, doc="bool(x) -> bool\n\nReturns True when the argument x is true, False otherwise.\nThe builtins True and False are the only two instances of the class bool.\nThe class bool is a subclass of the class int, and cannot be subclassed.")
public class PyBoolean
extends PyInteger {
    public static final PyType TYPE;
    private final boolean value;

    public boolean getBooleanValue() {
        return this.value;
    }

    @Override
    public int getValue() {
        if (this.getBooleanValue()) {
            return 1;
        }
        return 0;
    }

    public PyBoolean(boolean value) {
        super(TYPE, value ? 1 : 0);
        this.value = value;
    }

    @ExposedNew
    public static PyObject bool_new(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        ArgParser ap = new ArgParser("bool", args, keywords, new String[]{"x"}, 0);
        PyObject obj = ap.getPyObject(0, null);
        if (obj == null) {
            return Py.False;
        }
        if (obj.__nonzero__()) {
            return Py.True;
        }
        return Py.False;
    }

    @Override
    public String toString() {
        return this.bool_toString();
    }

    final String bool_toString() {
        if (this.getBooleanValue()) {
            return "True";
        }
        return "False";
    }

    @Override
    public int hashCode() {
        return this.bool___hash__();
    }

    final int bool___hash__() {
        if (this.getBooleanValue()) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean __nonzero__() {
        PyBoolean pyBoolean = this;
        return pyBoolean.getBooleanValue();
    }

    final boolean bool___nonzero__() {
        return this.getBooleanValue();
    }

    @Override
    public Object __tojava__(Class<?> c) {
        if (c == Boolean.TYPE || c == Boolean.class || c == Object.class) {
            return this.getBooleanValue();
        }
        if (c == Integer.TYPE || c == Number.class || c == Integer.class) {
            return this.getValue();
        }
        if (c == Byte.TYPE || c == Byte.class) {
            return (byte)this.getValue();
        }
        if (c == Short.TYPE || c == Short.class) {
            return (short)this.getValue();
        }
        if (c == Long.TYPE || c == Long.class) {
            return (long)this.getValue();
        }
        if (c == Float.TYPE || c == Float.class) {
            return Float.valueOf(this.getValue());
        }
        if (c == Double.TYPE || c == Double.class) {
            return (double)this.getValue();
        }
        return super.__tojava__(c);
    }

    @Override
    public PyObject __and__(PyObject right) {
        return this.bool___and__(right);
    }

    final PyObject bool___and__(PyObject right) {
        if (right instanceof PyBoolean) {
            return Py.newBoolean(this.getBooleanValue() & ((PyBoolean)right).getBooleanValue());
        }
        if (right instanceof PyInteger) {
            return Py.newInteger(this.getValue() & ((PyInteger)right).getValue());
        }
        return null;
    }

    @Override
    public PyObject __xor__(PyObject right) {
        return this.bool___xor__(right);
    }

    final PyObject bool___xor__(PyObject right) {
        if (right instanceof PyBoolean) {
            return Py.newBoolean(this.getBooleanValue() ^ ((PyBoolean)right).getBooleanValue());
        }
        if (right instanceof PyInteger) {
            return Py.newInteger(this.getValue() ^ ((PyInteger)right).getValue());
        }
        return null;
    }

    @Override
    public PyObject __or__(PyObject right) {
        return this.bool___or__(right);
    }

    final PyObject bool___or__(PyObject right) {
        if (right instanceof PyBoolean) {
            return Py.newBoolean(this.getBooleanValue() | ((PyBoolean)right).getBooleanValue());
        }
        if (right instanceof PyInteger) {
            return Py.newInteger(this.getValue() | ((PyInteger)right).getValue());
        }
        return null;
    }

    @Override
    public PyObject __neg__() {
        return this.bool___neg__();
    }

    final PyObject bool___neg__() {
        return Py.newInteger(this.getBooleanValue() ? -1 : 0);
    }

    @Override
    public PyObject __pos__() {
        PyBoolean pyBoolean = this;
        return Py.newInteger(pyBoolean.getValue());
    }

    final PyObject bool___pos__() {
        return Py.newInteger(this.getValue());
    }

    @Override
    public PyObject __abs__() {
        PyBoolean pyBoolean = this;
        return Py.newInteger(pyBoolean.getValue());
    }

    final PyObject bool___abs__() {
        return Py.newInteger(this.getValue());
    }

    static {
        PyType.addBuilder(PyBoolean.class, new PyBoolean$PyExposer());
        TYPE = PyType.fromClass(PyBoolean.class);
    }
}

