/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import java.util.List;
import org.python.indexer.Scope;
import org.python.indexer.ast.NName;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNodeVisitor;
import org.python.indexer.ast.NSequence;
import org.python.indexer.ast.NameBinder;
import org.python.indexer.types.NType;
import org.python.indexer.types.NUnknownType;

public final class NComprehension
extends NNode {
    private NNode target;
    private NNode iter;
    private List<NNode> ifs;

    public NComprehension(NNode target, NNode iter, List<NNode> ifs) {
        this(null, null, null, 0, 1);
    }

    public NComprehension(NNode target, NNode iter, List<NNode> ifs, int start, int end) {
        super(start, end);
        this.target = target;
        this.iter = iter;
        this.ifs = ifs;
        this.addChildren(target, iter);
        this.addChildren(ifs);
    }

    @Override
    public final boolean bindsName() {
        return true;
    }

    @Override
    protected final void bindNames(Scope s) throws Exception {
        this.bindNames(s, this.target, NameBinder.make());
    }

    private void bindNames(Scope s, NNode target, NameBinder binder) throws Exception {
        if (target instanceof NName) {
            binder.bind(s, (NName)target, (NType)new NUnknownType());
            return;
        }
        if (target instanceof NSequence) {
            NSequence nSequence = (NSequence)target;
            for (NNode n : nSequence.elts) {
                this.bindNames(s, n, binder);
            }
        }
    }

    @Override
    public final NType resolve(Scope s) throws Exception {
        NameBinder.make().bindIter(s, this.target, this.iter);
        NComprehension.resolveList(this.ifs, s);
        return this.setType(this.target.getType());
    }

    public final String toString() {
        return "<Comprehension:" + this.start() + ":" + this.target + ":" + this.iter + ":" + this.ifs + ">";
    }

    @Override
    public final void visit(NNodeVisitor v) {
        if (v.visit(this)) {
            NComprehension.visitNode(this.target, v);
            NComprehension.visitNode(this.iter, v);
            NComprehension.visitNodeList(this.ifs, v);
        }
    }
}

