/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.util.List;
import org.testng.collections.Lists;
import org.testng.internal.ClassHelper;
import org.testng.internal.PropertyUtils;
import org.testng.internal.Utils;

public class ReporterConfig {
    private String m_className;
    private List<Property> m_properties = Lists.newArrayList();

    public void addProperty(Property property) {
        this.m_properties.add(property);
    }

    public List<Property> getProperties() {
        return this.m_properties;
    }

    public String getClassName() {
        return this.m_className;
    }

    public void setClassName(String string) {
        this.m_className = string;
    }

    public String serialize() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.m_className);
        if (!this.m_properties.isEmpty()) {
            stringBuffer.append(":");
            for (int i = 0; i < this.m_properties.size(); ++i) {
                Property property = this.m_properties.get(i);
                stringBuffer.append(property.getName());
                stringBuffer.append("=");
                stringBuffer.append(property.getValue());
                if (i >= this.m_properties.size() - 1) continue;
                stringBuffer.append(",");
            }
        }
        return stringBuffer.toString();
    }

    public static ReporterConfig deserialize(String string) {
        ReporterConfig reporterConfig = null;
        if (!Utils.isStringEmpty(string)) {
            reporterConfig = new ReporterConfig();
            int n = string.indexOf(":");
            if (n == -1) {
                reporterConfig.setClassName(string);
            } else {
                reporterConfig.setClassName(string.substring(0, n));
                String string2 = string.substring(n + 1, string.length());
                String[] stringArray = string2.split(",");
                if (stringArray != null && stringArray.length > 0) {
                    for (String string3 : stringArray) {
                        String[] stringArray2 = string3.split("=");
                        if (stringArray2 == null || stringArray2.length != 2) continue;
                        Property property = new Property();
                        property.setName(stringArray2[0]);
                        property.setValue(stringArray2[1]);
                        reporterConfig.addProperty(property);
                    }
                }
            }
        }
        return reporterConfig;
    }

    public Object newReporterInstance() {
        Object var1_1 = null;
        Class<?> clazz = ClassHelper.forName(this.m_className);
        if (clazz != null) {
            var1_1 = ClassHelper.newInstance(clazz);
            for (Property property : this.m_properties) {
                PropertyUtils.setProperty(var1_1, property.getName(), property.getValue());
            }
        }
        return var1_1;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nClass = " + this.m_className);
        for (Property property : this.m_properties) {
            stringBuffer.append("\n\t " + property.getName() + "=" + property.getValue());
        }
        return stringBuffer.toString();
    }

    public static class Property {
        private String name;
        private String value;

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String string) {
            this.value = string;
        }
    }
}

