/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.testng.ITestNGMethod;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.internal.MethodGroupsHelper;
import org.testng.internal.MethodHelper;
import org.testng.internal.Utils;

public class MethodInheritance {
    private static List<ITestNGMethod> findMethodListSuperClass(Map<Class, List<ITestNGMethod>> map, Class<? extends ITestNGMethod> clazz) {
        for (Map.Entry<Class, List<ITestNGMethod>> entry : map.entrySet()) {
            if (!entry.getKey().isAssignableFrom(clazz)) continue;
            return entry.getValue();
        }
        return null;
    }

    private static Class findSubClass(Map<Class, List<ITestNGMethod>> map, Class<? extends ITestNGMethod> clazz) {
        for (Class clazz2 : map.keySet()) {
            if (!clazz.isAssignableFrom(clazz2)) continue;
            return clazz2;
        }
        return null;
    }

    public static void fixMethodInheritance(ITestNGMethod[] iTestNGMethodArray, boolean bl) {
        Object object;
        Map<Class, List<ITestNGMethod>> map = Maps.newHashMap();
        for (ITestNGMethod iTestNGMethod : iTestNGMethodArray) {
            Class clazz = iTestNGMethod.getRealClass();
            object = MethodInheritance.findMethodListSuperClass(map, clazz);
            if (null != object) {
                object.add((ITestNGMethod)iTestNGMethod);
                continue;
            }
            Class clazz2 = MethodInheritance.findSubClass(map, clazz);
            if (null != clazz2) {
                object = map.get(clazz2);
                object.add((ITestNGMethod)iTestNGMethod);
                map.remove(clazz2);
                map.put(clazz, (List<ITestNGMethod>)object);
                continue;
            }
            object = Lists.newArrayList();
            object.add((ITestNGMethod)iTestNGMethod);
            map.put(clazz, (List<ITestNGMethod>)object);
        }
        for (List list : map.values()) {
            if (list.size() <= 1) continue;
            MethodInheritance.sortMethodsByInheritance(list, bl);
            for (int i = 0; i < list.size() - 1; ++i) {
                ITestNGMethod iTestNGMethod;
                iTestNGMethod = (ITestNGMethod)list.get(i);
                for (int j = i + 1; j < list.size(); ++j) {
                    object = (ITestNGMethod)list.get(j);
                    if (MethodInheritance.equalsEffectiveClass(iTestNGMethod, (ITestNGMethod)object) || MethodInheritance.dependencyExists(iTestNGMethod, (ITestNGMethod)object, iTestNGMethodArray)) continue;
                    Utils.log("MethodInheritance", 4, object + " DEPENDS ON " + iTestNGMethod);
                    object.addMethodDependedUpon(MethodHelper.calculateMethodCanonicalName(iTestNGMethod));
                }
            }
        }
    }

    private static boolean dependencyExists(ITestNGMethod iTestNGMethod, ITestNGMethod iTestNGMethod2, ITestNGMethod[] iTestNGMethodArray) {
        return MethodInheritance.internalDependencyExists(iTestNGMethod, iTestNGMethod2, iTestNGMethodArray) || MethodInheritance.internalDependencyExists(iTestNGMethod2, iTestNGMethod, iTestNGMethodArray);
    }

    private static boolean internalDependencyExists(ITestNGMethod iTestNGMethod, ITestNGMethod iTestNGMethod2, ITestNGMethod[] iTestNGMethodArray) {
        ITestNGMethod[] iTestNGMethodArray2 = MethodHelper.findDependedUponMethods(iTestNGMethod, iTestNGMethodArray);
        for (ITestNGMethod object : iTestNGMethodArray2) {
            if (!object.equals(iTestNGMethod2)) continue;
            return true;
        }
        for (String string : iTestNGMethod.getGroupsDependedUpon()) {
            ITestNGMethod[] iTestNGMethodArray3;
            for (ITestNGMethod iTestNGMethod3 : iTestNGMethodArray3 = MethodGroupsHelper.findMethodsThatBelongToGroup(iTestNGMethod, iTestNGMethodArray, string)) {
                if (!iTestNGMethod3.equals(iTestNGMethod2)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean equalsEffectiveClass(ITestNGMethod iTestNGMethod, ITestNGMethod iTestNGMethod2) {
        try {
            Class clazz = iTestNGMethod.getRealClass();
            Class clazz2 = iTestNGMethod2.getRealClass();
            return clazz == null ? clazz2 == null : clazz.equals(clazz2);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static void sortMethodsByInheritance(List<ITestNGMethod> list, boolean bl) {
        Collections.sort(list);
        if (!bl) {
            Collections.reverse(list);
        }
    }
}

