/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.testng.IResultMap;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.collections.Objects;

public class ResultMap
implements IResultMap {
    private static final long serialVersionUID = 80134376515999093L;
    private Map<ITestResult, ITestNGMethod> m_map = new ConcurrentHashMap<ITestResult, ITestNGMethod>();

    @Override
    public void addResult(ITestResult iTestResult, ITestNGMethod iTestNGMethod) {
        this.m_map.put(iTestResult, iTestNGMethod);
    }

    @Override
    public Set<ITestResult> getResults(ITestNGMethod iTestNGMethod) {
        HashSet<ITestResult> hashSet = new HashSet<ITestResult>();
        for (Map.Entry<ITestResult, ITestNGMethod> entry : this.m_map.entrySet()) {
            if (!entry.getValue().equals(iTestNGMethod)) continue;
            hashSet.add(entry.getKey());
        }
        return hashSet;
    }

    @Override
    public void removeResult(ITestNGMethod iTestNGMethod) {
        for (Map.Entry<ITestResult, ITestNGMethod> entry : this.m_map.entrySet()) {
            if (!entry.getValue().equals(iTestNGMethod)) continue;
            this.m_map.remove(entry.getKey());
            return;
        }
    }

    @Override
    public void removeResult(ITestResult iTestResult) {
        this.m_map.remove(iTestResult);
    }

    @Override
    public Set<ITestResult> getAllResults() {
        return this.m_map.keySet();
    }

    @Override
    public int size() {
        return this.m_map.size();
    }

    @Override
    public Collection<ITestNGMethod> getAllMethods() {
        return this.m_map.values();
    }

    public String toString() {
        return Objects.toStringHelper(this.getClass()).add("map", this.m_map).toString();
    }
}

