/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.testng.IAnnotationTransformer;
import org.testng.IAnnotationTransformer2;
import org.testng.IAnnotationTransformer3;
import org.testng.ITestNGMethod;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterGroups;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterSuite;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeGroups;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Configuration;
import org.testng.annotations.DataProvider;
import org.testng.annotations.ExpectedExceptions;
import org.testng.annotations.Factory;
import org.testng.annotations.IAnnotation;
import org.testng.annotations.IConfigurationAnnotation;
import org.testng.annotations.IDataProviderAnnotation;
import org.testng.annotations.IExpectedExceptionsAnnotation;
import org.testng.annotations.IFactoryAnnotation;
import org.testng.annotations.IListenersAnnotation;
import org.testng.annotations.IObjectFactoryAnnotation;
import org.testng.annotations.IParametersAnnotation;
import org.testng.annotations.ITestAnnotation;
import org.testng.annotations.Listeners;
import org.testng.annotations.ObjectFactory;
import org.testng.annotations.Optional;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.testng.annotations.TestInstance;
import org.testng.internal.ConstructorOrMethod;
import org.testng.internal.annotations.IAfterClass;
import org.testng.internal.annotations.IAfterGroups;
import org.testng.internal.annotations.IAfterMethod;
import org.testng.internal.annotations.IAfterSuite;
import org.testng.internal.annotations.IAfterTest;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.annotations.IBeforeClass;
import org.testng.internal.annotations.IBeforeGroups;
import org.testng.internal.annotations.IBeforeMethod;
import org.testng.internal.annotations.IBeforeSuite;
import org.testng.internal.annotations.IBeforeTest;
import org.testng.internal.annotations.JDK15TagFactory;
import org.testng.internal.collections.Pair;

public class JDK15AnnotationFinder
implements IAnnotationFinder {
    private JDK15TagFactory m_tagFactory = new JDK15TagFactory();
    private Map<Class<? extends IAnnotation>, Class<? extends Annotation>> m_annotationMap = new ConcurrentHashMap<Class<? extends IAnnotation>, Class<? extends Annotation>>();
    private Map<Pair<Annotation, ?>, IAnnotation> m_annotations = new ConcurrentHashMap();
    private IAnnotationTransformer m_transformer = null;

    public JDK15AnnotationFinder(IAnnotationTransformer iAnnotationTransformer) {
        this.m_transformer = iAnnotationTransformer;
        this.m_annotationMap.put(IListenersAnnotation.class, Listeners.class);
        this.m_annotationMap.put(IConfigurationAnnotation.class, Configuration.class);
        this.m_annotationMap.put(IDataProviderAnnotation.class, DataProvider.class);
        this.m_annotationMap.put(IExpectedExceptionsAnnotation.class, ExpectedExceptions.class);
        this.m_annotationMap.put(IFactoryAnnotation.class, Factory.class);
        this.m_annotationMap.put(IObjectFactoryAnnotation.class, ObjectFactory.class);
        this.m_annotationMap.put(IParametersAnnotation.class, Parameters.class);
        this.m_annotationMap.put(ITestAnnotation.class, Test.class);
        this.m_annotationMap.put(IBeforeSuite.class, BeforeSuite.class);
        this.m_annotationMap.put(IAfterSuite.class, AfterSuite.class);
        this.m_annotationMap.put(IBeforeTest.class, BeforeTest.class);
        this.m_annotationMap.put(IAfterTest.class, AfterTest.class);
        this.m_annotationMap.put(IBeforeClass.class, BeforeClass.class);
        this.m_annotationMap.put(IAfterClass.class, AfterClass.class);
        this.m_annotationMap.put(IBeforeGroups.class, BeforeGroups.class);
        this.m_annotationMap.put(IAfterGroups.class, AfterGroups.class);
        this.m_annotationMap.put(IBeforeMethod.class, BeforeMethod.class);
        this.m_annotationMap.put(IAfterMethod.class, AfterMethod.class);
    }

    private <A extends Annotation> A findAnnotationInSuperClasses(Class<?> clazz, Class<A> clazz2) {
        if (clazz2.equals(Listeners.class)) {
            return clazz.getAnnotation(clazz2);
        }
        while (clazz != null) {
            A a = clazz.getAnnotation(clazz2);
            if (a != null) {
                return a;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    @Override
    public <A extends IAnnotation> A findAnnotation(Method method, Class<A> clazz) {
        Class<? extends Annotation> clazz2 = this.m_annotationMap.get(clazz);
        if (clazz2 == null) {
            throw new IllegalArgumentException("Java @Annotation class for '" + clazz + "' not found.");
        }
        Annotation annotation = method.getAnnotation(clazz2);
        return this.findAnnotation(method.getDeclaringClass(), annotation, clazz, null, null, method, new Pair<Annotation, Method>(annotation, method));
    }

    @Override
    public <A extends IAnnotation> A findAnnotation(ITestNGMethod iTestNGMethod, Class<A> clazz) {
        Class<? extends Annotation> clazz2 = this.m_annotationMap.get(clazz);
        if (clazz2 == null) {
            throw new IllegalArgumentException("Java @Annotation class for '" + clazz + "' not found.");
        }
        Method method = iTestNGMethod.getMethod();
        Class<?> clazz3 = iTestNGMethod.getInstance() == null ? method.getDeclaringClass() : iTestNGMethod.getInstance().getClass();
        Annotation annotation = method.getAnnotation(clazz2);
        if (annotation == null) {
            annotation = clazz3.getAnnotation(clazz2);
        }
        return this.findAnnotation(clazz3, annotation, clazz, null, null, method, new Pair<Annotation, Method>(annotation, method));
    }

    @Override
    public <A extends IAnnotation> A findAnnotation(ConstructorOrMethod constructorOrMethod, Class<A> clazz) {
        if (constructorOrMethod.getConstructor() != null) {
            return this.findAnnotation(constructorOrMethod.getConstructor(), clazz);
        }
        if (constructorOrMethod.getMethod() != null) {
            return this.findAnnotation(constructorOrMethod.getMethod(), clazz);
        }
        return null;
    }

    private void transform(IAnnotation iAnnotation, Class<?> clazz, Constructor<?> constructor, Method method) {
        if (iAnnotation instanceof ITestAnnotation) {
            this.m_transformer.transform((ITestAnnotation)iAnnotation, clazz, constructor, method);
        } else if (this.m_transformer instanceof IAnnotationTransformer2) {
            IAnnotationTransformer2 iAnnotationTransformer2 = (IAnnotationTransformer2)this.m_transformer;
            if (iAnnotation instanceof IConfigurationAnnotation) {
                IConfigurationAnnotation iConfigurationAnnotation = (IConfigurationAnnotation)iAnnotation;
                iAnnotationTransformer2.transform(iConfigurationAnnotation, clazz, constructor, method);
            } else if (iAnnotation instanceof IDataProviderAnnotation) {
                iAnnotationTransformer2.transform((IDataProviderAnnotation)iAnnotation, method);
            } else if (iAnnotation instanceof IFactoryAnnotation) {
                iAnnotationTransformer2.transform((IFactoryAnnotation)iAnnotation, method);
            } else if (this.m_transformer instanceof IAnnotationTransformer3) {
                IAnnotationTransformer3 iAnnotationTransformer3 = (IAnnotationTransformer3)this.m_transformer;
                if (iAnnotation instanceof IListenersAnnotation) {
                    iAnnotationTransformer3.transform((IListenersAnnotation)iAnnotation, clazz);
                }
            }
        }
    }

    @Override
    public <A extends IAnnotation> A findAnnotation(Class<?> clazz, Class<A> clazz2) {
        Class<? extends Annotation> clazz3 = this.m_annotationMap.get(clazz2);
        if (clazz3 == null) {
            throw new IllegalArgumentException("Java @Annotation class for '" + clazz2 + "' not found.");
        }
        Annotation annotation = this.findAnnotationInSuperClasses(clazz, clazz3);
        return this.findAnnotation(clazz, annotation, clazz2, clazz, null, null, new Pair<Annotation, Class<A>>(annotation, clazz2));
    }

    @Override
    public <A extends IAnnotation> A findAnnotation(Constructor<?> constructor, Class<A> clazz) {
        Class<? extends Annotation> clazz2 = this.m_annotationMap.get(clazz);
        if (clazz2 == null) {
            throw new IllegalArgumentException("Java @Annotation class for '" + clazz + "' not found.");
        }
        Annotation annotation = constructor.getAnnotation(clazz2);
        return this.findAnnotation(constructor.getDeclaringClass(), annotation, clazz, null, constructor, null, new Pair(annotation, constructor));
    }

    private <A extends IAnnotation> A findAnnotation(Class clazz, Annotation annotation, Class<A> clazz2, Class<?> clazz3, Constructor<?> constructor, Method method, Pair<Annotation, ?> pair) {
        if (annotation == null) {
            return null;
        }
        IAnnotation iAnnotation = this.m_annotations.get(pair);
        if (iAnnotation == null) {
            iAnnotation = this.m_tagFactory.createTag(clazz, method, annotation, clazz2, this.m_transformer);
            this.m_annotations.put(pair, iAnnotation);
            this.transform(iAnnotation, clazz3, constructor, method);
        }
        return (A)iAnnotation;
    }

    @Override
    public boolean hasTestInstance(Method method, int n) {
        Annotation[][] annotationArray = method.getParameterAnnotations();
        if (annotationArray.length > 0 && annotationArray[n].length > 0) {
            Annotation[] annotationArray2;
            for (Annotation annotation : annotationArray2 = annotationArray[n]) {
                if (!(annotation instanceof TestInstance)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String[] findOptionalValues(Method method) {
        return this.optionalValues(method.getParameterAnnotations());
    }

    @Override
    public String[] findOptionalValues(Constructor constructor) {
        return this.optionalValues(constructor.getParameterAnnotations());
    }

    private String[] optionalValues(Annotation[][] annotationArray) {
        String[] stringArray = new String[annotationArray.length];
        block0: for (int i = 0; i < annotationArray.length; ++i) {
            for (Annotation annotation : annotationArray[i]) {
                if (!(annotation instanceof Optional)) continue;
                stringArray[i] = ((Optional)annotation).value();
                continue block0;
            }
        }
        return stringArray;
    }
}

