/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.util.Collection;
import java.util.Map;
import org.testng.ISuite;
import org.testng.ISuiteResult;
import org.testng.ITestContext;
import org.testng.internal.SuiteRunnerMap;
import org.testng.xml.XmlSuite;

class SuiteResultCounts {
    int m_total = 0;
    int m_skipped = 0;
    int m_failed = 0;
    int m_confFailures = 0;
    int m_confSkips = 0;

    SuiteResultCounts() {
    }

    public void calculateResultCounts(XmlSuite xmlSuite, SuiteRunnerMap suiteRunnerMap) {
        Map<String, ISuiteResult> map;
        ISuite iSuite = suiteRunnerMap.get(xmlSuite);
        if (iSuite != null && (map = iSuite.getResults()) != null) {
            Collection<ISuiteResult> collection = map.values();
            for (ISuiteResult serializable : collection) {
                ITestContext iTestContext = serializable.getTestContext();
                int n = iTestContext.getSkippedTests().size();
                int n2 = iTestContext.getFailedTests().size() + iTestContext.getFailedButWithinSuccessPercentageTests().size();
                this.m_skipped += n;
                this.m_failed += n2;
                this.m_confFailures += iTestContext.getFailedConfigurations().size();
                this.m_confSkips += iTestContext.getSkippedConfigurations().size();
                this.m_total += iTestContext.getPassedTests().size() + n2 + n;
            }
            for (XmlSuite xmlSuite2 : xmlSuite.getChildSuites()) {
                this.calculateResultCounts(xmlSuite2, suiteRunnerMap);
            }
        }
    }
}

