/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.TestNGException;
import org.testng.annotations.NoInjection;
import org.testng.internal.reflect.InjectableParameter;
import org.testng.internal.reflect.Parameter;
import org.testng.xml.XmlTest;

public final class ReflectionRecipes {
    private static final Map<Class, Class> PRIMITIVE_MAPPING = new HashMap<Class, Class>();

    private ReflectionRecipes() {
        throw new TestNGException("Service is not meant to have instances");
    }

    public static boolean isInstanceOf(Class clazz, Object object) {
        if (object == null) {
            return !clazz.isPrimitive();
        }
        boolean bl = false;
        boolean bl2 = clazz.isInstance(object);
        bl = !bl2 && clazz.isPrimitive() ? PRIMITIVE_MAPPING.get(clazz).isInstance(object) : bl2;
        return bl;
    }

    public static boolean isOrImplementsInterface(Class<?> clazz, Class<?> clazz2) {
        boolean bl = false;
        if (clazz.isInterface()) {
            if (clazz.equals(clazz2)) {
                bl = true;
            } else {
                Class<?> clazz3;
                Class<?>[] classArray;
                Class<?>[] classArray2 = classArray = clazz2.getInterfaces();
                int n = classArray2.length;
                for (int i = 0; i < n && !(bl = (clazz3 = classArray2[i]).equals(clazz)); ++i) {
                }
            }
        }
        return bl;
    }

    public static boolean isOrExtends(Class<?> clazz, Class<?> clazz2) {
        boolean bl = false;
        if (clazz2 != null && !clazz.isInterface()) {
            bl = clazz.equals(clazz2) ? true : ReflectionRecipes.isOrExtends(clazz, clazz2.getSuperclass());
        }
        return bl;
    }

    public static Class<?>[] classesFromParameters(Parameter[] parameterArray) {
        Class[] classArray = new Class[parameterArray.length];
        int n = 0;
        for (Parameter parameter : parameterArray) {
            classArray[n] = parameter.getType();
            ++n;
        }
        return classArray;
    }

    public static Parameter[] getMethodParameters(Method method) {
        if (method != null) {
            Class<?>[] classArray = method.getParameterTypes();
            Annotation[][] annotationArray = method.getParameterAnnotations();
            Parameter[] parameterArray = new Parameter[classArray.length];
            for (int i = 0; i < classArray.length; ++i) {
                parameterArray[i] = new Parameter(i, classArray[i], annotationArray[i]);
            }
            return parameterArray;
        }
        return null;
    }

    public static boolean matchArrayEnding(Parameter[] parameterArray, Object[] objectArray) {
        return ReflectionRecipes.matchArrayEnding(ReflectionRecipes.classesFromParameters(parameterArray), objectArray);
    }

    public static boolean matchArrayEnding(Class<?>[] classArray, Object[] objectArray) {
        if (classArray.length < 1) {
            return false;
        }
        if (!classArray[classArray.length - 1].isArray()) {
            return false;
        }
        boolean bl = true;
        int n = 0;
        if (classArray.length <= objectArray.length) {
            for (Class<?> clazz : classArray) {
                if (n >= classArray.length - 1) break;
                bl = ReflectionRecipes.isInstanceOf(clazz, objectArray[n]);
                ++n;
                if (bl) {
                    continue;
                }
                break;
            }
        } else {
            bl = false;
        }
        if (bl) {
            Class<?> clazz = classArray[classArray.length - 1].getComponentType();
            while (n < objectArray.length && (bl = ReflectionRecipes.isInstanceOf(clazz, objectArray[n]))) {
                ++n;
            }
        }
        return bl;
    }

    public static boolean exactMatch(Parameter[] parameterArray, Object[] objectArray) {
        return ReflectionRecipes.exactMatch(ReflectionRecipes.classesFromParameters(parameterArray), objectArray);
    }

    public static boolean exactMatch(Class<?>[] classArray, Object[] objectArray) {
        boolean bl = true;
        if (classArray.length == objectArray.length) {
            int n = 0;
            for (Class<?> clazz : classArray) {
                bl = ReflectionRecipes.isInstanceOf(clazz, objectArray[n]);
                ++n;
                if (bl) {
                    continue;
                }
                break;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public static boolean lenientMatch(Parameter[] parameterArray, Object[] objectArray) {
        return ReflectionRecipes.lenientMatch(ReflectionRecipes.classesFromParameters(parameterArray), objectArray);
    }

    public static boolean lenientMatch(Class<?>[] classArray, Object[] objectArray) {
        boolean bl = true;
        int n = 0;
        for (Class<?> clazz : classArray) {
            bl = ReflectionRecipes.isInstanceOf(clazz, objectArray[n]);
            ++n;
            if (!bl) break;
        }
        return bl;
    }

    public static Parameter[] filter(Parameter[] parameterArray, Set<InjectableParameter> set) {
        if (set != null && !set.isEmpty()) {
            boolean bl = false;
            ArrayList<Parameter> arrayList = new ArrayList<Parameter>(parameterArray.length);
            for (Parameter parameter : parameterArray) {
                boolean bl2 = false;
                for (InjectableParameter injectableParameter : set) {
                    bl2 = ReflectionRecipes.canInject(parameter, injectableParameter);
                    switch (injectableParameter) {
                        case CURRENT_TEST_METHOD: {
                            if (bl2 && !bl) {
                                bl = true;
                                break;
                            }
                            bl2 = false;
                            break;
                        }
                    }
                    if (!bl2) continue;
                    break;
                }
                if (bl2) continue;
                arrayList.add(parameter);
            }
            Parameter[] parameterArray2 = new Parameter[arrayList.size()];
            return arrayList.toArray(parameterArray2);
        }
        return parameterArray;
    }

    public static Object[] inject(Parameter[] parameterArray, Set<InjectableParameter> set, Object[] objectArray, Method method, ITestContext iTestContext, ITestResult iTestResult) {
        if (set != null && !set.isEmpty()) {
            ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
            ListBackedImmutableQueue<Object> listBackedImmutableQueue = new ListBackedImmutableQueue<Object>(objectArray);
            boolean bl = false;
            for (Parameter parameter : parameterArray) {
                boolean bl2 = false;
                Object object = null;
                for (InjectableParameter injectableParameter : set) {
                    bl2 = ReflectionRecipes.canInject(parameter, injectableParameter);
                    switch (injectableParameter) {
                        case CURRENT_TEST_METHOD: {
                            object = method;
                            if (bl2 && !bl) {
                                bl = true;
                                break;
                            }
                            bl2 = false;
                            break;
                        }
                        case ITEST_CONTEXT: {
                            object = iTestContext;
                            break;
                        }
                        case ITEST_RESULT: {
                            object = iTestResult;
                            break;
                        }
                        case XML_TEST: {
                            object = iTestContext != null ? iTestContext.getCurrentXmlTest() : null;
                            break;
                        }
                    }
                    if (!bl2) continue;
                    arrayList.add(object);
                    break;
                }
                if (bl2) continue;
                arrayList.add(listBackedImmutableQueue.poll());
            }
            Object[] objectArray2 = new Object[arrayList.size()];
            return arrayList.toArray(objectArray2);
        }
        return objectArray;
    }

    private static boolean canInject(Parameter parameter, InjectableParameter injectableParameter) {
        boolean bl = false;
        if (parameter != null && injectableParameter != null) {
            boolean bl2 = !parameter.isAnnotationPresent(NoInjection.class);
            switch (injectableParameter) {
                case CURRENT_TEST_METHOD: {
                    boolean bl3 = ReflectionRecipes.isOrExtends(Method.class, parameter.getType());
                    bl = bl2 && bl3;
                    break;
                }
                case ITEST_CONTEXT: {
                    bl = bl2 && ReflectionRecipes.isOrImplementsInterface(ITestContext.class, parameter.getType());
                    break;
                }
                case ITEST_RESULT: {
                    bl = bl2 && ReflectionRecipes.isOrImplementsInterface(ITestResult.class, parameter.getType());
                    break;
                }
                case XML_TEST: {
                    bl = bl2 && ReflectionRecipes.isOrExtends(XmlTest.class, parameter.getType());
                    break;
                }
                default: {
                    bl = false;
                }
            }
        }
        return bl;
    }

    static {
        PRIMITIVE_MAPPING.put(Boolean.TYPE, Boolean.class);
        PRIMITIVE_MAPPING.put(Byte.TYPE, Byte.class);
        PRIMITIVE_MAPPING.put(Short.TYPE, Short.class);
        PRIMITIVE_MAPPING.put(Integer.TYPE, Integer.class);
        PRIMITIVE_MAPPING.put(Long.TYPE, Long.class);
        PRIMITIVE_MAPPING.put(Float.TYPE, Float.class);
        PRIMITIVE_MAPPING.put(Double.TYPE, Double.class);
        PRIMITIVE_MAPPING.put(Character.TYPE, Character.class);
        PRIMITIVE_MAPPING.put(Void.TYPE, Void.class);
    }

    private static class ListBackedImmutableQueue<T> {
        private final List<T> backingList;

        public ListBackedImmutableQueue(T[] TArray) {
            this.backingList = new ArrayList<T>(TArray.length);
            for (int i = 0; i < TArray.length; ++i) {
                this.backingList.add(TArray[i]);
            }
        }

        public T poll() {
            if (!this.backingList.isEmpty()) {
                return this.backingList.remove(0);
            }
            throw new TestNGException("Queue exhausted");
        }
    }
}

