/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.testng.IInvokedMethod;
import org.testng.IReporter;
import org.testng.ISuite;
import org.testng.ISuiteResult;
import org.testng.ITestClass;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.Reporter;
import org.testng.collections.Maps;
import org.testng.internal.Utils;
import org.testng.reporters.HtmlHelper;
import org.testng.xml.XmlSuite;

public class SuiteHTMLReporter
implements IReporter {
    public static final String METHODS_CHRONOLOGICAL = "methods.html";
    public static final String METHODS_ALPHABETICAL = "methods-alphabetical.html";
    public static final String GROUPS = "groups.html";
    public static final String CLASSES = "classes.html";
    public static final String REPORTER_OUTPUT = "reporter-output.html";
    public static final String METHODS_NOT_RUN = "methods-not-run.html";
    public static final String TESTNG_XML = "testng.xml.html";
    private Map<String, ITestClass> m_classes = Maps.newHashMap();
    private String m_outputDirectory;
    private static final String SP = "&nbsp;";
    private static final String SP2 = "&nbsp;&nbsp;&nbsp;&nbsp;";
    private static final String SP3 = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
    private static final String SP4 = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
    public static final String AFTER = "&lt;&lt;";
    public static final String BEFORE = "&gt;&gt;";

    @Override
    public void generateReport(List<XmlSuite> list, List<ISuite> list2, String string) {
        this.m_outputDirectory = this.generateOutputDirectoryName(string + File.separator + "old");
        try {
            HtmlHelper.generateStylesheet(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        for (ISuite iSuite : list2) {
            XmlSuite xmlSuite = iSuite.getXmlSuite();
            if (xmlSuite.getTests().size() == 0) continue;
            this.generateTableOfContents(xmlSuite, iSuite);
            this.generateSuites(xmlSuite, iSuite);
            this.generateIndex(xmlSuite, iSuite);
            this.generateMain(xmlSuite, iSuite);
            this.generateMethodsAndGroups(xmlSuite, iSuite);
            this.generateMethodsChronologically(xmlSuite, iSuite, METHODS_CHRONOLOGICAL, false);
            this.generateMethodsChronologically(xmlSuite, iSuite, METHODS_ALPHABETICAL, true);
            this.generateClasses(xmlSuite, iSuite);
            this.generateReporterOutput(xmlSuite, iSuite);
            this.generateExcludedMethodsReport(xmlSuite, iSuite);
            this.generateXmlFile(xmlSuite, iSuite);
        }
        this.generateIndex(list2);
    }

    protected String generateOutputDirectoryName(String string) {
        return string;
    }

    private void generateXmlFile(XmlSuite xmlSuite, ISuite iSuite) {
        String string = xmlSuite.toXml().replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll(" ", SP).replaceAll("\n", "<br/>");
        StringBuffer stringBuffer = new StringBuffer("<html>");
        stringBuffer.append("<head><title>").append("testng.xml for ").append(xmlSuite.getName()).append("</title></head><body><tt>").append(string).append("</tt></body></html>");
        Utils.writeFile(this.getOutputDirectory(xmlSuite), TESTNG_XML, stringBuffer.toString());
    }

    private void generateIndex(List<ISuite> list) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "Test results";
        stringBuffer.append("<html>\n<head><title>" + string + "</title>").append(HtmlHelper.getCssString(".")).append("</head><body>\n").append("<h2><p align='center'>").append(string).append("</p></h2>\n").append("<table border='1' width='100%' class='main-page'>").append("<tr><th>Suite</th><th>Passed</th><th>Failed</th><th>Skipped</th><th>testng.xml</th></tr>\n");
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        StringBuffer stringBuffer2 = new StringBuffer();
        for (ISuite iSuite : list) {
            if (iSuite.getResults().size() == 0) continue;
            String string2 = iSuite.getName();
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            Map<String, ISuiteResult> map = iSuite.getResults();
            for (ISuiteResult iSuiteResult : map.values()) {
                ITestContext iTestContext = iSuiteResult.getTestContext();
                n4 += iTestContext.getFailedTests().size();
                n += iTestContext.getFailedTests().size();
                n5 += iTestContext.getPassedTests().size();
                n2 += iTestContext.getPassedTests().size();
                n6 += iTestContext.getSkippedTests().size();
                n3 += iTestContext.getSkippedTests().size();
            }
            String string3 = n4 > 0 ? "invocation-failed" : (n5 > 0 ? "invocation-passed" : "invocation-failed");
            stringBuffer2.append("<tr align='center' class='").append(string3).append("'>").append("<td><a href='").append(string2).append("/index.html'>").append(string2).append("</a></td>\n");
            stringBuffer2.append("<td>" + n5 + "</td>").append("<td>" + n4 + "</td>").append("<td>" + n6 + "</td>").append("<td><a href='").append(string2).append("/").append(TESTNG_XML).append("'>Link").append("</a></td>").append("</tr>");
        }
        String string4 = n > 0 ? "invocation-failed" : (n2 > 0 ? "invocation-passed" : "invocation-failed");
        stringBuffer.append("<tr align='center' class='").append(string4).append("'>").append("<td><em>Total</em></td>").append("<td><em>").append(n2).append("</em></td>").append("<td><em>").append(n).append("</em></td>").append("<td><em>").append(n3).append("</em></td>").append("<td>&nbsp;</td>").append("</tr>\n");
        stringBuffer.append(stringBuffer2);
        stringBuffer.append("</table>").append("</body></html>\n");
        Utils.writeFile(this.m_outputDirectory, "index.html", stringBuffer.toString());
    }

    private void generateExcludedMethodsReport(XmlSuite xmlSuite, ISuite iSuite) {
        Collection<ITestNGMethod> collection = iSuite.getExcludedMethods();
        StringBuffer stringBuffer = new StringBuffer("<h2>Methods that were not run</h2><table>\n");
        for (ITestNGMethod iTestNGMethod : collection) {
            Method method = iTestNGMethod.getMethod();
            if (method == null) continue;
            stringBuffer.append("<tr><td>").append(method.getDeclaringClass().getName() + "." + method.getName());
            String string = iTestNGMethod.getDescription();
            if (Utils.isStringNotEmpty(string)) {
                stringBuffer.append("<br/>").append(SP2).append("<i>").append(string).append("</i>");
            }
            stringBuffer.append("</td></tr>\n");
        }
        stringBuffer.append("</table>");
        Utils.writeFile(this.getOutputDirectory(xmlSuite), METHODS_NOT_RUN, stringBuffer.toString());
    }

    private void generateReporterOutput(XmlSuite xmlSuite, ISuite iSuite) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<h2>Reporter output</h2>").append("<table>");
        List<String> list = Reporter.getOutput();
        for (String string : list) {
            stringBuffer.append("<tr><td>").append(string).append("</td></tr>\n");
        }
        stringBuffer.append("</table>");
        Utils.writeFile(this.getOutputDirectory(xmlSuite), REPORTER_OUTPUT, stringBuffer.toString());
    }

    private void generateClasses(XmlSuite xmlSuite, ISuite iSuite) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<table border='1'>\n").append("<tr>\n").append("<th>Class name</th>\n").append("<th>Method name</th>\n").append("<th>Groups</th>\n").append("</tr>");
        for (ITestClass iTestClass : this.m_classes.values()) {
            stringBuffer.append(this.generateClass(iTestClass));
        }
        stringBuffer.append("</table>\n");
        Utils.writeFile(this.getOutputDirectory(xmlSuite), CLASSES, stringBuffer.toString());
    }

    private String generateClass(ITestClass iTestClass) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<tr>\n").append("<td>").append(iTestClass.getRealClass().getName()).append("</td>\n").append("<td>&nbsp;</td>").append("<td>&nbsp;</td>").append("</tr>\n");
        String[] stringArray = new String[]{"@Test", "@BeforeClass", "@BeforeMethod", "@AfterMethod", "@AfterClass"};
        ITestNGMethod[][] iTestNGMethodArrayArray = new ITestNGMethod[][]{iTestClass.getTestMethods(), iTestClass.getBeforeClassMethods(), iTestClass.getBeforeTestMethods(), iTestClass.getAfterTestMethods(), iTestClass.getAfterClassMethods()};
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append("<tr>\n").append("<td align='center' colspan='3'>").append(stringArray[i]).append("</td>\n").append("</tr>\n").append(this.dumpMethods(iTestNGMethodArrayArray[i]));
        }
        String string = stringBuffer.toString();
        return string;
    }

    private String dumpMethods(ITestNGMethod[] iTestNGMethodArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (null == iTestNGMethodArray || iTestNGMethodArray.length == 0) {
            return "";
        }
        for (ITestNGMethod iTestNGMethod : iTestNGMethodArray) {
            stringBuffer.append("<tr>\n");
            stringBuffer.append("<td>&nbsp;</td>\n").append("<td>").append(iTestNGMethod.getMethodName()).append("</td>\n");
            String[] stringArray = iTestNGMethod.getGroups();
            if (stringArray != null && stringArray.length > 0) {
                stringBuffer.append("<td>");
                for (String string : stringArray) {
                    stringBuffer.append(string).append(" ");
                }
                stringBuffer.append("</td>\n");
            } else {
                stringBuffer.append("<td>&nbsp;</td>");
            }
            stringBuffer.append("</tr>\n");
        }
        String string = stringBuffer.toString();
        return string;
    }

    private String dumpGroups(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (null != stringArray && stringArray.length > 0) {
            stringBuffer.append(SP4).append("<em>[");
            for (String string : stringArray) {
                stringBuffer.append(string).append(" ");
            }
            stringBuffer.append("]</em><br/>\n");
        }
        String[] stringArray2 = stringBuffer.toString();
        return stringArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateMethodsChronologically(XmlSuite xmlSuite, ISuite iSuite, String string, boolean bl) {
        try (BufferedWriter bufferedWriter = Utils.openWriter(this.getOutputDirectory(xmlSuite), string);){
            Object object;
            bufferedWriter.append("<h2>Methods run, sorted chronologically</h2>");
            bufferedWriter.append("<h3>&gt;&gt; means before, &lt;&lt; means after</h3><p/>");
            long l = -1L;
            bufferedWriter.append("<br/><em>").append(iSuite.getName()).append("</em><p/>");
            bufferedWriter.append("<small><i>(Hover the method name to see the test class name)</i></small><p/>\n");
            List<IInvokedMethod> list = iSuite.getAllInvokedMethods();
            if (bl) {
                object = new Comparator(){

                    public int compare(Object object, Object object2) {
                        IInvokedMethod iInvokedMethod = (IInvokedMethod)object;
                        IInvokedMethod iInvokedMethod2 = (IInvokedMethod)object2;
                        return iInvokedMethod.getTestMethod().getMethodName().compareTo(iInvokedMethod2.getTestMethod().getMethodName());
                    }
                };
                Collections.sort(list, object);
            }
            object = new SimpleDateFormat("yy/MM/dd HH:mm:ss");
            boolean bl2 = false;
            List<IInvokedMethod> list2 = list;
            synchronized (list2) {
                for (IInvokedMethod iInvokedMethod : list) {
                    String string2;
                    String string3;
                    String string4;
                    String string5;
                    boolean bl3;
                    ITestNGMethod iTestNGMethod = iInvokedMethod.getTestMethod();
                    if (!bl2) {
                        bufferedWriter.append("<table border=\"1\">\n").append("<tr>").append("<th>Time</th>").append("<th>Delta (ms)</th>").append("<th>Suite<br>configuration</th>").append("<th>Test<br>configuration</th>").append("<th>Class<br>configuration</th>").append("<th>Groups<br>configuration</th>").append("<th>Method<br>configuration</th>").append("<th>Test<br>method</th>").append("<th>Thread</th>").append("<th>Instances</th>").append("</tr>\n");
                        bl2 = true;
                    }
                    String string6 = iTestNGMethod.toString();
                    boolean bl4 = iTestNGMethod.isBeforeClassConfiguration();
                    boolean bl5 = iTestNGMethod.isAfterClassConfiguration();
                    boolean bl6 = iTestNGMethod.isBeforeTestConfiguration();
                    boolean bl7 = iTestNGMethod.isAfterTestConfiguration();
                    boolean bl8 = iTestNGMethod.isBeforeSuiteConfiguration();
                    boolean bl9 = iTestNGMethod.isAfterSuiteConfiguration();
                    boolean bl10 = iTestNGMethod.isBeforeGroupsConfiguration();
                    boolean bl11 = iTestNGMethod.isAfterGroupsConfiguration();
                    boolean bl12 = iTestNGMethod.isBeforeMethodConfiguration();
                    boolean bl13 = iTestNGMethod.isAfterMethodConfiguration();
                    boolean bl14 = bl4 || bl5;
                    boolean bl15 = bl10 || bl11;
                    boolean bl16 = bl6 || bl7;
                    boolean bl17 = bl8 || bl9;
                    boolean bl18 = bl3 = bl12 || bl13;
                    String string7 = bl14 ? (bl4 ? BEFORE : AFTER) + string6 : (string5 = SP);
                    String string8 = bl16 ? (bl6 ? BEFORE : AFTER) + string6 : (string4 = SP);
                    String string9 = bl15 ? (bl10 ? BEFORE : AFTER) + string6 : (string3 = SP);
                    String string10 = bl17 ? (bl8 ? BEFORE : AFTER) + string6 : (string2 = SP);
                    String string11 = bl3 ? (bl12 ? BEFORE : AFTER) + string6 : SP;
                    String string12 = iTestNGMethod.isTest() ? string6 : SP;
                    StringBuffer stringBuffer = new StringBuffer();
                    for (long l2 : iTestNGMethod.getInstanceHashCodes()) {
                        stringBuffer.append(l2).append(" ");
                    }
                    if (l == -1L) {
                        l = iInvokedMethod.getDate();
                    }
                    String object2 = ((Format)object).format(iInvokedMethod.getDate());
                    bufferedWriter.append("<tr bgcolor=\"" + this.createColor(iTestNGMethod) + "\">").append("  <td>").append(object2).append("</td> ").append("  <td>").append(Long.toString(iInvokedMethod.getDate() - l)).append("</td> ").append(this.td(string2)).append(this.td(string4)).append(this.td(string5)).append(this.td(string3)).append(this.td(string11)).append(this.td(string12)).append("  <td>").append(iTestNGMethod.getId()).append("</td> ").append("  <td>").append(stringBuffer).append("</td> ").append("</tr>\n");
                }
            }
            bufferedWriter.append("</table>\n");
        }
        catch (IOException iOException) {
            Utils.log("[SuiteHTMLReporter]", 1, "Error writing to " + string + ": " + iOException.getMessage());
        }
    }

    private String createColor(ITestNGMethod iTestNGMethod) {
        long l = iTestNGMethod.getRealClass() != null ? (long)(iTestNGMethod.getRealClass().hashCode() & 0xFFFFFF) : 0xFFFFFFL;
        long[] lArray = new long[]{(l & 0xFF0000L) >> 16 & 0xFFL, (l & 0xFF00L) >> 8 & 0xFFL, l & 0xFFL};
        for (int i = 0; i < lArray.length; ++i) {
            if (lArray[i] >= 96L) continue;
            int n = i;
            lArray[n] = lArray[n] + 96L;
        }
        long l2 = lArray[0] << 16 | lArray[1] << 8 | lArray[2];
        String string = Long.toHexString(l2);
        return string;
    }

    private String td(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "";
        if (string.startsWith(BEFORE)) {
            string2 = BEFORE;
        } else if (string.startsWith(AFTER)) {
            string2 = AFTER;
        }
        if (!string.equals(SP)) {
            stringBuffer.append("<td title=\"").append(string).append("\">");
            int n = string.lastIndexOf("(");
            int n2 = string.substring(0, n).lastIndexOf(".");
            if (n2 >= 0) {
                stringBuffer.append(string2 + string.substring(n2 + 1, n));
            } else {
                stringBuffer.append(string2 + string);
            }
            stringBuffer.append("</td> \n");
        } else {
            stringBuffer.append("<td>").append(SP).append("</td>");
        }
        return stringBuffer.toString();
    }

    private void ppp(String string) {
        System.out.println("[SuiteHTMLReporter] " + string);
    }

    private void generateMethodsAndGroups(XmlSuite xmlSuite, ISuite iSuite) {
        StringBuffer stringBuffer = new StringBuffer();
        Map<String, Collection<ITestNGMethod>> map = iSuite.getMethodsByGroups();
        stringBuffer.append("<h2>Groups used for this test run</h2>");
        if (map.size() > 0) {
            stringBuffer.append("<table border=\"1\">\n").append("<tr> <td align=\"center\"><b>Group name</b></td>").append("<td align=\"center\"><b>Methods</b></td></tr>");
            Object[] objectArray = map.keySet().toArray(new String[map.size()]);
            Arrays.sort(objectArray);
            for (Object object : objectArray) {
                Collection<ITestNGMethod> collection = map.get(object);
                stringBuffer.append("<tr><td>").append((String)object).append("</td>");
                StringBuffer stringBuffer2 = new StringBuffer();
                Map<ITestNGMethod, ITestNGMethod> map2 = Maps.newHashMap();
                for (ITestNGMethod iTestNGMethod : collection) {
                    map2.put(iTestNGMethod, iTestNGMethod);
                }
                for (ITestNGMethod iTestNGMethod : map2.values()) {
                    stringBuffer2.append(iTestNGMethod.toString()).append("<br/>");
                }
                stringBuffer.append("<td>" + stringBuffer2.toString() + "</td></tr>\n");
            }
            stringBuffer.append("</table>\n");
        }
        Utils.writeFile(this.getOutputDirectory(xmlSuite), GROUPS, stringBuffer.toString());
    }

    private void generateIndex(XmlSuite xmlSuite, ISuite iSuite) {
        StringBuffer stringBuffer = new StringBuffer().append("<html><head><title>Results for " + iSuite.getName() + "</title></head>\n").append("<frameset cols=\"26%,74%\">\n").append("<frame src=\"toc.html\" name=\"navFrame\">\n").append("<frame src=\"main.html\" name=\"mainFrame\">\n").append("</frameset>\n").append("</html>\n");
        Utils.writeFile(this.getOutputDirectory(xmlSuite), "index.html", stringBuffer.toString());
    }

    private String makeTitle(ISuite iSuite) {
        return "Results for<br/><em>" + iSuite.getName() + "</em>";
    }

    private void generateMain(XmlSuite xmlSuite, ISuite iSuite) {
        StringBuffer stringBuffer = new StringBuffer().append("<html><head><title>Results for " + iSuite.getName() + "</title></head>\n").append("<body>Select a result on the left-hand pane.</body>").append("</html>\n");
        Utils.writeFile(this.getOutputDirectory(xmlSuite), "main.html", stringBuffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateTableOfContents(XmlSuite xmlSuite, ISuite iSuite) {
        Serializable serializable;
        ISuiteResult[] iSuiteResultArray2;
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        Map<String, ISuiteResult> map = iSuite.getResults();
        int n = iSuite.getMethodsByGroups().size();
        int n2 = 0;
        Object object5 = map;
        synchronized (object5) {
            for (ISuiteResult object42 : map.values()) {
                object = object42.getTestContext().getAllTestMethods();
                n2 += Utils.calculateInvokedMethodCount((ITestNGMethod[])object);
                for (ISuiteResult[] iSuiteResultArray2 : object) {
                    serializable = iSuiteResultArray2.getTestClass();
                    this.m_classes.put(serializable.getRealClass().getName(), (ITestClass)serializable);
                }
            }
        }
        object5 = "Results for " + iSuite.getName();
        stringBuffer.append("<html>\n").append("<head>\n").append("<title>" + (String)object5 + "</title>\n").append(HtmlHelper.getCssString()).append("</head>\n");
        stringBuffer.append("<body>\n").append("<h3><p align=\"center\">" + this.makeTitle(iSuite) + "</p></h3>\n").append("<table border='1' width='100%'>\n").append("<tr valign='top'>\n").append("<td>").append(map.size()).append(" ").append(this.pluralize(map.size(), "test")).append("</td>\n").append("<td>").append("<a target='mainFrame' href='").append(CLASSES).append("'>").append(this.m_classes.size() + " " + this.pluralize(this.m_classes.size(), "class")).append("</a>").append("</td>\n").append("<td>" + n2 + " " + this.pluralize(n2, "method") + ":<br/>\n").append("&nbsp;&nbsp;<a target='mainFrame' href='").append(METHODS_CHRONOLOGICAL).append("'>").append("chronological</a><br/>\n").append("&nbsp;&nbsp;<a target='mainFrame' href='").append(METHODS_ALPHABETICAL).append("'>").append("alphabetical</a><br/>\n").append("&nbsp;&nbsp;<a target='mainFrame' href='").append(METHODS_NOT_RUN).append("'>not run (" + iSuite.getExcludedMethods().size() + ")</a>").append("</td>\n").append("</tr>\n").append("<tr>\n").append("<td><a target='mainFrame' href='").append(GROUPS).append("'>").append(n + this.pluralize(n, " group") + "</a></td>\n").append("<td><a target='mainFrame' href='").append(REPORTER_OUTPUT).append("'>reporter output</a></td>\n").append("<td><a target='mainFrame' href='").append(TESTNG_XML).append("'>testng.xml</a></td>\n").append("</tr>").append("</table>");
        Map map2 = Maps.newHashMap();
        Map<ISuiteResult[], Serializable> map3 = Maps.newHashMap();
        object = Maps.newHashMap();
        Map<String, ISuiteResult> map4 = map;
        synchronized (map4) {
            for (Map.Entry<String, ISuiteResult> entry : map.entrySet()) {
                iSuiteResultArray2 = entry.getKey();
                serializable = entry.getValue();
                ITestContext iTestContext = serializable.getTestContext();
                int n3 = iTestContext.getFailedTests().size();
                int n4 = iTestContext.getSkippedTests().size();
                int n5 = iTestContext.getPassedTests().size();
                if (n3 > 0) {
                    map2.put(iSuiteResultArray2, serializable);
                    continue;
                }
                if (n4 > 0) {
                    map3.put(iSuiteResultArray2, serializable);
                    continue;
                }
                if (n5 > 0) {
                    object.put(iSuiteResultArray2, serializable);
                    continue;
                }
                map2.put(iSuiteResultArray2, serializable);
            }
        }
        ISuiteResult[][] iSuiteResultArrayArray = new ISuiteResult[][]{this.sortResults(map2.values()), this.sortResults(map3.values()), this.sortResults(object.values())};
        String[] stringArray = new String[]{"failed", "skipped", "passed"};
        for (int i = 0; i < stringArray.length; ++i) {
            iSuiteResultArray2 = iSuiteResultArrayArray[i];
            for (Serializable serializable2 : iSuiteResultArray2) {
                String string = serializable2.getTestContext().getName();
                this.generateSuiteResult(string, (ISuiteResult)serializable2, stringArray[i], stringBuffer, this.m_outputDirectory);
            }
        }
        stringBuffer.append("</body></html>");
        Utils.writeFile(this.getOutputDirectory(xmlSuite), "toc.html", stringBuffer.toString());
    }

    private String pluralize(int n, String string) {
        return n > 1 ? (string.endsWith("s") ? string + "es" : string + "s") : string;
    }

    private String getOutputDirectory(XmlSuite xmlSuite) {
        File file = new File(this.m_outputDirectory + File.separatorChar + xmlSuite.getName()).getAbsoluteFile();
        if (!file.exists()) {
            file.mkdirs();
            if (!file.exists()) {
                Utils.log("Reports", 2, "Problem creating output directory " + file.getAbsolutePath());
            }
        }
        return file.getAbsolutePath();
    }

    private ISuiteResult[] sortResults(Collection<ISuiteResult> collection) {
        Object[] objectArray = collection.toArray(new ISuiteResult[collection.size()]);
        Arrays.sort(objectArray);
        return objectArray;
    }

    private void generateSuiteResult(String string, ISuiteResult iSuiteResult, String string2, StringBuffer stringBuffer, String string3) {
        ITestContext iTestContext = iSuiteResult.getTestContext();
        int n = iTestContext.getPassedTests().size();
        int n2 = iTestContext.getFailedTests().size();
        int n3 = iTestContext.getSkippedTests().size();
        String string4 = iTestContext.getName();
        stringBuffer.append("\n<table width='100%' class='test-").append(string2).append("'>\n").append("<tr><td>\n").append("<table style='width: 100%'><tr>").append("<td valign='top'>").append(string).append(" (").append(n).append("/").append(n2).append("/").append(n3).append(")").append("</td>").append("<td valign='top' align='right'>\n").append("  <a href='" + string4 + ".html' target='mainFrame'>Results</a>\n").append("</td>").append("</tr></table>\n").append("</td></tr><p/>\n");
        stringBuffer.append("</table>\n");
    }

    private void generateSuites(XmlSuite xmlSuite, ISuite iSuite) {
        Map<String, ISuiteResult> map = iSuite.getResults();
        for (ISuiteResult iSuiteResult : map.values()) {
            ITestContext iTestContext = iSuiteResult.getTestContext();
            StringBuffer stringBuffer = new StringBuffer();
            for (ISuiteResult iSuiteResult2 : map.values()) {
                stringBuffer.append(iSuiteResult2.toString());
            }
            Utils.writeFile(this.getOutputDirectory(xmlSuite), iTestContext.getName() + ".properties", stringBuffer.toString());
        }
    }
}

