/*
 * Decompiled with CFR 0.152.
 */
package org.testng.remote;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.osgi.framework.Version;
import org.testng.CommandLineArgs;
import org.testng.TestNGException;
import org.testng.remote.AbstractRemoteTestNG;
import org.testng.remote.IRemoteTestNG;
import org.testng.remote.RemoteArgs;
import org.testng.remote.support.RemoteTestNGFactory;
import org.testng.remote.support.ServiceLoaderHelper;

public class RemoteTestNG {
    public static final String DEBUG_PORT = "12345";
    public static final String DEBUG_SUITE_FILE = "testng-customsuite.xml";
    public static final String DEBUG_SUITE_DIRECTORY = System.getProperty("java.io.tmpdir");
    public static final String PROPERTY_DEBUG = "testng.eclipse.debug";
    public static final String PROPERTY_VERBOSE = "testng.eclipse.verbose";
    private static boolean m_debug;

    public static void main(String[] args) throws ParameterException {
        RemoteTestNGFactory factory;
        if (RemoteTestNG.isDebug()) {
            RemoteTestNG.dumpRevision();
        }
        CommandLineArgs cla = new CommandLineArgs();
        RemoteArgs ra = new RemoteArgs();
        new JCommander(Arrays.asList(cla, ra), args);
        Version ver = ra.version;
        if (ver == null) {
            ver = RemoteTestNG.getTestNGVersion();
        }
        RemoteTestNG.p("detected TestNG version " + ver);
        try {
            factory = ServiceLoaderHelper.getFirst(ver);
        }
        catch (TestNGException e) {
            throw e;
        }
        catch (Exception e) {
            if (RemoteTestNG.isDebug()) {
                e.printStackTrace();
            }
            factory = ServiceLoaderHelper.getFirstQuietly(ver);
        }
        IRemoteTestNG remoteTestNg = factory.createRemoteTestNG();
        remoteTestNg.dontExit(ra.dontExit);
        if (cla.port != null && ra.serPort != null) {
            throw new TestNGException("Can only specify one of -port and -serport");
        }
        m_debug = cla.debug;
        remoteTestNg.setDebug(cla.debug);
        remoteTestNg.setAck(ra.ack);
        if (m_debug) {
            RemoteTestNG.initAndRun(remoteTestNg, args, cla, ra);
        } else {
            RemoteTestNG.initAndRun(remoteTestNg, args, cla, ra);
        }
    }

    private static Version getTestNGVersion() {
        String strVer = null;
        try {
            strVer = RemoteTestNG.getVersionFromClass();
            return RemoteTestNG.toVersion(strVer);
        }
        catch (Exception e) {
            Version ver;
            block8: {
                if (RemoteTestNG.isDebug()) {
                    e.printStackTrace();
                }
                ver = null;
                try {
                    ver = RemoteTestNG.parseVersionFromPom();
                    if (ver == null) {
                        ver = RemoteTestNG.parseVersionFromManifest();
                    }
                }
                catch (Exception ex) {
                    if (!RemoteTestNG.isDebug()) break block8;
                    ex.printStackTrace();
                }
            }
            if (ver != null) {
                return ver;
            }
            if (strVer != null && strVer.contains("DEV-SNAPSHOT")) {
                return null;
            }
            throw new RuntimeException("Can't recognize the TestNG version on classpath. Please make sure that there's a supported TestNG version (aka. >= 6.0.0) on your project.");
        }
    }

    private static String getVersionFromClass() throws Exception {
        Class<?> clazz = Class.forName("org.testng.internal.Version");
        Field field = clazz.getDeclaredField("VERSION");
        return (String)field.get(null);
    }

    private static Version parseVersionFromPom() throws Exception {
        RemoteTestNG.p("now trying to parse the version from pom.properties");
        ClassLoader cl = RemoteTestNG.class.getClassLoader();
        Enumeration<URL> resources = cl.getResources("META-INF/maven/org.testng/testng/pom.properties");
        if (resources.hasMoreElements()) {
            Properties props = new Properties();
            try (InputStream in = resources.nextElement().openStream();){
                props.load(in);
            }
            return RemoteTestNG.toVersion(props.getProperty("version"));
        }
        return null;
    }

    private static Version parseVersionFromManifest() throws Exception {
        RemoteTestNG.p("now trying to parse the version from MANIFEST.MF");
        ClassLoader cl = RemoteTestNG.class.getClassLoader();
        Enumeration<URL> resources = cl.getResources("META-INF/MANIFEST.MF");
        while (resources.hasMoreElements()) {
            Manifest mf = new Manifest(resources.nextElement().openStream());
            Attributes mainAttrs = mf.getMainAttributes();
            if ("testng".equals(mainAttrs.getValue("Specification-Title"))) {
                return RemoteTestNG.toVersion(mainAttrs.getValue("Specification-Version"));
            }
            if ("org.testng".equals(mainAttrs.getValue("Bundle-SymbolicName"))) {
                return RemoteTestNG.toVersion(mainAttrs.getValue("Bundle-Version"));
            }
            if (!"org.testng.TestNG".equals(mainAttrs.getValue("Main-Class"))) continue;
            return RemoteTestNG.toVersion(mainAttrs.getValue("Implementation-Version"));
        }
        return null;
    }

    private static void initAndRun(IRemoteTestNG remoteTestNg, String[] args, CommandLineArgs cla, RemoteArgs ra) {
        if (m_debug) {
            ra.serPort = cla.port = Integer.valueOf(Integer.parseInt(DEBUG_PORT));
            cla.suiteFiles = Arrays.asList(DEBUG_SUITE_DIRECTORY + DEBUG_SUITE_FILE);
        }
        remoteTestNg.configure(cla);
        remoteTestNg.setHost(cla.host);
        remoteTestNg.setSerPort(ra.serPort);
        remoteTestNg.setProtocol(ra.protocol);
        remoteTestNg.setPort(cla.port);
        if (RemoteTestNG.isVerbose()) {
            StringBuilder sb = new StringBuilder("Invoked with ");
            for (String s : args) {
                sb.append(s).append(" ");
            }
            RemoteTestNG.p(sb.toString());
        }
        AbstractRemoteTestNG.validateCommandLineParameters(cla);
        remoteTestNg.run();
    }

    private static void p(String s) {
        if (RemoteTestNG.isVerbose()) {
            System.out.println("[RemoteTestNG] " + s);
        }
    }

    private static Version toVersion(String strVer) {
        int idx = strVer.indexOf("beta");
        if (idx > 0) {
            strVer = strVer.substring(0, idx);
        }
        if ((idx = strVer.indexOf("-SNAPSHOT")) > 0) {
            strVer = strVer.substring(0, idx);
        }
        return Version.parseVersion(strVer);
    }

    public static boolean isVerbose() {
        boolean result = System.getProperty(PROPERTY_VERBOSE) != null || RemoteTestNG.isDebug();
        return result;
    }

    public static boolean isDebug() {
        return m_debug || System.getProperty(PROPERTY_DEBUG) != null;
    }

    public static void dumpRevision() {
        ClassLoader cl = RemoteTestNG.class.getClassLoader();
        Properties props = new Properties();
        try (InputStream in = cl.getResourceAsStream("revision.properties");){
            props.load(in);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("[RemoteTestNG] revisions:");
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            System.out.println("\t" + entry.getKey() + "=" + entry.getValue());
        }
    }
}

