/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.adaptor;

import com.google.clearsilver.jsilver.JSilver;
import com.google.clearsilver.jsilver.adaptor.JHdf;
import com.google.clearsilver.jsilver.adaptor.LoadPathToFileCache;
import com.google.clearsilver.jsilver.adaptor.ResourceLoaderAdaptor;
import com.google.clearsilver.jsilver.autoescape.EscapeMode;
import com.google.clearsilver.jsilver.data.Data;
import com.google.clearsilver.jsilver.data.LocalAndGlobalData;
import com.google.clearsilver.jsilver.exceptions.JSilverIOException;
import com.google.clearsilver.jsilver.resourceloader.ResourceLoader;
import com.google.clearsilver.jsilver.template.HtmlWhiteSpaceStripper;
import com.google.clearsilver.jsilver.template.Template;
import java.io.IOException;
import org.clearsilver.CS;
import org.clearsilver.CSFileLoader;
import org.clearsilver.HDF;

class JCs
implements CS {
    private final JHdf localHdf;
    private JHdf globalHdf;
    private final JSilver jSilver;
    private final LoadPathToFileCache loadPathCache;
    private Template template = null;
    private CSFileLoader csFileLoader;
    private ResourceLoaderAdaptor resourceLoaderAdaptor;

    JCs(JHdf hdf, JSilver jSilver, LoadPathToFileCache loadPathCache) {
        this.localHdf = hdf;
        this.jSilver = jSilver;
        this.loadPathCache = loadPathCache;
        this.resourceLoaderAdaptor = this.localHdf.getResourceLoaderAdaptor();
        this.csFileLoader = this.resourceLoaderAdaptor.getCSFileLoader();
    }

    private JSilver getJSilver() {
        return this.jSilver;
    }

    public void setGlobalHDF(HDF global) {
        this.globalHdf = JHdf.cast(global);
    }

    public HDF getGlobalHDF() {
        return this.globalHdf;
    }

    public void close() {
        this.template = null;
    }

    public void parseFile(String filename) throws IOException {
        try {
            if (this.getEscapeMode().isAutoEscapingMode() && this.localHdf.getData().getValue("Config.PropagateEscapeStatus") != null) {
                throw new IllegalArgumentException("Config.PropagateEscapeStatus does not work with JSilver.Use JSilverOptions.setPropagateEscapeStatus instead");
            }
            this.template = this.getJSilver().getTemplateLoader().load(filename, this.resourceLoaderAdaptor, this.getEscapeMode());
        }
        catch (RuntimeException e) {
            RuntimeException th = e;
            if (th instanceof JSilverIOException) {
                throw (IOException)th.getCause();
            }
            throw e;
        }
    }

    public void parseStr(String content) {
        if (this.getEscapeMode().isAutoEscapingMode() && this.localHdf.getData().getValue("Config.PropagateEscapeStatus") != null) {
            throw new IllegalArgumentException("Config.PropagateEscapeStatus does not work with JSilver.Use JSilverOptions.setPropagateEscapeStatus instead");
        }
        this.template = this.getJSilver().getTemplateLoader().createTemp("parseStr", content, this.getEscapeMode());
    }

    private EscapeMode getEscapeMode() {
        Data data = this.localHdf.getData();
        return this.getJSilver().getEscapeMode(data);
    }

    public String render() {
        if (this.template == null) {
            throw new IllegalStateException("Call parseFile() or parseStr() before render()");
        }
        Data data = this.globalHdf != null ? new LocalAndGlobalData(this.localHdf.getData(), this.globalHdf.getData(), this.jSilver.getOptions().getAllowGlobalDataModification()) : this.localHdf.getData();
        Appendable buffer = this.jSilver.createAppendableBuffer();
        try {
            Appendable output = buffer;
            int wsStripLevel = this.localHdf.getIntValue("ClearSilver.WhiteSpaceStrip", 0);
            if (wsStripLevel > 0) {
                output = new HtmlWhiteSpaceStripper(output, wsStripLevel);
            }
            this.jSilver.render(this.template, data, output, (ResourceLoader)this.resourceLoaderAdaptor);
            String string = output.toString();
            return string;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        finally {
            this.jSilver.releaseAppendableBuffer(buffer);
        }
    }

    public CSFileLoader getFileLoader() {
        return this.csFileLoader;
    }

    public void setFileLoader(CSFileLoader fileLoader) {
        if (fileLoader == null && this.csFileLoader == null) {
            return;
        }
        if (fileLoader != null && fileLoader.equals(this.csFileLoader)) {
            return;
        }
        this.csFileLoader = fileLoader;
        this.resourceLoaderAdaptor = new ResourceLoaderAdaptor(this.localHdf, this.loadPathCache, this.csFileLoader);
    }
}

